/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.annotations.VisibleForTesting;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.impl.StaticLoggerBinder;

public class LoggerConfiguration
implements Comparable<LoggerConfiguration> {
    @VisibleForTesting
    static final String NAME_KEY = "name";
    @VisibleForTesting
    static final String CONFIGURED_LEVEL_KEY = "configuredLevel";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
    private String name;
    private Level configuredLevel;

    public static List<LoggerConfiguration> getLoggerConfigurations() {
        return LOGGER_CONTEXT.getLoggerList().stream().map(LoggerConfiguration::getLoggerConfiguration).sorted().collect(Collectors.toList());
    }

    public static LoggerConfiguration getLoggerConfiguration(String loggerName) {
        return LoggerConfiguration.getLoggerConfiguration(LOGGER_CONTEXT.getLogger(loggerName));
    }

    public static LoggerConfiguration getLoggerConfiguration(Logger logger) {
        return new LoggerConfiguration(logger.getName(), logger.getLevel());
    }

    public LoggerConfiguration() {
        this(null);
    }

    public LoggerConfiguration(String name) {
        this(name, (Level)null);
    }

    public LoggerConfiguration(String name, String configuredLevel) {
        this(name, configuredLevel != null ? Level.toLevel((String)configuredLevel) : null);
    }

    public LoggerConfiguration(String name, Level configuredLevel) {
        this.name = name;
        this.configuredLevel = configuredLevel;
    }

    public String getName() {
        return this.name;
    }

    public LoggerConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Logger getLogger() {
        return LOGGER_CONTEXT.getLogger(this.name);
    }

    public Level getConfiguredLevel() {
        return this.configuredLevel;
    }

    public LoggerConfiguration setConfiguredLevel(String configuredLevel) {
        return this.setConfiguredLevel(configuredLevel != null ? Level.toLevel((String)configuredLevel) : null);
    }

    public LoggerConfiguration setConfiguredLevel(Level configuredLevel) {
        this.configuredLevel = configuredLevel;
        return this;
    }

    public LoggerConfiguration applyConfiguredLevel() {
        this.setEffectiveLevel(this.getConfiguredLevel());
        return this;
    }

    public Level getEffectiveLevel() {
        return Optional.ofNullable(this.getLogger()).map(Logger::getEffectiveLevel).orElse(null);
    }

    public LoggerConfiguration setEffectiveLevel(String effectiveLevel) {
        return this.setEffectiveLevel(effectiveLevel != null ? Level.toLevel((String)effectiveLevel) : null);
    }

    public LoggerConfiguration setEffectiveLevel(Level effectiveLevel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Changing log level for {} from {} to {}.", new Object[]{this.getName(), this.getEffectiveLevel(), effectiveLevel});
        }
        Optional.ofNullable(this.getLogger()).ifPresent(logger -> logger.setLevel(effectiveLevel));
        return this;
    }

    public LoggerConfiguration copy() {
        return new LoggerConfiguration(this.name, this.configuredLevel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LoggerConfiguration) {
            LoggerConfiguration other = (LoggerConfiguration)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.configuredLevel, other.configuredLevel);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.configuredLevel);
    }

    public String toString() {
        return "LoggerConfiguration [name=" + this.name + ", configuredLevel=" + this.configuredLevel + "]";
    }

    @Override
    public int compareTo(LoggerConfiguration other) {
        if ("ROOT".equals(this.getName())) {
            return -1;
        }
        if ("ROOT".equals(other.getName()) || this.getName() == null) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public JsonObject toJson() {
        return new JsonObject().put(NAME_KEY, (Object)this.name).put(CONFIGURED_LEVEL_KEY, this.configuredLevel != null ? this.configuredLevel.levelStr : null);
    }

    public static LoggerConfiguration fromJson(JsonObject json) {
        return new LoggerConfiguration(json.getString(NAME_KEY), json.getString(CONFIGURED_LEVEL_KEY));
    }
}

