/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.Measured;
import io.vertx.micrometer.MetricsService;
import java.util.concurrent.TimeUnit;

public class MetricsVerticle
extends AbstractVerticle {
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    @VisibleForTesting
    private final long metricsPeriod;

    public MetricsVerticle(long interval, TimeUnit unit) {
        this.metricsPeriod = unit.toMillis(interval);
    }

    public void start() {
        this.vertx.setPeriodic(this.metricsPeriod, t -> {
            MetricsService metricsService;
            JsonObject metrics;
            if (LOGGER.isTraceEnabled() && (metrics = (metricsService = MetricsService.create((Measured)this.vertx)).getMetricsSnapshot()) != null) {
                LOGGER.trace("Metrics: {}", metrics);
            }
        });
    }
}

