/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.endpoint.MountableEndpoint;
import io.neonbee.handler.ErrorHandler;
import io.neonbee.internal.handler.ChainAuthHandler;
import io.neonbee.internal.handler.DefaultErrorHandler;
import io.neonbee.internal.handler.NotFoundHandler;
import io.neonbee.internal.handler.factories.RoutingHandlerFactory;
import io.neonbee.internal.helper.AsyncHelper;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerVerticle
extends AbstractVerticle {
    public static final String SERVER_CONFIG_KEY = "__ServerVerticleConfig__";
    @VisibleForTesting
    static final String DEFAULT_ERROR_HANDLER_CLASS_NAME = DefaultErrorHandler.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpServer httpServer;

    public void start(Promise<Void> startPromise) {
        NeonBee.get(this.vertx).getLocalMap().put((Object)SERVER_CONFIG_KEY, (Object)this.config());
        ServerConfig config = new ServerConfig(this.config());
        this.createRouter(config).compose(router -> {
            Optional<ChainAuthHandler> defaultAuthHandler = Optional.ofNullable(config.getAuthChainConfig()).map(c -> ChainAuthHandler.create(this.vertx, c));
            return this.mountEndpoints((Router)router, config.getEndpointConfigs(), defaultAuthHandler).onSuccess(v -> router.route().handler((Handler)new NotFoundHandler())).compose(v -> this.createHttpServer((Router)router, config));
        }).mapEmpty().onComplete(startPromise);
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
        (this.httpServer != null ? this.httpServer.close().onComplete(result -> LOGGER.info("HTTP server was stopped")) : Future.succeededFuture().mapEmpty()).onComplete(stopPromise);
    }

    private Future<Router> createRouter(ServerConfig config) {
        Router router = Router.router((Vertx)this.vertx);
        Route rootRoute = router.route();
        return ServerVerticle.createErrorHandler(config.getErrorHandlerClassName(), this.vertx).onSuccess(arg_0 -> ((Route)rootRoute).failureHandler(arg_0)).compose(unused -> {
            List handlerFutures = config.getHandlerFactoriesClassNames().stream().map(ServerVerticle::instantiateHandler).collect(Collectors.toList());
            return CompositeFuture.all(handlerFutures);
        }).compose(compositeFuture -> {
            List handlers = compositeFuture.list();
            handlers.forEach(routingContextHandler -> {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Appending \"{}\" request handler to root router.", (Object)routingContextHandler.getClass().getName());
                }
                rootRoute.handler(routingContextHandler);
            });
            return Future.succeededFuture((Object)router);
        }).onFailure(e -> LOGGER.error("Router could not be created", e));
    }

    @VisibleForTesting
    static Future<ErrorHandler> createErrorHandler(String className, Vertx vertx) {
        try {
            Class<?> classObject = Class.forName(Optional.ofNullable(className).filter(Predicate.not(String::isBlank)).orElse(DEFAULT_ERROR_HANDLER_CLASS_NAME));
            ErrorHandler eh = (ErrorHandler)classObject.getConstructor(new Class[0]).newInstance(new Object[0]);
            return eh.initialize(NeonBee.get(vertx)).onFailure(t -> LOGGER.error("ErrorHandler could not be initialized", t));
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("The custom ErrorHandler must offer a default constructor.", (Throwable)e);
            return Future.failedFuture((Throwable)e);
        }
        catch (Exception e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    @VisibleForTesting
    static Future<Handler<RoutingContext>> instantiateHandler(String handlerFactoryName) {
        try {
            Class<?> factoryClass = Class.forName(handlerFactoryName);
            if (!RoutingHandlerFactory.class.isAssignableFrom(factoryClass)) {
                return Future.failedFuture((String)("Class \"" + handlerFactoryName + "\" is not an instance of " + RoutingHandlerFactory.class.getName()));
            }
            RoutingHandlerFactory factoryInstance = (RoutingHandlerFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return factoryInstance.createHandler();
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate Handler: {}", (Object)handlerFactoryName, (Object)e);
            return Future.failedFuture((Throwable)e);
        }
    }

    private Future<HttpServer> createHttpServer(Router router, ServerConfig config) {
        Optional.ofNullable(NeonBee.get(this.vertx).getOptions().getServerPort()).ifPresent(config::setPort);
        return this.vertx.createHttpServer((HttpServerOptions)config).exceptionHandler(throwable -> LOGGER.error("HTTP Socket Exception", throwable)).requestHandler((Handler)router).listen().onSuccess(httpServer -> {
            this.httpServer = httpServer;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("HTTP server started on port {}", (Object)httpServer.actualPort());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("HTTP server configured with routes: {}", (Object)router.getRoutes().stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }).onFailure(cause -> LOGGER.error("HTTP server could not be started", cause));
    }

    @VisibleForTesting
    protected Future<Void> mountEndpoints(Router router, List<EndpointConfig> endpointConfigs, Optional<ChainAuthHandler> defaultAuthHandler) {
        if (endpointConfigs.isEmpty()) {
            LOGGER.warn("No endpoints configured");
            return Future.succeededFuture();
        }
        List mountableEndpoints = endpointConfigs.stream().map(ec -> MountableEndpoint.create(this.vertx, ec)).collect(Collectors.toList());
        return AsyncHelper.allComposite(mountableEndpoints).onSuccess(v -> {
            for (Future endpointFuture : mountableEndpoints) {
                ((MountableEndpoint)endpointFuture.result()).mount(this.vertx, router, defaultAuthHandler);
            }
        }).mapEmpty();
    }
}

