/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.internal.helper.AsyncHelper;
import io.neonbee.internal.helper.FileSystemHelper;
import io.neonbee.internal.helper.FunctionalHelper;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class WatchVerticle
extends AbstractVerticle {
    public static final int DEFAULT_CHECK_INTERVAL = 500;
    @VisibleForTesting
    static final String WATCH_LOGIC_KEY = "watchLogic";
    @VisibleForTesting
    static final String WATCH_LOGIC_OPTION_COPY = "copy";
    private static final LoggingFacade LOGGER = LoggingFacade.create();
    private static final long UNDEPLOY_DELAY = 50L;
    @VisibleForTesting
    final long watchPeriodMillis;
    final Map<Path, WatchKey> watchKeys = new HashMap<Path, WatchKey>();
    private final Path watchPath;
    private WatchService watcher;
    private final boolean parallelProcessing;
    private final boolean handleExisting;
    private final String counterName = UUID.randomUUID().toString();

    public static boolean isCopyLogic(JsonObject config) {
        String value = Optional.ofNullable(config).orElse(new JsonObject()).getString(WATCH_LOGIC_KEY);
        return Optional.ofNullable(value).map(WATCH_LOGIC_OPTION_COPY::equalsIgnoreCase).orElse(false);
    }

    public WatchVerticle(Path watchPath) {
        this(watchPath, 500L, TimeUnit.MILLISECONDS, true, true);
    }

    public WatchVerticle(Path watchPath, long interval, TimeUnit unit, boolean parallelProcessing, boolean handleExisting) {
        this.watchPeriodMillis = unit.toMillis(interval);
        this.watchPath = watchPath.toAbsolutePath();
        this.parallelProcessing = parallelProcessing;
        this.handleExisting = handleExisting;
    }

    public void start(Promise<Void> startPromise) {
        Vertx vertx = this.getVertx();
        if (NeonBee.get(vertx).getOptions().doNotWatchFiles()) {
            startPromise.complete();
            vertx.setTimer(50L, timerId -> vertx.undeploy(this.deploymentID()).onFailure(throwable -> LOGGER.error("Failed to undeploy watch verticle", (Throwable)throwable)));
            return;
        }
        try {
            this.watcher = this.watchPath.getFileSystem().newWatchService();
        }
        catch (IOException e) {
            startPromise.fail((Throwable)e);
            return;
        }
        (this.handleExisting ? this.handleExistingFiles(this.watchPath) : this.registerWatchKey(this.watchPath)).compose(nothing -> vertx.sharedData().getLocalCounter(this.counterName)).onSuccess(counter -> vertx.setPeriodic(this.watchPeriodMillis, l -> {
            if (this.parallelProcessing) {
                this.checkForChanges();
            } else {
                counter.compareAndSet(0L, 1L).onSuccess(result -> {
                    if (result.booleanValue()) {
                        this.checkForChanges().onComplete(nothing -> counter.compareAndSet(1L, 0L));
                    }
                });
            }
        })).mapEmpty().onComplete(startPromise);
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                stopPromise.fail((Throwable)e);
                return;
            }
        }
        stopPromise.complete();
    }

    private Future<Void> handleExistingFiles(Path dir) {
        ArrayList futuresToResolve = new ArrayList();
        return this.registerWatchKey(dir).compose(v -> FileSystemHelper.readDir(this.vertx, dir)).compose(dirContent -> this.handleFileEvents((List<Path>)dirContent, futuresToResolve)).compose(fileFutures -> CompositeFuture.all((List)((List)FunctionalHelper.uncheckedMapper(fileFutures))).compose(compFut -> CompositeFuture.all((List)((List)FunctionalHelper.uncheckedMapper(futuresToResolve)))).mapEmpty());
    }

    private Future<List<Future<Void>>> handleFileEvents(List<Path> dirContent, List<Future<Void>> futuresToResolve) {
        return Future.succeededFuture(dirContent.stream().map(path -> FileSystemHelper.isDirectory(this.vertx, path).compose(isDirectory -> {
            futuresToResolve.add(this.processEvent((Path)path, StandardWatchEventKinds.ENTRY_CREATE));
            futuresToResolve.add(this.processEvent((Path)path, StandardWatchEventKinds.ENTRY_MODIFY));
            if (isDirectory.booleanValue()) {
                futuresToResolve.add(this.handleExistingFiles((Path)path));
            }
            return Future.succeededFuture((Object)null);
        })).collect(Collectors.toList()));
    }

    private Future<Void> handleWatchKeyEvents(Path watchKeyPath, WatchKey watchKey) {
        List<WatchEvent<?>> events = watchKey.pollEvents();
        ArrayList<Future<Void>> watchEventFutures = new ArrayList<Future<Void>>(events.size());
        for (WatchEvent<?> event : events) {
            Path affectedPath = watchKeyPath.resolve(event.context().toString());
            watchEventFutures.add(this.processEvent(affectedPath, event.kind()));
        }
        return AsyncHelper.joinComposite(watchEventFutures).onComplete(asyncCompFuture -> this.watchKeys.get(this.watchPath).reset()).mapEmpty();
    }

    @VisibleForTesting
    Future<Void> checkForChanges() {
        Map<Path, WatchKey> tempWatchKeys = Map.copyOf(this.watchKeys);
        ArrayList<Future<Void>> watchKeyFutures = new ArrayList<Future<Void>>(tempWatchKeys.size());
        for (Map.Entry<Path, WatchKey> entry : tempWatchKeys.entrySet()) {
            watchKeyFutures.add(this.handleWatchKeyEvents(entry.getKey(), entry.getValue()));
        }
        return AsyncHelper.joinComposite(watchKeyFutures).mapEmpty();
    }

    private Future<Void> registerWatchKey(Path affectedPath) {
        try {
            this.watchKeys.put(affectedPath, affectedPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY));
            return Future.succeededFuture();
        }
        catch (IOException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private Future<Void> processEvent(Path affectedPath, WatchEvent.Kind<?> kind) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Observed WatchEvent of kind '{}' for Path '{}'", kind.name(), affectedPath);
        }
        Promise promise = Promise.promise();
        if (StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) {
            FileSystemHelper.isDirectory(this.vertx, affectedPath).compose(isDirectory -> {
                if (isDirectory.booleanValue()) {
                    return this.registerWatchKey(affectedPath);
                }
                return Future.succeededFuture();
            }).onComplete(asyncRegisterResult -> {
                if (asyncRegisterResult.failed()) {
                    promise.fail(asyncRegisterResult.cause());
                } else {
                    this.observedCreate(affectedPath, (Promise<Void>)promise);
                }
            });
        } else if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
            Optional.ofNullable(this.watchKeys.remove(affectedPath)).ifPresent(WatchKey::cancel);
            this.observedDelete(affectedPath, (Promise<Void>)promise);
        } else if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
            this.observedModify(affectedPath, (Promise<Void>)promise);
        } else if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
            promise.complete();
        } else {
            LOGGER.warn("Unknown WatchEvent kind '{}' for Path '{}'", kind, affectedPath);
            promise.complete();
        }
        return promise.future();
    }

    public void observedCreate(Path affectedPath) {
    }

    public void observedCreate(Path affectedPath, Promise<Void> finishPromise) {
        this.observedCreate(affectedPath);
        finishPromise.complete();
    }

    public void observedDelete(Path affectedPath) {
    }

    public void observedDelete(Path affectedPath, Promise<Void> finishPromise) {
        this.observedDelete(affectedPath);
        finishPromise.complete();
    }

    public void observedModify(Path affectedPath) {
    }

    public void observedModify(Path affectedPath, Promise<Void> finishPromise) {
        this.observedModify(affectedPath);
        finishPromise.complete();
    }
}

