/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.ImmutableMap;
import com.sap.cds.CdsException;
import com.sap.cds.JSONizable;
import com.sap.cds.Row;
import com.sap.cds.Struct;
import com.sap.cds.impl.ProxyList;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.CdsPath;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class ProxyCreator
implements Struct.ProxyFactory {
    private static final ConcurrentMap<Method, Type> GENERIC_RETURN_TYPE = new ConcurrentHashMap<Method, Type>();
    private static final ConcurrentMap<Class<?>, ImmutableMap<Method, Delegate>> CLASS_MAPPING_RETURN_TYPE = new ConcurrentHashMap();
    private static final Method JSONIZABLE_TO_JSON;
    private static final Method EQUALS;

    private static <K, V> V createIfAbsentPreferGet(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> provider) {
        V r;
        Object res = map.get(key);
        if (res == null && (res = map.putIfAbsent(key, r = provider.apply(key))) == null) {
            res = r;
        }
        return res;
    }

    private static Type getGenericReturnType(Method method) {
        return ProxyCreator.createIfAbsentPreferGet(GENERIC_RETURN_TYPE, method, m -> m.getGenericReturnType());
    }

    public <T> T proxy(Map<String, Object> data, Class<T> proxyInterface) {
        return ProxyCreator.createProxy(data, proxyInterface);
    }

    static <T> T createProxy(Map<String, Object> data, Class<T> proxyInterface) {
        return ProxyCreator.createProxy(data, proxyInterface, (Map)ProxyCreator.createIfAbsentPreferGet(CLASS_MAPPING_RETURN_TYPE, proxyInterface, ProxyCreator::createMapping));
    }

    static <T> T createProxy(Map<String, Object> data, Class<T> proxyInterface, Map<Method, Delegate> mapping) {
        Row row = data instanceof Row ? (Row)data : RowImpl.row(data);
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new MapProxy(row, mapping));
    }

    static ImmutableMap<Method, Delegate> createMapping(Class<?> type) {
        ImmutableMap.Builder delegates = Arrays.stream(type.getDeclaredMethods()).collect(ImmutableMap::builder, (builder, method) -> {
            Delegate delegate = ProxyCreator.delegate(method);
            if (delegate != null) {
                builder.put(method, (Object)delegate);
            }
        }, (b1, b2) -> b1.putAll((Map)b2.build()));
        ProxyCreator.registerToJson(type, (ImmutableMap.Builder<Method, Delegate>)delegates);
        ProxyCreator.registerEquals((ImmutableMap.Builder<Method, Delegate>)delegates);
        return delegates.build();
    }

    private static void registerToJson(Class<?> type, ImmutableMap.Builder<Method, Delegate> delegates) {
        if (JSONizable.class.isAssignableFrom(type)) {
            delegates.put((Object)JSONIZABLE_TO_JSON, (data, a, p) -> Jsonizer.json(data));
        }
    }

    private static void registerEquals(ImmutableMap.Builder<Method, Delegate> delegates) {
        delegates.put((Object)EQUALS, (data, a, p) -> {
            Object other = a[0];
            if (p == other) {
                return true;
            }
            return data.equals(other);
        });
    }

    private static Delegate delegate(Method method) {
        if ("ref".equals(method.getName()) && method.getParameterCount() == 0) {
            return (row, a, p) -> {
                Class<?> type = method.getReturnType();
                return StructuredTypeProxy.create(row.ref(), type);
            };
        }
        if (ProxyCreator.isGetter(method)) {
            Delegate getter = ProxyCreator.getter(method);
            Class<?> type = method.getReturnType();
            if (Map.class.isAssignableFrom(type) && Map.class != type) {
                return ProxyCreator.proxyMap(getter, type);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return ProxyCreator.proxyList(method, getter);
            }
            return getter;
        }
        if (ProxyCreator.isSetter(method)) {
            return ProxyCreator.setter(method);
        }
        return null;
    }

    private static Delegate getter(Method method) {
        String path = ProxyCreator.cdsPath(method);
        if (path != null) {
            return (data, a, p) -> data.getPath(path);
        }
        String name = ProxyCreator.cdsName(method);
        return (data, a, p) -> data.getPath(name);
    }

    private static Delegate setter(Method method) {
        String path = ProxyCreator.cdsPath(method);
        if (path != null) {
            return ProxyCreator.setter(path);
        }
        String name = ProxyCreator.cdsName(method);
        return ProxyCreator.setter(name);
    }

    private static Delegate setter(String path) {
        return (data, a, p) -> {
            data.putPath(path, a[0]);
            return p;
        };
    }

    private static String cdsPath(Method method) {
        CdsPath annotation = method.getAnnotation(CdsPath.class);
        return annotation != null ? annotation.value() : null;
    }

    private static String cdsName(Method method) {
        CdsName annotation = method.getAnnotation(CdsName.class);
        return annotation != null ? annotation.value() : ProxyCreator.propertyName(method);
    }

    private static Delegate proxyMap(Delegate getter, Class<?> type) {
        return (data, a, p) -> {
            Object value = getter.invoke(data, a, p);
            if (value == null || value instanceof Proxy) {
                return value;
            }
            return ProxyCreator.createProxy((Map)value, type);
        };
    }

    private static Delegate proxyList(Method method, Delegate getter) {
        Type returnType = ProxyCreator.getGenericReturnType(method);
        if (returnType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
                return (data, a, p) -> {
                    Object list = getter.invoke(data, a, p);
                    return list == null ? null : new ProxyList((List)list, (Class)type);
                };
            }
            return getter;
        }
        throw new CdsException("Return type of accessor interface method " + method.getName() + " must be parameterized");
    }

    private static String propertyName(Method method) {
        String key = method.getName();
        if (key.length() > 3 && (key.startsWith("set") || key.startsWith("get"))) {
            key = ProxyCreator.lowercaseFromThird(key);
        }
        return key;
    }

    private static String lowercaseFromThird(String s) {
        char[] c = s.toCharArray();
        c[3] = Character.toLowerCase(c[3]);
        return new String(c, 3, s.length() - 3);
    }

    private static boolean isGetter(Method method) {
        return method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isSetter(Method method) {
        return method.getParameterCount() == 1 && (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(method.getDeclaringClass()));
    }

    static {
        try {
            JSONIZABLE_TO_JSON = JSONizable.class.getDeclaredMethod("toJson", new Class[0]);
            EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError("JSONizable::toJson must exist", e);
        }
    }

    private static class MapProxy
    implements InvocationHandler {
        private final Row row;
        private final Map<Method, Delegate> delegates;

        protected MapProxy(Row row, Map<Method, Delegate> delegates) {
            this.row = row;
            this.delegates = delegates;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Delegate delegate = this.delegates.get(method);
            if (delegate != null) {
                return delegate.invoke(this.row, args, proxy);
            }
            try {
                return method.invoke((Object)this.row, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new CdsException("Failed to invoke method " + method.getName(), (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    static interface Delegate {
        public Object invoke(Row var1, Object[] var2, Object var3);
    }
}

