/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArithmeticExpr
extends AbstractValue<Number>
implements CqnArithmeticExpression {
    private final CqnValue left;
    private final CqnArithmeticExpression.Operator op;
    private final CqnValue right;

    private ArithmeticExpr(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    public static Value<Number> expression(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right) {
        return new ArithmeticExpr(left, op, right);
    }

    public static Value<Number> plus(CqnValue left, CqnValue right) {
        return ArithmeticExpr.expression(left, CqnArithmeticExpression.Operator.ADD, right);
    }

    public static Value<Number> minus(CqnValue left, CqnValue right) {
        return ArithmeticExpr.expression(left, CqnArithmeticExpression.Operator.SUB, right);
    }

    public static Value<Number> times(CqnValue left, CqnValue right) {
        return ArithmeticExpr.expression(left, CqnArithmeticExpression.Operator.MUL, right);
    }

    public static Value<Number> dividedBy(CqnValue left, CqnValue right) {
        return ArithmeticExpr.expression(left, CqnArithmeticExpression.Operator.DIV, right);
    }

    public CqnValue left() {
        return this.left;
    }

    public CqnArithmeticExpression.Operator operator() {
        return this.op;
    }

    public CqnValue right() {
        return this.right;
    }

    public Stream<CqnToken> tokens() {
        CqnTokenListBuilder tokens = new CqnTokenListBuilder();
        tokens.addAll(this.tokens(this.left, (p1, p2) -> p1 < p2));
        tokens.add(this.op.symbol());
        tokens.addAll(this.tokens(this.right, (p1, p2) -> p1 <= p2));
        return tokens.stream();
    }

    private Stream<CqnToken> tokens(CqnValue val, BiFunction<Integer, Integer, Boolean> parenCheck) {
        CqnArithmeticExpression.Operator operator;
        if (val.isExpression() && val.asExpression().isArithmeticExpression() && parenCheck.apply(ArithmeticExpr.precedence(operator = val.asExpression().asArithmeticExpression().operator()), ArithmeticExpr.precedence(this.op)).booleanValue()) {
            CqnTokenListBuilder builder = new CqnTokenListBuilder();
            builder.addAll(val.tokens());
            builder.surroundWithParentheses();
            return builder.stream();
        }
        return val.tokens();
    }

    private static int precedence(CqnArithmeticExpression.Operator op) {
        if (op == CqnArithmeticExpression.Operator.MUL || op == CqnArithmeticExpression.Operator.DIV) {
            return 1;
        }
        return 0;
    }

    @Override
    protected Jsonizer json() {
        return Jsonizer.object("xpr", this.tokens().collect(Collectors.toList()));
    }
}

