/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnArithmeticNegation;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.math.BigDecimal;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArithmeticNegation
extends AbstractValue<Number>
implements CqnArithmeticNegation {
    private final CqnValue value;

    private ArithmeticNegation(CqnValue value) {
        this.value = value;
    }

    public static Value<Number> negate(CqnValue value) {
        if (value.isExpression() && value.asExpression().isNegation()) {
            return (Value)value.asExpression().asNegation().value();
        }
        if (value.isLiteral()) {
            Object o = value.asLiteral().value();
            if (o instanceof BigDecimal) {
                return LiteralImpl.val(BigDecimal.ZERO.subtract((BigDecimal)o));
            }
            if (o instanceof Number) {
                Number val = (Number)o;
                try {
                    if (val instanceof Integer) {
                        return LiteralImpl.val(Math.negateExact(val.intValue()));
                    }
                    if (val instanceof Long) {
                        return LiteralImpl.val(Math.negateExact(val.longValue()));
                    }
                    if (val instanceof Float) {
                        return LiteralImpl.val(Float.valueOf(-val.floatValue()));
                    }
                    if (val instanceof Double) {
                        return LiteralImpl.val(-val.doubleValue());
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }
        return new ArithmeticNegation(value);
    }

    public CqnValue value() {
        return this.value;
    }

    public boolean isNegation() {
        return true;
    }

    public CqnArithmeticNegation asNegation() {
        return this;
    }

    public Stream<CqnToken> tokens() {
        CqnTokenListBuilder builder = new CqnTokenListBuilder();
        if (this.value instanceof CqnArithmeticExpression) {
            return builder.add((CqnValue)CqnPlainImpl.MINUS).add((CqnValue)CqnPlainImpl.LPAREN).add(this.value).add((CqnValue)CqnPlainImpl.RPAREN).stream();
        }
        return builder.add((CqnValue)CqnPlainImpl.MINUS).add(this.value).stream();
    }

    @Override
    protected Jsonizer json() {
        return Jsonizer.object("xpr", this.tokens().collect(Collectors.toList()));
    }
}

