/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Connective;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Disjunction
extends Connective {
    public Disjunction(List<? extends CqnPredicate> predicates) {
        super(CqnConnectivePredicate.Operator.OR, predicates);
    }

    public Disjunction(CqnPredicate p1, CqnPredicate p2) {
        super(CqnConnectivePredicate.Operator.OR, p1, p2);
    }

    @Override
    public Predicate or(CqnPredicate other, CqnPredicate ... more) {
        this.predicates.add(other);
        this.or(more);
        return this;
    }

    public Predicate or(CqnPredicate ... p) {
        this.predicates.addAll(Arrays.asList(p));
        return this;
    }

    @Override
    public Predicate not() {
        return this.negatedPredicates().collect(Conjunction._and());
    }

    public static CqnPredicate or(CqnPredicate p1, CqnPredicate p2) {
        if (p1 == CqnBoolLiteral.TRUE || p2 == CqnBoolLiteral.TRUE) {
            return CqnBoolLiteral.TRUE;
        }
        if (p1 == CqnBoolLiteral.FALSE) {
            return p2;
        }
        if (p2 == CqnBoolLiteral.FALSE) {
            return p1;
        }
        return new Disjunction(p1, p2);
    }

    public static Predicate or(Predicate p1, Predicate p2) {
        if (p1 == CqnBoolLiteral.TRUE || p2 == CqnBoolLiteral.TRUE) {
            return CqnBoolLiteral.TRUE;
        }
        if (p1 == CqnBoolLiteral.FALSE) {
            return p2;
        }
        if (p2 == CqnBoolLiteral.FALSE) {
            return p1;
        }
        return new Disjunction((CqnPredicate)p1, (CqnPredicate)p2);
    }

    public static Collector<CqnPredicate, ?, CqnPredicate> or() {
        return Collectors.reducing(CqnBoolLiteral.FALSE, Disjunction::or);
    }

    public static Collector<Predicate, ?, Predicate> _or() {
        return Collectors.reducing(CqnBoolLiteral.FALSE, Disjunction::or);
    }

    @Override
    protected CqnToken identityToken() {
        return CqnBoolLiteral.FALSE;
    }

    @Override
    protected Stream<CqnToken> operatorTokens(CqnPredicate pred) {
        return new CqnTokenListBuilder().add((CqnValue)CqnPlainImpl.OR).add((CqnExpression)pred).stream();
    }
}

