/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.SearchPredicate;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ExpressionImpl {
    private ExpressionImpl() {
    }

    public static Predicate byParams(Collection<String> elementRefs) {
        return ExpressionImpl.matching(elementRefs.stream().collect(Collectors.toMap(p -> p, p -> CQL.param((String)p))));
    }

    public static Predicate matching(Map<String, ?> values) {
        ArrayList preds = new ArrayList();
        values.forEach((k, v) -> {
            if (ExpressionImpl.isSimple(v)) {
                preds.add(ElementRefImpl.parse(k).eq(v));
            }
        });
        return (Predicate)ExpressionImpl.join(preds);
    }

    public static CqnPredicate bindValues(Optional<CqnPredicate> predicate, Iterable<Map<String, Object>> valueSets) {
        return predicate.map(pred -> StreamSupport.stream(valueSets.spliterator(), false).map(v -> ExpressionImpl.bindValues(v, pred)).collect(Disjunction.or())).orElse(null);
    }

    private static CqnPredicate bindValues(final Map<String, Object> values, CqnPredicate predicate) {
        return ExpressionVisitor.copy(predicate, new Modifier(){

            public Value<?> parameter(String name, String cdsType) {
                return CQL.val(values.get(name));
            }
        });
    }

    private static boolean isSimple(Object v) {
        return !(v instanceof List) && !(v instanceof Map);
    }

    public static SearchPredicate search(String searchTerm) {
        return new SearchPredicate(searchTerm);
    }

    public static Predicate byId(Object idValue) {
        return ElementRefImpl.key().eq(idValue);
    }

    public static <T extends CqnPredicate> T join(List<T> preds) {
        if (preds.size() == 1) {
            return (T)((CqnPredicate)preds.get(0));
        }
        if (preds.size() > 1) {
            return (T)new Conjunction(preds);
        }
        return null;
    }
}

