/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.stream.Stream;

public class InPredicate<T>
extends AbstractPredicate
implements CqnInPredicate {
    private static final CqnPlain IN = CqnPlainImpl.plain("in");
    private final CqnValue value;
    private final CqnValue valueSet;

    private InPredicate(CqnValue value, CqnValue valueSet) {
        this.value = value;
        this.valueSet = valueSet;
    }

    public static Predicate in(CqnValue value, CqnValue valueSet) {
        if (valueSet.isList()) {
            CqnListValue list = valueSet.asList();
            if (!list.values().allMatch(v -> v.isLiteral() || v.isParameter() || v.isRef())) {
                throw new UnsupportedOperationException("Values of IN predicate must be literals, parameters or refs");
            }
            if (list.values().count() == 0L) {
                return CqnBoolLiteral.FALSE;
            }
        }
        return new InPredicate(value, valueSet);
    }

    public static Predicate in(CqnValue value, Stream<? extends CqnValue> values) {
        return InPredicate.in(value, (CqnValue)ListValue.of(values));
    }

    public CqnValue value() {
        return this.value;
    }

    public CqnValue valueSet() {
        return this.valueSet;
    }

    public Stream<CqnToken> tokens() {
        return new CqnTokenListBuilder().add(this.value).add((CqnValue)IN).add(this.valueSet).stream();
    }
}

