/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.google.common.collect.Lists;
import com.sap.cds.JSONizable;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.SelectList;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class InlineBuilder
extends SelectList
implements CqnInline {
    private InlineBuilder(StructuredTypeRef ref) {
        super(ref, SelectList.Type.INLINE);
    }

    public static InlineBuilder inline(StructuredTypeRef ref) {
        return new InlineBuilder(ref);
    }

    public Stream<CqnSelectListItem> unfold(Function<List<? extends CqnReference.Segment>, Stream<String>> prefixToAllElements) {
        Unfolder unfolder = new Unfolder(prefixToAllElements);
        return unfolder.unfolded();
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object((JSONizable)this.ref());
        cqn.put(this.type().toString(), this.items());
        return cqn.toJson();
    }

    private final class Unfolder {
        Function<List<? extends CqnReference.Segment>, Stream<String>> prefixToAllElements;
        List<CqnSelectListItem> unfoldedList = Lists.newArrayList();

        Unfolder(Function<List<? extends CqnReference.Segment>, Stream<String>> prefixToAllElements) {
            this.prefixToAllElements = prefixToAllElements;
        }

        /*
         * WARNING - void declaration
         */
        private void unfoldItems(List<CqnSelectListItem> items, List<? extends CqnReference.Segment> root) {
            if (items.isEmpty() || items.size() == 1 && items.get(0).isStar()) {
                this.unfoldAll(root);
                return;
            }
            for (CqnSelectListItem cqnSelectListItem : items) {
                void var4_4;
                CqnSelectListValue slv;
                CqnValue value;
                if (cqnSelectListItem.isStar()) {
                    this.unfoldAll(root);
                    continue;
                }
                if (cqnSelectListItem.isSelectList()) {
                    CqnSelectList selectList = cqnSelectListItem.asSelectList();
                    ArrayList refObjects = Lists.newArrayList(root);
                    if (selectList.isInline()) {
                        refObjects.addAll(selectList.asInline().ref().segments());
                        this.unfoldItems(selectList.items(), refObjects);
                        continue;
                    }
                    if (!selectList.isExpand()) continue;
                    CqnExpand expand = selectList.asExpand();
                    refObjects.addAll(expand.ref().segments());
                    String alias = expand.alias().orElse(null);
                    this.unfoldedList.add((CqnSelectListItem)ExpandBuilder.expand(StructuredTypeRefImpl.typeRef(refObjects)).as(alias).items((Iterable)selectList.items()));
                    continue;
                }
                if (cqnSelectListItem.isRef()) {
                    CqnElementRef ref = cqnSelectListItem.asRef();
                    ElementRef<Object> elementRef = ElementRefImpl.element(root, ref);
                    ref.alias().ifPresent(arg_0 -> elementRef.as(arg_0));
                    ElementRef<Object> elementRef2 = elementRef;
                } else if (cqnSelectListItem.isValue() && (value = (slv = cqnSelectListItem.asValue()).value()).isFunction()) {
                    FunctionCall func = (FunctionCall)value;
                    func.args(this.prefixRefs(func.args(), root));
                }
                this.unfoldedList.add((CqnSelectListItem)var4_4);
            }
        }

        private CqnValue[] prefixRefs(List<CqnValue> args, List<? extends CqnReference.Segment> prefix) {
            return (CqnValue[])args.stream().map(a -> a instanceof CqnElementRef ? ElementRefImpl.element(prefix, (CqnElementRef)a) : a).toArray(CqnValue[]::new);
        }

        private void unfoldAll(List<? extends CqnReference.Segment> prefix) {
            this.prefixToAllElements.apply(prefix).forEach(e -> {
                ArrayList refObjects = Lists.newArrayList((Iterable)prefix);
                refObjects.add(RefSegmentImpl.refSegment(e));
                this.unfoldedList.add((CqnSelectListItem)ElementRefImpl.element(refObjects));
            });
        }

        private Stream<CqnSelectListItem> unfolded() {
            this.unfoldItems(InlineBuilder.this.items(), InlineBuilder.this.ref().segments());
            return this.unfoldedList.stream();
        }
    }
}

