/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnJoin;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnVisitor;
import java.util.Optional;

public class Join
implements CqnJoin,
Source<StructuredType<?>> {
    private final CqnJoin.Type type;
    private final CqnSource left;
    private final CqnSource right;
    private final CqnPredicate joinPredicate;

    public Join(CqnJoin.Type type, CqnSource left, CqnSource right, CqnPredicate joinPredicate) {
        this.type = type;
        this.right = right;
        this.left = left;
        this.joinPredicate = joinPredicate;
    }

    public CqnSource left() {
        return this.left;
    }

    public CqnSource right() {
        return this.right;
    }

    public Optional<CqnPredicate> on() {
        return Optional.ofNullable(this.joinPredicate);
    }

    public CqnJoin.Type type() {
        return this.type;
    }

    public void accept(CqnVisitor visitor) {
        throw this.unsupportedAtRuntime();
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object("join", this.type.toString());
        ArrayNode args = cqn.array("args");
        args.addPOJO((Object)this.left);
        args.addPOJO((Object)this.right);
        this.on().ifPresent(on -> cqn.put("on", on));
        return cqn.toJson();
    }

    public String toString() {
        return this.toJson();
    }

    public StructuredType<?> getType() {
        throw this.unsupportedAtRuntime();
    }

    private UnsupportedOperationException unsupportedAtRuntime() {
        return new UnsupportedOperationException("Joins cannot be used at runtime but only in the model");
    }
}

