/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.parser.token.CqnBinLiteral;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.CqnNumLiteral;
import com.sap.cds.impl.parser.token.CqnStrLiteral;
import com.sap.cds.impl.parser.token.CqnTempLiteral;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CdsTypeUtils;
import java.time.temporal.Temporal;
import java.util.Optional;

public abstract class LiteralImpl<T>
extends AbstractValue<T>
implements Literal<T> {
    protected final T val;
    protected CdsBaseType cdsType;
    private final boolean isConstant;

    protected LiteralImpl(T value, boolean isConstant) {
        this.val = value;
        this.cdsType = CdsTypeUtils.cdsType(value.getClass());
        this.isConstant = isConstant;
    }

    public static <T> Literal<T> val(T val, boolean isConstant) {
        if (val == null) {
            throw new IllegalArgumentException("Literal value must not be null.");
        }
        if (val instanceof String) {
            return new CqnStrLiteral((String)val, isConstant);
        }
        if (val instanceof Number) {
            return new CqnNumLiteral<Number>((Number)val, isConstant);
        }
        if (val instanceof Boolean) {
            return CqnBoolLiteral.valueOf((Boolean)val);
        }
        if (val instanceof Temporal) {
            return new CqnTempLiteral<Temporal>((Temporal)val, isConstant);
        }
        if (val instanceof byte[]) {
            return new CqnBinLiteral((byte[])val, isConstant);
        }
        throw new CqnSyntaxException("unexpected literal type: " + val.getClass());
    }

    public static <T> Literal<T> val(T val) {
        return LiteralImpl.val(val, false);
    }

    public static <T> Literal<T> constant(T val) {
        return LiteralImpl.val(val, true);
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public T value() {
        if (this.cdsType == CdsBaseType.UUID) {
            return (T)CdsTypeUtils.parseUuid(this.val);
        }
        return this.val;
    }

    @Override
    public Predicate is(T t) {
        if (CqnNull.isNull(t)) {
            return CqnBoolLiteral.FALSE;
        }
        if (t.equals(this.val)) {
            return CqnBoolLiteral.TRUE;
        }
        return super.is(t);
    }

    @Override
    public Predicate is(Value<T> t) {
        if (CqnNull.isNull(t)) {
            return CqnBoolLiteral.FALSE;
        }
        if (t.isLiteral() && t.asLiteral().value().equals(this.val)) {
            return CqnBoolLiteral.TRUE;
        }
        return super.is(t);
    }

    @Override
    public Value<?> type(String type) {
        if (!this.cdsType.cdsName().equals(type)) {
            super.type(type);
            this.cdsType = type != null ? CdsBaseType.cdsType((String)type) : null;
        }
        return this;
    }

    @Override
    public Optional<String> type() {
        return Optional.of(super.type().orElseGet(() -> ((CdsBaseType)this.cdsType).cdsName()));
    }

    @Override
    protected Jsonizer json() {
        return Jsonizer.object("val", this.value());
    }
}

