/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.sap.cds.CdsException;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsReflectiveOperationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class StructuredTypeProxy {
    private StructuredTypeProxy() {
    }

    public static <T extends StructuredType<T>> T create(Class<T> type) {
        StructuredTypeImpl entity = StructuredTypeImpl.structuredType(StructuredTypeProxy.name(type));
        return StructuredTypeProxy.create(entity, type);
    }

    public static <T extends StructuredType<T>> T create(StructuredType<?> entity, Class<T> type) {
        return (T)((StructuredType)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new ProxyHandler(entity, type)));
    }

    public static StructuredType<?> entity(Proxy proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof ProxyHandler) {
            return ((ProxyHandler)handler).entity;
        }
        throw new CdsException("Cannot extract entity from proxy. Proxy is not a StructuredTypeProxy.");
    }

    private static String name(Class<?> type) {
        CdsName anno = type.getAnnotation(CdsName.class);
        return anno != null ? anno.value() : type.getName().substring(0, type.getName().length() - 1);
    }

    private static class ProxyHandler<T extends StructuredType<T>>
    implements InvocationHandler {
        private final Class<T> type;
        private final StructuredType<?> entity;

        private ProxyHandler(StructuredType<?> entity, Class<T> type) {
            this.entity = entity;
            this.type = type;
        }

        private static <T extends StructuredType<T>> T proxy(Class<T> type) {
            return StructuredTypeProxy.create(StructuredTypeImpl.builder(), type);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isRef".equals(method.getName())) {
                return true;
            }
            if ("asRef".equals(method.getName())) {
                return this.entity.asRef();
            }
            if ("getType".equals(method.getName())) {
                return ProxyHandler.proxy(this.type);
            }
            if ("inline".equals(method.getName()) && args != null) {
                Selectable[] slis = this.getSelectListItems(args, method.getParameterTypes()[0]);
                return this.entity.inline(slis);
            }
            if ("filter".equals(method.getName()) && method.getParameterCount() == 1) {
                Predicate filter = this.getFilter(args[0], this.type);
                return StructuredTypeProxy.create(this.entity.filter((CqnPredicate)filter), this.type);
            }
            if ("as".equals(method.getName()) && method.getParameterCount() == 1) {
                this.entity.as((String)args[0]);
                return proxy;
            }
            if ("anyMatch".equals(method.getName()) && method.getParameterCount() == 1) {
                Predicate filter = this.getFilter(args[0], this.type);
                return this.entity.anyMatch((CqnPredicate)filter);
            }
            if ("allMatch".equals(method.getName()) && method.getParameterCount() == 1) {
                Predicate filter = this.getFilter(args[0], this.type);
                return this.entity.allMatch((CqnPredicate)filter);
            }
            if ("matching".equals(method.getName()) && method.getParameterCount() == 1 && Map.class == method.getParameterTypes()[0]) {
                Predicate filter = this.getFilter((Map)args[0]);
                return StructuredTypeProxy.create(this.entity.filter((CqnPredicate)filter), this.type);
            }
            if ("get".equals(method.getName()) || "to".equals(method.getName())) {
                return method.invoke(this.entity, args);
            }
            if ("exists".equals(method.getName()) && args != null) {
                Function sq = (Function)args[0];
                StructuredTypeImpl outer = StructuredTypeImpl.builder().to("$outer");
                T e = StructuredTypeProxy.create(outer, this.type);
                CqnSelect subquery = (CqnSelect)sq.apply(e);
                return new ExistsSubquery(subquery);
            }
            Class<?> returnType = method.getReturnType();
            if (ProxyHandler.hasType(returnType, Expand.class)) {
                ExpandBuilder<T> expand = ExpandBuilder.expand(StructuredTypeProxy.create(this.entity, this.type));
                if (args == null) {
                    expand.all();
                } else {
                    Object[] slis = this.getSelectListItems(args, method.getParameterTypes()[0]);
                    expand.items((Iterable)Lists.newArrayList((Object[])slis));
                }
                return expand;
            }
            if (ProxyHandler.hasType(returnType, ElementRef.class)) {
                return this.entity.get(this.name(method), this.type(method));
            }
            if (ProxyHandler.hasType(returnType, StructuredType.class)) {
                StructuredType targetEntity = this.entity.to(this.name(method));
                Class<?> t = returnType;
                if (method.getParameterCount() == 1) {
                    targetEntity = targetEntity.filter((CqnPredicate)this.getFilter(args[0], t));
                }
                return StructuredTypeProxy.create(targetEntity, t);
            }
            return method.invoke(this.entity, args);
        }

        private static boolean hasType(Class<?> a, Class<?> b) {
            return b.isAssignableFrom(a);
        }

        private Selectable[] getSelectListItems(Object[] args, Class<?> argType) {
            Stream arguments;
            Function<Object, Selectable> converter = s -> (Selectable)s;
            if (argType == Selectable[].class) {
                arguments = Arrays.stream((Selectable[])args[0]);
            } else if (argType == String[].class) {
                arguments = Arrays.stream((String[])args[0]);
                converter = path -> CQL.get((String)((String)path));
            } else if (argType == Function[].class) {
                arguments = Arrays.stream((Function[])args[0]);
                converter = this::applyFunction;
            } else if (argType == Function.class) {
                arguments = Arrays.stream(args);
                converter = this::applyFunction;
            } else if (argType == Iterable.class) {
                arguments = Streams.stream((Iterable)((Iterable)args[0]));
            } else if (argType == List.class) {
                arguments = ((List)args[0]).stream();
                converter = this::applyFunction;
            } else {
                throw new UnsupportedOperationException("Unsupported argument type: " + argType.getCanonicalName());
            }
            return (Selectable[])arguments.map(converter).toArray(Selectable[]::new);
        }

        private Selectable applyFunction(Object f) {
            return (Selectable)((Function)f).apply(ProxyHandler.proxy(this.type));
        }

        private Predicate getFilter(Object arg, Class<T> type) {
            Class<?> argType = arg.getClass();
            if (Predicate.class.isAssignableFrom(argType)) {
                return (Predicate)arg;
            }
            if (Function.class.isAssignableFrom(argType)) {
                return (Predicate)((Function)arg).apply(ProxyHandler.proxy(type));
            }
            throw new CdsReflectiveOperationException("Argument '" + arg + "' is not a filter predicate");
        }

        private Predicate getFilter(Map values) {
            return ExpressionImpl.matching(values);
        }

        private Class<?> type(Method method) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            Type type = returnType.getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            return (Class)type;
        }

        private String name(Method method) {
            CdsName anno = method.getAnnotation(CdsName.class);
            return anno != null ? anno.value() : method.getName();
        }
    }
}

