/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.builder.model;

import com.google.common.base.Strings;
import com.sap.cds.CdsException;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StructuredTypeRefImpl
implements StructuredTypeRef {
    protected final LinkedList<RefSegment> segments = new LinkedList();
    private String alias;

    private StructuredTypeRefImpl(List<RefSegment> segments) {
        this.segments.addAll(segments);
    }

    public static StructuredTypeRef typeRef(CqnStructuredTypeRef ref) {
        List<RefSegment> segments = RefSegmentImpl.copy(ref.segments());
        StructuredTypeRef typeRef = StructuredTypeRefImpl.typeRef(segments);
        ref.alias().ifPresent(arg_0 -> ((StructuredTypeRef)typeRef).as(arg_0));
        return typeRef;
    }

    public static StructuredTypeRef typeRef(List<? extends CqnReference.Segment> segments) {
        return new StructuredTypeRefImpl(segments);
    }

    public static StructuredTypeRef typeRef(String ... segments) {
        return StructuredTypeRefImpl.typeRef(Arrays.stream(segments).map(RefSegmentImpl::refSegment).collect(Collectors.toList()));
    }

    public static StructuredTypeRef typeRef(String id) {
        return StructuredTypeRefImpl.typeRef(Collections.singletonList(RefSegmentImpl.refSegment(id)));
    }

    public static StructuredTypeRef typeRef(CqnSource source) {
        if (source instanceof StructuredTypeRef) {
            return (StructuredTypeRef)source;
        }
        if (source instanceof StructuredTypeImpl) {
            return ((StructuredTypeImpl)source).asRef();
        }
        if (source instanceof Proxy) {
            return StructuredTypeRefImpl.typeRef(StructuredTypeProxy.entity((Proxy)source));
        }
        throw new CdsException("Cannot convert " + source + " to StructuredTypeRef");
    }

    public StructuredTypeRefImpl addSegment(RefSegment segment) {
        this.segments.add(segment);
        return this;
    }

    public StructuredTypeRef as(String alias) {
        this.alias = Strings.emptyToNull((String)alias);
        return this;
    }

    public List<RefSegment> segments() {
        return Collections.unmodifiableList(this.segments);
    }

    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object("ref", this.segments);
        this.alias().ifPresent(a -> cqn.put("as", a));
        return cqn.toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

