/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.localized;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

public class LocaleUtils {
    private static final String LOCALIZED_PREFIX = "localized";

    private LocaleUtils() {
    }

    public static String localizedEntityName(CdsEntity entity) {
        return "localized." + entity.getQualifiedName();
    }

    public static String localizedEntityName(String entity) {
        return "localized." + entity;
    }

    public static String localizedEntityName(String entity, Locale locale) {
        return "localized." + locale.getLanguage() + "." + entity;
    }

    public static boolean isLocalizedEntityName(String entity) {
        return entity.startsWith("localized.");
    }

    public static String getLocaleString(Locale locale) {
        if (locale != null) {
            String extension;
            String localeStr = locale.getLanguage();
            String country = locale.getCountry();
            if (!country.isEmpty()) {
                localeStr = localeStr + "_" + country;
            }
            if ((extension = locale.getExtension('x')) != null && !extension.isEmpty()) {
                localeStr = localeStr + "_" + extension;
            }
            return localeStr;
        }
        return null;
    }

    public static boolean isLocalized(CdsEntity entity) {
        Optional map = entity.findAnnotation("cds.localized");
        if (map.isPresent() && Boolean.FALSE.equals(((CdsAnnotation)map.get()).getValue())) {
            return false;
        }
        return entity.concreteNonAssociationElements().anyMatch(CdsElement::isLocalized);
    }

    public static boolean hasLocalizedElements(CdsStructuredType targetType, Collection<CqnElementRef> elementRefs) {
        return elementRefs.stream().map(ref -> CdsModelUtils.element(targetType, ref)).anyMatch(CdsElement::isLocalized);
    }

    private static boolean hasWhereGroupByOrHavingClause(CqnStatement statement) {
        boolean hasHavingClause;
        boolean hasGroupByClause;
        boolean hasWhereClause = statement.isSelect() ? statement.asSelect().where().isPresent() : (statement.isUpdate() ? statement.asUpdate().where().isPresent() : (statement.isDelete() ? statement.asDelete().where().isPresent() : false));
        if (statement.isSelect()) {
            hasGroupByClause = statement.asSelect().groupBy() != null && !statement.asSelect().groupBy().isEmpty();
            hasHavingClause = statement.asSelect().having().isPresent();
        } else {
            hasGroupByClause = false;
            hasHavingClause = false;
        }
        boolean hasInfixFilter = statement.isSelect() && statement.asSelect().from().isRef() || !statement.isSelect() ? statement.ref().segments().stream().anyMatch(segment -> segment.filter().isPresent()) : false;
        if (hasWhereClause || hasGroupByClause || hasHavingClause || hasInfixFilter) {
            return true;
        }
        return statement.isSelect() && statement.asSelect().from().isSelect() && LocaleUtils.hasWhereGroupByOrHavingClause((CqnStatement)statement.asSelect().from().asSelect());
    }

    private static boolean hasSortSpecWithStringElement(CdsModel model, CqnStatement statement) {
        if (!statement.isSelect()) {
            return false;
        }
        CdsStructuredType targetType = CqnStatementUtils.targetType(model, statement.asSelect());
        StringTypedSortSpecVisitor visitor = new StringTypedSortSpecVisitor(targetType);
        statement.asSelect().orderBy().forEach(s -> s.accept((CqnVisitor)visitor));
        return visitor.hasFoundStringTypedSortSpec();
    }

    public static boolean collateClauseIsNeeded(CdsModel model, CqnStatement statement, Locale locale) {
        if (locale != null) {
            return LocaleUtils.hasWhereGroupByOrHavingClause(statement) || LocaleUtils.hasSortSpecWithStringElement(model, statement);
        }
        return false;
    }

    private static class StringTypedSortSpecVisitor
    implements CqnVisitor {
        private final CdsStructuredType targetType;
        private boolean foundStringTypedSortSpec = false;

        public boolean hasFoundStringTypedSortSpec() {
            return this.foundStringTypedSortSpec;
        }

        public StringTypedSortSpecVisitor(CdsStructuredType targetType) {
            this.targetType = targetType;
        }

        public void visit(CqnSortSpecification sortSpec) {
            sortSpec.value().accept(new CqnVisitor(){

                public void visit(CqnElementRef elementRef) {
                    if (!foundStringTypedSortSpec) {
                        CdsElement element = CdsModelUtils.element(targetType, elementRef);
                        foundStringTypedSortSpec = element.getType().isSimpleType(CdsBaseType.STRING);
                    }
                }
            });
        }
    }
}

