/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.sap.cds.impl.parser.ExprParser;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.Xpr;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractCqnExpressionParser {
    protected LinkedList<CqnToken> tokens;
    protected CqnToken aheadToken;
    protected int pos;

    public CqnPredicate parsePredicate(List<CqnToken> tokenList) {
        return this.parsePredicate(tokenList.stream());
    }

    public CqnPredicate parsePredicate(Stream<CqnToken> tokenStream) {
        this.tokens = AbstractCqnExpressionParser.unfold(tokenStream);
        if (this.tokens.isEmpty()) {
            return null;
        }
        this.aheadToken = this.tokens.getFirst();
        this.pos = 0;
        CqnPredicate expression = this.searchCondition();
        if (this.aheadToken != null) {
            throw this.unexpected();
        }
        return expression;
    }

    private CqnPredicate searchCondition() {
        CqnPredicate term = this.booleanTerm();
        while (this.is("or")) {
            term = CQL.or((CqnPredicate)term, (CqnPredicate)this.booleanTerm());
        }
        return term;
    }

    private CqnPredicate booleanTerm() {
        CqnPredicate factor = this.booleanFactor();
        while (this.is("and")) {
            factor = CQL.and((CqnPredicate)factor, (CqnPredicate)this.booleanFactor());
        }
        return factor;
    }

    private CqnPredicate booleanFactor() {
        if (this.is("not")) {
            CqnPredicate factor = this.booleanFactor();
            return CQL.not((CqnPredicate)factor);
        }
        return this.booleanTest();
    }

    private CqnPredicate booleanTest() {
        if (this.peek("(")) {
            return this.matchPredicate().orElseGet(() -> {
                this.expect("(");
                CqnPredicate expr = this.searchCondition();
                this.expect(")");
                return expr;
            });
        }
        if (this.isXpr()) {
            return this.matchPredicate().orElseGet(() -> new ExprParser().parsePredicate(this.getXpr().xpr()));
        }
        return this.predicate();
    }

    protected abstract CqnPredicate predicate();

    protected void nextToken() {
        this.tokens.pop();
        if (this.tokens.isEmpty()) {
            this.aheadToken = null;
        } else {
            this.aheadToken = this.tokens.getFirst();
            ++this.pos;
        }
    }

    protected boolean hasNext() {
        return this.aheadToken != null;
    }

    protected CqnPredicate getPredicate() {
        return this.get(CqnPredicate.class);
    }

    protected CqnPlain getPlain() {
        return this.get(CqnPlain.class);
    }

    protected CqnLiteral<?> getLiteral() {
        return this.get(CqnLiteral.class);
    }

    protected Xpr getXpr() {
        return this.get(Xpr.class);
    }

    protected CqnValue getValue() {
        return this.get(CqnValue.class);
    }

    protected CqnListValue getList() {
        return this.get(CqnListValue.class);
    }

    protected <T> T get(Class<T> clazz) {
        if (null == this.aheadToken) {
            throw new CqnSyntaxException("Unexpected end of token stream.");
        }
        if (clazz.isAssignableFrom(this.aheadToken.getClass())) {
            CqnToken value = this.aheadToken;
            this.nextToken();
            return (T)value;
        }
        throw this.unexpected();
    }

    protected boolean is(String value) {
        if (this.peek(value)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean peek(String ... values) {
        if (!this.isPlain()) {
            return false;
        }
        String plain = ((CqnPlain)this.aheadToken).plain();
        return Arrays.stream(values).anyMatch(plain::equalsIgnoreCase);
    }

    protected boolean isPredicate() {
        return this.aheadToken instanceof CqnPredicate;
    }

    protected boolean isPlain() {
        return this.aheadToken instanceof CqnPlain;
    }

    protected boolean isLiteral() {
        return this.aheadToken instanceof CqnLiteral;
    }

    protected boolean isRef() {
        return this.aheadToken instanceof CqnReference;
    }

    protected boolean isXpr() {
        return this.aheadToken instanceof Xpr;
    }

    protected boolean isList() {
        return this.aheadToken instanceof CqnListValue;
    }

    protected CqnSyntaxException unexpected() {
        String msg = MessageFormat.format("Unexpected token at position {0}: {1}", this.pos, this.aheadToken.toJson());
        return new CqnSyntaxException(msg);
    }

    protected void expect(String expected) {
        if (!this.is(expected)) {
            throw this.expecting(CqnPlainImpl.plain(expected));
        }
    }

    private CqnSyntaxException expecting(CqnPlainImpl plain) {
        String msg = this.aheadToken != null ? MessageFormat.format("Unexpeceted token {0} at position {1}. Expecting {2}.", this.aheadToken.toJson(), this.pos, plain.toJson()) : MessageFormat.format("Expecting token {0} at position {1}.", plain.toJson(), this.pos);
        return new CqnSyntaxException(msg);
    }

    private static LinkedList<CqnToken> unfold(Stream<CqnToken> tokens) {
        LinkedList<CqnToken> list = new LinkedList<CqnToken>();
        tokens.forEach(list::add);
        return list;
    }

    private Optional<CqnPredicate> matchPredicate() {
        LinkedList<CqnToken> oldTokens = new LinkedList<CqnToken>(this.tokens);
        CqnToken oldAhead = this.aheadToken;
        int oldPos = this.pos;
        try {
            return Optional.of(this.predicate());
        }
        catch (Exception ex) {
            this.tokens = oldTokens;
            this.aheadToken = oldAhead;
            this.pos = oldPos;
            return Optional.empty();
        }
    }
}

