/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import com.sap.cds.impl.parser.ExprParser;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnToken;
import java.util.ArrayList;
import java.util.List;

public class ExpressionParser {
    private ExpressionParser() {
    }

    public static CqnExpression parseExpression(ArrayNode xpr) {
        if (xpr != null) {
            return ExpressionBuilder.create(ExpressionParser.parseTokens(xpr)).xpr();
        }
        return null;
    }

    public static CqnPredicate parsePredicate(String cqnExpr) {
        try {
            ArrayNode expr = (ArrayNode)JsonParser.parseJson(cqnExpr);
            return ExpressionParser.parsePredicate((JsonNode)expr);
        }
        catch (Exception ex) {
            throw new CqnSyntaxException("Error parsing " + cqnExpr, (Throwable)ex);
        }
    }

    public static List<CqnToken> parseTokens(String cqnExpr) {
        ArrayNode expr = (ArrayNode)JsonParser.parseJson(cqnExpr);
        return ExpressionParser.parseTokens(expr);
    }

    public static CqnPredicate parsePredicate(JsonNode expr) {
        if (expr == null) {
            return null;
        }
        if (expr.isArray()) {
            List<CqnToken> tokens = ExpressionParser.parseTokens((ArrayNode)expr);
            return new ExprParser().parsePredicate(tokens);
        }
        return ExpressionBuilder.create(TokenParser.parse(expr)).predicate();
    }

    public static List<CqnToken> parseTokens(ArrayNode arrayNode) {
        ArrayList tokens = Lists.newArrayList();
        if (arrayNode != null) {
            arrayNode.forEach(n -> tokens.add(TokenParser.parse(n)));
        }
        return tokens;
    }
}

