/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.impl.UpdateBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateParser {
    private final JsonNode update;

    private UpdateParser(JsonNode node) {
        this.update = node.get("UPDATE");
    }

    public static UpdateParser of(String cqn) {
        return new UpdateParser((JsonNode)JsonParser.parseJson(cqn));
    }

    public static Update<StructuredType<?>> parse(String cqn) {
        return UpdateParser.of(cqn).parse();
    }

    public Update<StructuredType<?>> parse() {
        StructuredTypeRef ref = TokenParser.ref(this.update.get("entity"));
        UpdateBuilder<StructuredType<?>> update = UpdateBuilder.entity((CqnStructuredTypeRef)ref);
        this.readData().ifPresent(update::data);
        this.readEntries().ifPresent(update::entries);
        return update.where(this.where());
    }

    private CqnPredicate where() {
        JsonNode where = this.update.get("where");
        return ExpressionParser.parsePredicate(where);
    }

    private Optional<Map<String, Object>> readData() {
        if (this.update.has("data")) {
            return Optional.of(JsonParser.map(this.update.get("data")));
        }
        return Optional.empty();
    }

    private Optional<List<Map<String, Object>>> readEntries() {
        if (this.update.has("entries")) {
            return Optional.of(JsonParser.list((ArrayNode)this.update.withArray("entries")));
        }
        return Optional.empty();
    }
}

