/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.builder;

import com.sap.cds.impl.builder.model.AbstractPredicate;
import com.sap.cds.impl.builder.model.AbstractValue;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.builder.model.CqnTokenListBuilder;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.parser.token.CqnPlainImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.Xpr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExpressionBuilder {
    private final List<CqnToken> tokens = new ArrayList<CqnToken>();

    private ExpressionBuilder() {
    }

    public static ExpressionBuilder create(Iterable<CqnToken> tokens) {
        ExpressionBuilder builder = new ExpressionBuilder();
        for (CqnToken token : tokens) {
            builder.add(token);
        }
        return builder;
    }

    public static ExpressionBuilder create(CqnToken ... tokens) {
        return ExpressionBuilder.create(Arrays.asList(tokens));
    }

    public ExpressionBuilder ref(String path) {
        return this.add((CqnToken)ElementRefImpl.parse(path));
    }

    public ExpressionBuilder ref(CqnElementRef ref) {
        return this.add((CqnToken)ref);
    }

    public <T> ExpressionBuilder val(T value) {
        return this.add((CqnToken)LiteralImpl.val(value));
    }

    public ExpressionBuilder plain(String plain) {
        return this.add((CqnToken)CqnPlainImpl.plain(plain));
    }

    public ExpressionBuilder plain(Object object) {
        if (object == null) {
            return this.add((CqnToken)CqnNull.NULL);
        }
        return this.plain(object.toString());
    }

    public ExpressionBuilder param(String param) {
        return this.add((CqnToken)CqnParam.param(param));
    }

    public ExpressionBuilder add(CqnToken token) {
        this.tokens.add(token);
        return this;
    }

    public CqnExpression xpr() {
        return new ValueExpression(this.tokens);
    }

    public <T> Value<T> value() {
        return new ValueExpression(this.tokens);
    }

    public Predicate predicate() {
        return new PredicateExpression(this.tokens);
    }

    private static List<CqnToken> unfold(List<CqnToken> tokens) {
        return tokens.stream().flatMap(CqnToken::tokens).collect(Collectors.toList());
    }

    private static String serialize(List<CqnToken> xpr) {
        List<CqnToken> unfolded = ExpressionBuilder.unfold(xpr);
        if (unfolded.size() == 1) {
            return unfolded.get(0).toJson();
        }
        return Jsonizer.object("xpr", unfolded).toJson();
    }

    private static Stream<CqnToken> tokenize(List<CqnToken> xpr) {
        List<CqnToken> unfolded = ExpressionBuilder.unfold(xpr);
        switch (unfolded.size()) {
            case 0: {
                return Stream.empty();
            }
            case 1: {
                return Stream.of(unfolded.get(0));
            }
        }
        return new CqnTokenListBuilder().add((CqnValue)CqnPlainImpl.LPAREN).addAll(unfolded.stream()).add((CqnValue)CqnPlainImpl.RPAREN).stream();
    }

    private static class PredicateExpression
    extends AbstractPredicate
    implements CqnExpression,
    Xpr {
        private final List<CqnToken> xpr;

        public PredicateExpression(List<CqnToken> xpr) {
            this.xpr = xpr;
        }

        @Override
        public List<CqnToken> xpr() {
            return this.xpr;
        }

        @Override
        public String toJson() {
            return ExpressionBuilder.serialize(this.xpr);
        }

        public Stream<CqnToken> tokens() {
            return ExpressionBuilder.tokenize(this.xpr);
        }

        public void accept(CqnVisitor visitor) {
            this.xpr().forEach(t -> t.accept(visitor));
            visitor.visit((CqnPredicate)this);
        }
    }

    private static class ValueExpression<T>
    extends AbstractValue<T>
    implements CqnExpression,
    Xpr {
        private final List<CqnToken> xpr;

        public ValueExpression(List<CqnToken> xpr) {
            this.xpr = xpr;
        }

        public Stream<CqnToken> tokens() {
            return ExpressionBuilder.tokenize(this.xpr);
        }

        @Override
        public List<CqnToken> xpr() {
            return this.xpr;
        }

        @Override
        public String toJson() {
            return ExpressionBuilder.serialize(this.xpr);
        }

        @Override
        public Jsonizer json() {
            throw new IllegalStateException();
        }

        public void accept(CqnVisitor visitor) {
            this.xpr.forEach(t -> t.accept(visitor));
            visitor.visit((CqnExpression)this);
        }
    }
}

