/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.parser.token;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class CqnBoolLiteral
extends LiteralImpl<Boolean>
implements CqnBooleanLiteral,
Predicate {
    public static final CqnBoolLiteral FALSE = new CqnBoolLiteral(false);
    public static final CqnBoolLiteral TRUE = new CqnBoolLiteral(true);
    private final boolean bool;

    private CqnBoolLiteral(boolean bool) {
        super(bool, false);
        this.bool = bool;
    }

    public static CqnBoolLiteral valueOf(boolean val) {
        return val ? TRUE : FALSE;
    }

    public Predicate not() {
        return this.bool ? FALSE : TRUE;
    }

    public Predicate and(CqnPredicate other, CqnPredicate ... more) {
        if (!this.bool) {
            return FALSE;
        }
        if (more.length == 0) {
            return (Predicate)other;
        }
        return (Predicate)Stream.concat(Stream.of(other), Stream.of(more)).collect(Conjunction.and());
    }

    public Predicate or(CqnPredicate other, CqnPredicate ... more) {
        if (this.bool) {
            return TRUE;
        }
        if (more.length == 0) {
            return (Predicate)other;
        }
        return (Predicate)CqnBoolLiteral.list(other, more).stream().collect(Disjunction.or());
    }

    @Override
    public Value<Boolean> type(String cdsType) {
        return this;
    }

    public void accept(CqnVisitor visitor) {
        super.accept(visitor);
    }

    private static List<CqnPredicate> list(CqnPredicate other, CqnPredicate ... more) {
        ArrayList<CqnPredicate> predicates = new ArrayList<CqnPredicate>(more.length + 1);
        predicates.add(other);
        predicates.addAll(Arrays.asList(more));
        return predicates;
    }
}

