/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.Xpr;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ExpressionVisitor
implements CqnVisitor {
    protected static final Modifier COPY = new Modifier(){};
    private final Stack<CqnToken> tokens = new Stack();
    private final Modifier modifier;

    private ExpressionVisitor(Modifier modifier) {
        this.modifier = modifier;
    }

    public static Predicate copy(CqnPredicate pred) {
        return ExpressionVisitor.copy(pred, COPY);
    }

    public static Predicate copy(Optional<CqnPredicate> pred, Modifier modifier) {
        return (Predicate)ExpressionVisitor.copyToken(pred.orElse(null), modifier);
    }

    public static Predicate copy(CqnPredicate pred, Modifier modifier) {
        return (Predicate)ExpressionVisitor.copyToken(pred, modifier);
    }

    public static <V extends CqnValue> V copy(V val, Modifier modifier) {
        return (V)((CqnValue)ExpressionVisitor.copyToken(val, modifier));
    }

    public static StructuredTypeRef copy(CqnStructuredTypeRef ref, Modifier modifier) {
        return (StructuredTypeRef)ExpressionVisitor.copyToken(ref, modifier);
    }

    public static <I extends CqnSelectListItem> I copy(I sli, Modifier modifier) {
        return (I)((CqnSelectListItem)ExpressionVisitor.copyToken(sli, modifier));
    }

    public static <I extends CqnValue> List<I> copy(List<I> items, Modifier modifier) {
        return items.stream().map(i -> ExpressionVisitor.copy(i, modifier)).collect(Collectors.toList());
    }

    public static <I extends CqnSelectListItem> List<I> copy(Collection<I> items, Modifier modifier) {
        return items.stream().map(i -> ExpressionVisitor.copy(i, modifier)).collect(Collectors.toList());
    }

    public static CqnSortSpecification copy(CqnSortSpecification sort, Modifier modifier) {
        return (CqnSortSpecification)ExpressionVisitor.copyToken(sort, modifier);
    }

    private static <T extends CqnToken, R extends T> R copyToken(T token, Modifier modifier) {
        if (token == null) {
            return null;
        }
        ExpressionVisitor v = new ExpressionVisitor(modifier);
        token.accept((CqnVisitor)v);
        return (R)v.result();
    }

    public <T extends CqnToken> T result() {
        return this.pop();
    }

    private void push(CqnToken token) {
        this.tokens.push(token);
    }

    private <T extends CqnToken> T pop() {
        return (T)((CqnToken)this.tokens.pop());
    }

    private <T extends CqnToken> List<T> pop(int n) {
        return this.tokens.pop(n);
    }

    public void visit(CqnStructuredTypeRef ref) {
        StructuredTypeRef structRef = StructuredTypeRefImpl.typeRef(ref);
        this.push((CqnToken)this.modifier.ref(structRef));
    }

    public void visit(CqnElementRef ref) {
        ElementRef elementRef = ElementRefImpl.elementRef((CqnReference)ref);
        this.push((CqnToken)this.modifier.ref(elementRef));
    }

    public void visit(CqnExpression expr) {
        List<CqnToken> ts = this.pop(((Xpr)expr).length());
        ExpressionBuilder builder = ExpressionBuilder.create(ts);
        if (expr instanceof CqnPredicate) {
            this.push((CqnToken)builder.predicate());
        } else {
            Value v = builder.value();
            expr.type().ifPresent(arg_0 -> v.type(arg_0));
            this.push((CqnToken)v);
        }
    }

    public void visit(CqnArithmeticExpression expr) {
        Value right = (Value)this.pop();
        Value left = (Value)this.pop();
        this.push((CqnToken)this.modifier.expression(left, expr.operator(), right, (String)expr.type().orElse(null)));
    }

    public void visit(CqnMatchPredicate match) {
        StructuredTypeRef ref = ExpressionVisitor.copy(match.ref(), COPY);
        Optional pred = ExpressionVisitor.copy(match.predicate(), COPY);
        this.push((CqnToken)this.modifier.match(ref, (Predicate)pred, match.quantifier()));
    }

    public void visit(CqnInPredicate in) {
        CqnValue valueSet = (CqnValue)this.pop();
        Value lhs = (Value)this.pop();
        this.push((CqnToken)this.modifier.in(lhs, valueSet));
    }

    public void visit(CqnFunc func) {
        List args = this.pop(func.args().size());
        if (func instanceof BooleanFunction) {
            this.push((CqnToken)this.modifier.booleanFunction(func.func(), args));
        } else {
            this.push((CqnToken)this.modifier.function(func.func(), args, (String)func.type().orElse(null)));
        }
    }

    public void visit(CqnContainmentTest test) {
        CqnValue substring = (CqnValue)this.pop();
        CqnValue value = (CqnValue)this.pop();
        this.push((CqnToken)this.modifier.containment(test.position(), value, substring, test.caseInsensitive()));
    }

    public void visit(CqnExistsSubquery exists) {
        ExistsSubquery sq = (ExistsSubquery)exists;
        Object outer = sq.getOuter();
        Select subquery = Select.copy((CqnSelect)exists.subquery());
        Predicate pred = this.modifier.exists(subquery);
        if (outer != null && pred instanceof ExistsSubquery) {
            ((ExistsSubquery)pred).setOuter(outer);
        }
        this.push((CqnToken)pred);
    }

    public void visit(CqnLiteral<?> literal) {
        this.push((CqnToken)this.modifier.literal(literal));
    }

    public void visit(CqnListValue listValue) {
        List args = this.pop((int)listValue.values().count());
        this.push(this.modifier.list(args));
    }

    public void visit(CqnComparisonPredicate comparison) {
        Value rhs = (Value)this.pop();
        Value lhs = (Value)this.pop();
        this.push((CqnToken)this.modifier.comparison(lhs, comparison.operator(), rhs));
    }

    public void visit(CqnConnectivePredicate connective) {
        List predicates = this.pop(connective.predicates().size());
        this.push((CqnToken)this.modifier.connective(connective.operator(), predicates));
    }

    public void visit(CqnNegation neg) {
        this.push((CqnToken)this.modifier.negation((Predicate)this.pop()));
    }

    public void visit(CqnNullValue nil) {
        this.push((CqnToken)nil);
    }

    public void visit(CqnParameter param) {
        this.push((CqnToken)this.modifier.parameter(param.name(), (String)param.type().orElse(null)));
    }

    public void visit(CqnPlain plain) {
        this.push((CqnToken)this.modifier.plain(plain.plain(), (String)plain.type().orElse(null)));
    }

    public void visit(CqnSearchPredicate search) {
        CqnLiteral searchTerm = (CqnLiteral)this.pop();
        this.push((CqnToken)this.modifier.search((String)searchTerm.value()));
    }

    public void visit(CqnSelectListValue sli) {
        Value value = (Value)this.pop();
        this.push((CqnToken)this.modifier.selectListItem(value, (String)sli.alias().orElse(null)));
    }

    public void visit(CqnStar star) {
        this.push((CqnToken)this.modifier.selectAll());
    }

    public void visit(CqnInline inline) {
        StructuredTypeRef ref = ExpressionVisitor.copy(inline.ref(), COPY);
        List items = inline.items().stream().map(i -> ExpressionVisitor.copy(i, COPY)).collect(Collectors.toList());
        this.push((CqnToken)this.modifier.inline(ref, items));
    }

    public void visit(CqnExpand expand) {
        StructuredTypeRef ref = ExpressionVisitor.copy(expand.ref(), COPY);
        List items = expand.items().stream().map(i -> ExpressionVisitor.copy(i, COPY)).collect(Collectors.toList());
        List orderBy = expand.orderBy().stream().map(o -> ExpressionVisitor.copy(o, COPY)).collect(Collectors.toList());
        CqnSelectListItem copy = this.modifier.expand(ref, items, orderBy, (CqnLimit)expand.limit().orElse(null));
        if (((ExpandBuilder)expand).lazy()) {
            ((ExpandBuilder)copy).lazy(true);
        }
        this.push((CqnToken)copy);
    }

    public void visit(CqnSortSpecification sortSpec) {
        Value value = (Value)this.pop();
        this.push((CqnToken)this.modifier.sort(value, sortSpec.order()));
    }
}

