/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.builder.model.LockImpl;
import com.sap.cds.impl.builder.model.Negation;
import com.sap.cds.impl.builder.model.ScalarFunctionCall;
import com.sap.cds.impl.builder.model.SearchPredicate;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.builder.LimitImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.Limit;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Parameter;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Searchable;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SelectBuilder<T extends StructuredType<?>>
extends Select<T> {
    public static final String IGNORE_LOCALIZED_VIEWS = "ignoreLocalizedViews";
    public static final String IGNORE_DRAFT_SUBQUERIES = "ignoreDraftSubqueries";
    private final List<CqnSelectListItem> columns = new ArrayList<CqnSelectListItem>();
    private final Set<String> searchableElements = new HashSet<String>();
    private final List<String> excluding = new ArrayList<String>();
    private final List<CqnValue> groupBy = new ArrayList<CqnValue>();
    private final List<CqnSortSpecification> orderBy = new ArrayList<CqnSortSpecification>();
    private final Source<T> source;
    private boolean distinct;
    private boolean count;
    private CqnPredicate where;
    private CqnPredicate having;
    private CqnPredicate search;
    private CqnLock rowLock;
    private long top = -1L;
    private long skip = 0L;
    private Map<String, Object> hints = new HashMap<String, Object>(2);

    private SelectBuilder(Source<T> source) {
        this.source = source;
    }

    public static <E extends StructuredType<E>> SelectBuilder<E> from(Class<E> entity) {
        return new SelectBuilder(StructuredTypeProxy.create(entity));
    }

    public static SelectBuilder<StructuredType<?>> from(CqnStructuredTypeRef ref) {
        return new SelectBuilder((Source<StructuredType<?>>)StructuredTypeImpl.structuredType(ref));
    }

    public static Select<StructuredType<?>> from(CqnSelect select) {
        return new SelectBuilder((Source)select);
    }

    public static SelectBuilder<StructuredTypeImpl> from(CqnSource source) {
        if (source.isRef()) {
            StructuredTypeImpl structuredType = StructuredTypeImpl.structuredType(source.asRef());
            return new SelectBuilder<StructuredTypeImpl>((Source<StructuredTypeImpl>)structuredType);
        }
        if (source.isSelect()) {
            return new SelectBuilder<StructuredTypeImpl>((Source)source);
        }
        if (source.isJoin()) {
            Source query = (Source)source;
            return new SelectBuilder<StructuredTypeImpl>(query);
        }
        throw new IllegalStateException("unexpected source type " + source.getClass().getName());
    }

    public static <E extends StructuredType<E>, R extends StructuredType<R>> SelectBuilder<R> from(Class<E> type, Function<E, R> path) {
        return new SelectBuilder((Source)path.apply(StructuredTypeProxy.create(type)));
    }

    public static <E extends StructuredType<E>> SelectBuilder<E> from(Source<E> source) {
        return new SelectBuilder<E>(source);
    }

    public static SelectBuilder<StructuredType<?>> from(String entityName) {
        return new SelectBuilder((Source<StructuredType<?>>)StructuredTypeImpl.structuredType(entityName));
    }

    public static SelectBuilder<StructuredType<?>> from(String entity, UnaryOperator<StructuredType<?>> path) {
        return new SelectBuilder((Source)path.apply(StructuredTypeImpl.structuredType(entity)));
    }

    public static SelectBuilder<StructuredType<?>> copy(CqnSelect select) {
        return SelectBuilder.copy(select, ExpressionVisitor.COPY);
    }

    public static SelectBuilder<StructuredType<?>> copy(CqnSelect select, Modifier modifier) {
        return SelectBuilder.copy(select, modifier, true);
    }

    public static SelectBuilder<StructuredType<?>> copy(CqnSelect select, Modifier modifier, boolean deep) {
        SelectBuilder<StructuredTypeImpl> copy = SelectBuilder.from(SelectBuilder.copy(select.from(), modifier, deep));
        copy.hints(((SelectBuilder)select).hints());
        copy.distinct = modifier.distinct(select.isDistinct());
        copy.count = modifier.inlineCount(select.hasInlineCount());
        copy.where = modifier.where((Predicate)ExpressionVisitor.copy(select.where(), modifier));
        copy.having = modifier.having((Predicate)ExpressionVisitor.copy(select.having(), modifier));
        copy.search = modifier.search((Predicate)ExpressionVisitor.copy(select.search(), modifier));
        copy.searchableElements.addAll(modifier.searchableElements(new HashSet<String>(((SelectBuilder)select).searchableElements)));
        if (select.hasLimit()) {
            CqnLimit limit = modifier.limit((Limit)LimitImpl.create(select.top(), select.skip()));
            copy.limit(limit.top(), limit.skip());
        }
        select.getLock().ifPresent(lock -> {
            copy.rowLock = lock;
        });
        Set excluding = modifier.excluding(new HashSet(select.excluding()));
        List items = modifier.items(ExpressionVisitor.copy(select.items(), modifier));
        List groupBy = modifier.groupBy(ExpressionVisitor.copy(select.groupBy(), modifier));
        List orderBy = modifier.orderBy(select.orderBy().stream().map(c -> ExpressionVisitor.copy(c, modifier)).collect(Collectors.toList()));
        return copy.columns(items).excluding((Collection)excluding).groupBy(groupBy).orderBy(orderBy);
    }

    private static CqnSource copy(CqnSource source, Modifier modifier, boolean deep) {
        if (source.isRef()) {
            return ExpressionVisitor.copy(source.asRef(), modifier);
        }
        if (source.isSelect()) {
            if (deep) {
                CqnSelect inner = source.asSelect();
                return SelectBuilder.copy(inner, modifier);
            }
            return source;
        }
        throw new UnsupportedOperationException("Joins are not supported as source of SELECT");
    }

    public Source<T> from() {
        return this.source;
    }

    public CqnStructuredTypeRef ref() {
        return StructuredTypeRefImpl.typeRef(this.source);
    }

    public SelectBuilder<T> distinct() {
        return this.distinct(true);
    }

    public SelectBuilder<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public SelectBuilder<T> inlineCount() {
        return this.count(true);
    }

    public SelectBuilder<T> count(boolean count) {
        this.count = count;
        return this;
    }

    public boolean hasInlineCount() {
        return this.count;
    }

    public SelectBuilder<T> columns(List<? extends Selectable> items) {
        return this.columns(items.stream());
    }

    public SelectBuilder<T> columns(Stream<? extends Selectable> items) {
        this.columns.clear();
        items.forEach(this::addItem);
        return this;
    }

    public SelectBuilder<T> columns(String ... paths) {
        return this.columns(Arrays.stream(paths).map(ElementRefImpl::parse));
    }

    public SelectBuilder<T> addItem(Selectable item) {
        this.columns.add(SelectListValueBuilder.refToSlv(item));
        return this;
    }

    public List<CqnSelectListItem> items() {
        return Collections.unmodifiableList(this.columns);
    }

    public SelectBuilder<T> excluding(Collection<String> slis) {
        this.excluding.clear();
        this.excluding.addAll(slis);
        return this;
    }

    public SelectBuilder<T> addExclude(String slis) {
        this.excluding.add(slis);
        return this;
    }

    public List<String> excluding() {
        return Collections.unmodifiableList(this.excluding);
    }

    public SelectBuilder<T> where(Function<T, CqnPredicate> pred) {
        return this.where(pred.apply(this.getType()));
    }

    public SelectBuilder<T> where(CqnPredicate pred) {
        this.where = pred;
        return this;
    }

    public SelectBuilder<T> where(Optional<? extends CqnPredicate> optionalWhere) {
        this.where = optionalWhere.orElse(null);
        return this;
    }

    public long top() {
        return this.top;
    }

    public long skip() {
        return this.skip;
    }

    public Select<T> byParams(Collection<String> elementRefs) {
        return this.where((CqnPredicate)ExpressionImpl.byParams(elementRefs));
    }

    public SelectBuilder<T> matching(Map<String, ?> values) {
        return this.where((CqnPredicate)ExpressionImpl.matching(values));
    }

    public SelectBuilder<T> byId(Object idValue) {
        return this.where((CqnPredicate)ExpressionImpl.byId(idValue));
    }

    public SelectBuilder<T> search(String searchTerm) {
        return this.search(searchTerm, (Iterable)Collections.emptyList());
    }

    public SelectBuilder<T> search(String searchTerm, Iterable<String> searchableElements) {
        return this.search(searchable -> searchable.has(searchTerm), (Iterable)searchableElements);
    }

    public SelectBuilder<T> search(Function<Searchable, Predicate> pred) {
        return this.search((Function)pred, (Iterable)Collections.emptyList());
    }

    public SelectBuilder<T> search(Function<Searchable, Predicate> pred, Iterable<String> searchableElements) {
        this.searchableElements.clear();
        searchableElements.forEach(this.searchableElements::add);
        this.search = (CqnPredicate)pred.apply(SearchPredicate::new);
        return this;
    }

    public SelectBuilder<T> search(CqnPredicate predicate) {
        this.search = predicate;
        return this;
    }

    public Collection<String> searchableElements() {
        return Collections.unmodifiableCollection(this.searchableElements);
    }

    public Optional<CqnPredicate> where() {
        return Optional.ofNullable(this.where);
    }

    public Optional<CqnPredicate> search() {
        return Optional.ofNullable(this.search);
    }

    public Select<T> lock(CqnLock.Mode mode, int timeout) {
        this.rowLock = new LockImpl(mode, timeout);
        return this;
    }

    public Select<T> lock(CqnLock.Mode mode) {
        this.rowLock = new LockImpl(mode);
        return this;
    }

    public Select<T> lockSelectedRows(CqnLock rowLock) {
        this.rowLock = rowLock;
        return this;
    }

    public Optional<CqnLock> getLock() {
        return Optional.ofNullable(this.rowLock);
    }

    public SelectBuilder<T> groupBy(List<? extends CqnValue> items) {
        return this.groupBy(items.stream());
    }

    @Deprecated
    public SelectBuilder<T> groupBy(Collection<CqnSelectListItem> items) {
        return this.groupBy(items.stream().flatMap(CqnSelectListItem::ofValue).map(CqnSelectListValue::value));
    }

    public SelectBuilder<T> groupBy(String ... refs) {
        return this.groupBy(Arrays.stream(refs).map(ElementRefImpl::parse));
    }

    public SelectBuilder<T> groupBy(Stream<? extends CqnValue> dimensions) {
        this.groupBy.clear();
        dimensions.forEach(this.groupBy::add);
        return this;
    }

    public List<CqnValue> groupBy() {
        return Collections.unmodifiableList(this.groupBy);
    }

    public SelectBuilder<T> having(Function<T, CqnPredicate> pred) {
        return this.having(pred.apply(this.getType()));
    }

    public SelectBuilder<T> having(CqnPredicate pred) {
        this.having = pred;
        return this;
    }

    public SelectBuilder<T> having(Optional<CqnPredicate> pred) {
        this.having = pred.orElse(null);
        return this;
    }

    public Optional<CqnPredicate> having() {
        return Optional.ofNullable(this.having);
    }

    public final SelectBuilder<T> orderBy(List<CqnSortSpecification> sortSpec) {
        this.orderBy.clear();
        this.orderBy.addAll(sortSpec);
        return this;
    }

    public List<CqnSortSpecification> orderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public Select<T> orderBy(String ... paths) {
        this.orderBy.clear();
        for (String path : paths) {
            ElementRef ref = ElementRefImpl.parse(path);
            this.orderBy.add(ref.asc());
        }
        return this;
    }

    public SelectBuilder<T> limit(long top, long skip) {
        this.top = top;
        this.skip = skip;
        return this;
    }

    public Optional<CqnLimit> limit() {
        if (this.hasLimit()) {
            return Optional.of(LimitImpl.create(this.top, this.skip));
        }
        return Optional.empty();
    }

    public CqnSelect build() {
        return this;
    }

    public Select<T> hints(Map<String, Object> hints) {
        this.hints = hints;
        return this;
    }

    public Select<T> hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    public Map<String, Object> hints() {
        return this.hints;
    }

    public T getType() {
        return (T)this.source.getType();
    }

    public static <U> Parameter<U> param() {
        return CqnParam.param();
    }

    public static <U> Parameter<U> param(String name) {
        return CqnParam.param(name);
    }

    public static <U> FunctionCall<U> func(String functionName, CqnValue ... args) {
        return ScalarFunctionCall.create(functionName, args);
    }

    public static <U> Literal<U> literal(U val) {
        return LiteralImpl.val(val);
    }

    public static Predicate not(Predicate p) {
        return Negation.not((CqnPredicate)p);
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object("from", this.source);
        if (this.isDistinct()) {
            cqn.put("distinct", true);
        }
        if (this.hasInlineCount()) {
            cqn.put("count", true);
        }
        if (!this.columns.isEmpty()) {
            ArrayNode cols = cqn.array("columns");
            this.columns.forEach(arg_0 -> ((ArrayNode)cols).addPOJO(arg_0));
        }
        if (!this.excluding.isEmpty()) {
            ArrayNode excl = cqn.array("excluding");
            this.excluding.forEach(arg_0 -> ((ArrayNode)excl).add(arg_0));
        }
        this.where().ifPresent(w -> {
            ArrayNode whereArr = cqn.array("where");
            w.tokens().forEach(arg_0 -> ((ArrayNode)whereArr).addPOJO(arg_0));
        });
        if (!this.groupBy.isEmpty()) {
            ArrayNode groupByArray = cqn.array("groupBy");
            this.groupBy.forEach(arg_0 -> ((ArrayNode)groupByArray).addPOJO(arg_0));
        }
        this.having().ifPresent(h -> {
            ArrayNode havingArr = cqn.array("having");
            h.tokens().forEach(arg_0 -> ((ArrayNode)havingArr).addPOJO(arg_0));
        });
        if (!this.orderBy.isEmpty()) {
            ArrayNode orderByArray = cqn.array("orderBy");
            this.orderBy.forEach(arg_0 -> ((ArrayNode)orderByArray).addPOJO(arg_0));
        }
        if (this.hasLimit()) {
            cqn.put("limit", LimitImpl.create(this.top, this.skip));
        }
        this.search().ifPresent(s -> cqn.put("search", s));
        this.getLock().ifPresent(f -> cqn.put(f.mode().csn(), f.timeout().isPresent() ? f : Jsonizer.empty()));
        return Jsonizer.object("SELECT", cqn).toJson();
    }
}

