/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.JSONizable;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;

public class UpdateBuilder<T extends StructuredType<?>>
implements Update<T> {
    private final T entity;
    private final List<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();
    private CqnPredicate where;

    private UpdateBuilder(T entity) {
        this.entity = entity;
    }

    public static <T extends StructuredType<?>> UpdateBuilder<T> entity(T entity) {
        return new UpdateBuilder<T>(entity);
    }

    public static UpdateBuilder<StructuredType<?>> entity(CqnStructuredTypeRef ref) {
        return new UpdateBuilder(StructuredTypeImpl.structuredType(ref));
    }

    public static UpdateBuilder<StructuredType<?>> copy(CqnUpdate update) {
        return UpdateBuilder.copy(update, ExpressionVisitor.COPY);
    }

    public static UpdateBuilder<StructuredType<?>> copy(CqnUpdate update, Modifier modifier) {
        StructuredTypeRef ref = ExpressionVisitor.copy(update.ref(), modifier);
        UpdateBuilder<StructuredType<?>> copy = UpdateBuilder.entity((CqnStructuredTypeRef)ref);
        copy.where = modifier.where((Predicate)ExpressionVisitor.copy(update.where(), modifier));
        return copy.entries((Iterable)update.entries());
    }

    public UpdateBuilder<T> data(Map<String, ?> data) {
        this.entries.clear();
        this.addEntry(data);
        return this;
    }

    public UpdateBuilder<T> data(String key, Object value) {
        return this.data((Map)Collections.singletonMap(key, value));
    }

    public UpdateBuilder<T> entries(Iterable<? extends Map<String, ?>> entries) {
        this.entries.clear();
        entries.forEach(this::addEntry);
        return this;
    }

    private void addEntry(Map<String, ?> entry) {
        this.entries.add(DataUtils.copyMap(entry));
    }

    public UpdateBuilder<T> where(Function<T, CqnPredicate> pred) {
        this.where(pred.apply(this.entity.getType()));
        return this;
    }

    public UpdateBuilder<T> matching(Map<String, ?> values) {
        return this.where((CqnPredicate)ExpressionImpl.matching(values));
    }

    public UpdateBuilder<T> byParams(Collection<String> elementRefs) {
        return this.where((CqnPredicate)ExpressionImpl.byParams(elementRefs));
    }

    public UpdateBuilder<T> byId(Object idValue) {
        return this.where((CqnPredicate)ExpressionImpl.byId(idValue));
    }

    public UpdateBuilder<T> where(CqnPredicate pred) {
        this.where = pred;
        return this;
    }

    public CqnStructuredTypeRef ref() {
        return StructuredTypeRefImpl.typeRef(this.entity);
    }

    public Optional<CqnPredicate> where() {
        return Optional.ofNullable(this.where);
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object("entity", (JSONizable)this.ref());
        if (this.entries.size() == 1) {
            ObjectNode dta = cqn.object("data");
            this.entries.get(0).forEach((arg_0, arg_1) -> ((ObjectNode)dta).putPOJO(arg_0, arg_1));
        } else {
            ArrayNode dta = cqn.array("entries");
            this.entries.forEach(arg_0 -> ((ArrayNode)dta).addPOJO(arg_0));
        }
        this.where().ifPresent(w -> {
            ArrayNode whereArr = cqn.array("where");
            w.tokens().forEach(arg_0 -> ((ArrayNode)whereArr).addPOJO(arg_0));
        });
        return Jsonizer.object("UPDATE", cqn).toJson();
    }

    public String toString() {
        return this.toJson();
    }

    public Map<String, Object> data() {
        return this.entries.get(0);
    }

    public List<Map<String, Object>> entries() {
        return this.entries;
    }

    public Stream<String> elements() {
        TreeSet all = new TreeSet();
        for (Map<String, Object> map : this.entries) {
            DataUtils.deepMapKeys(map).forEach(all::add);
        }
        return all.stream();
    }
}

