/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class CdsAnnotableBuilder<T extends CdsAnnotatable> {
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsAnnotableBuilder.class);
    private static final String IGNORE = "@calm.runtime.ignore".substring(1);
    protected final List<CdsAnnotation<?>> annotations = new ArrayList();

    CdsAnnotableBuilder(List<CdsAnnotation<?>> annotations) {
        this.annotations.addAll(annotations);
    }

    public CdsAnnotableBuilder<T> annotation(CdsAnnotation<?> a) {
        this.annotations.add(a);
        return this;
    }

    boolean toBeIgnored(String path) {
        boolean toBeIgnored = this.annotations.stream().anyMatch(a -> IGNORE.equals(a.getName()) && (Boolean)a.getValue() != false);
        if (toBeIgnored) {
            issueCollector.warning(path, "The artifact '%s' is annotated with %s and is excluded from the CDS model. This could lead to an inconsistent model.", path, "@calm.runtime.ignore");
        }
        return toBeIgnored;
    }
}

