/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class CdsAnnotatableImpl
implements CdsAnnotatable {
    private final Map<String, CdsAnnotation<?>> annotations;
    private final String doc;

    protected CdsAnnotatableImpl(Collection<CdsAnnotation<?>> annos, String doc) {
        this.doc = doc;
        if (annos.isEmpty()) {
            this.annotations = Collections.emptyMap();
        } else {
            this.annotations = new HashMap(annos.size());
            annos.forEach(a -> this.annotations.put(a.getName(), (CdsAnnotation<?>)a));
        }
    }

    public Stream<CdsAnnotation<?>> annotations() {
        return this.annotations.values().stream();
    }

    public <T> Optional<CdsAnnotation<T>> findAnnotation(String name) {
        return Optional.ofNullable(this.annotations.get(CdsAnnotatableImpl.removeAt(name)));
    }

    public static String removeAt(String name) {
        if (name.startsWith("@")) {
            name = name.substring(1);
        }
        return name;
    }

    public Optional<String> getDoc() {
        return Optional.ofNullable(this.doc);
    }

    public static class CdsAnnotationImpl<T>
    implements CdsAnnotation<T> {
        private final String name;
        private final T value;

        private CdsAnnotationImpl(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public static <T> CdsAnnotation<T> annotation(String name, T value) {
            return new CdsAnnotationImpl<T>(CdsAnnotatableImpl.removeAt(name), value);
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }
    }
}

