/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsDefinitionImpl;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CdsArrayedTypeBuilder
extends CdsTypeBuilder<CdsArrayedType> {
    private CdsTypeBuilder<?> itemsType;
    private CdsArrayedType impl;
    private String name;

    public CdsArrayedTypeBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsTypeBuilder<?> itemsType) {
        super(annotations, qualifiedName, name);
        this.itemsType = itemsType;
        this.name = name;
    }

    public CdsArrayedTypeBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name) {
        this(annotations, qualifiedName, name, null);
    }

    public static CdsArrayedType arrayedType(CdsTypeBuilder<?> itemsType) {
        return new CdsArrayedTypeBuilder(Collections.emptyList(), "", "", itemsType).build();
    }

    public void setItemsType(CdsTypeBuilder<?> type) {
        this.itemsType = type;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public CdsArrayedType build() {
        if (this.impl == null) {
            CdsType immutableType = (CdsType)this.itemsType.build();
            this.impl = new CdsArrayedTypeImpl(this.annotations, this.qualifiedName, this.getName(), immutableType);
        }
        return this.impl;
    }

    @Override
    public boolean isArrayed() {
        return true;
    }

    @Override
    public boolean isStructured() {
        return false;
    }

    private static class CdsArrayedTypeImpl
    extends CdsDefinitionImpl
    implements CdsArrayedType {
        private final CdsType itemsType;

        private CdsArrayedTypeImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsType itemsType) {
            super(annotations, qualifiedName, name, null);
            this.itemsType = itemsType;
        }

        public CdsType getItemsType() {
            return this.itemsType;
        }

        public CdsKind getKind() {
            return CdsKind.TYPE;
        }
    }
}

