/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.reflect.impl.CdsActionBuilder;
import com.sap.cds.reflect.impl.CdsFunctionBuilder;
import com.sap.cds.reflect.impl.CdsUnboundActionAndFunctionReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CdsBoundActionAndFunctionReader {
    List<CdsActionBuilder> actionList = new ArrayList<CdsActionBuilder>();
    List<CdsFunctionBuilder> functionList = new ArrayList<CdsFunctionBuilder>();
    final boolean readDocs;

    public CdsBoundActionAndFunctionReader(JsonNode csn, boolean readDocComments) {
        this.readDocs = readDocComments;
        if (csn.has("actions")) {
            JsonNode jsonNode = csn.get("actions");
            jsonNode.fields().forEachRemaining(e -> this.addToList((Map.Entry<String, JsonNode>)e));
        }
    }

    private void addToList(Map.Entry<String, JsonNode> defEntry) {
        String defName = defEntry.getKey();
        JsonNode defCsn = defEntry.getValue();
        JsonNode kind = defCsn.get("kind");
        if (kind != null) {
            if (kind.asText().equals("action")) {
                CdsActionBuilder action = CdsUnboundActionAndFunctionReader.readAction(defName, defName, defCsn, this.readDocs);
                this.actionList.add(action);
            }
            if (kind.asText().equals("function")) {
                CdsFunctionBuilder function = CdsUnboundActionAndFunctionReader.readFunction(defName, defName, defCsn, this.readDocs);
                this.functionList.add(function);
            }
        }
    }

    public List<CdsActionBuilder> getActions() {
        return this.actionList;
    }

    public List<CdsFunctionBuilder> getFunctions() {
        return this.functionList;
    }
}

