/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsBoundActionAndFunctionReader;
import com.sap.cds.reflect.impl.CdsEntityBuilder;
import com.sap.cds.reflect.impl.CdsParameterBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeReader;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CdsEntityReader {
    private static boolean readDocs = false;

    private CdsEntityReader() {
    }

    public static CdsEntityBuilder read(String name, String qualifiedName, JsonNode csn, boolean readDocComments) {
        readDocs = readDocComments;
        CdsEntityBuilder newEntity = CdsEntityBuilder.create(name, qualifiedName, CdsAnnotationReader.read(csn), CdsEntityReader.isAbstract(csn), CdsEntityReader.getQuery(csn), readDocs ? CdsModelUtils.getDoc(csn) : null);
        CdsBoundActionAndFunctionReader actionsAndFunctions = new CdsBoundActionAndFunctionReader(csn, readDocs);
        newEntity.addActions(actionsAndFunctions.getActions());
        newEntity.addFunctions(actionsAndFunctions.getFunctions());
        return newEntity;
    }

    private static String getQuery(JsonNode csn) {
        String query = null;
        if (csn.has("projection")) {
            query = "{\"SELECT\":" + csn.get("projection").toString() + "}";
        } else if (csn.has("query")) {
            query = csn.get("query").toString();
        }
        return query;
    }

    private static boolean isAbstract(JsonNode csn) {
        if (csn.has("abstract")) {
            return csn.get("abstract").asBoolean();
        }
        return false;
    }

    public static class CdsParameterReader {
        public static List<CdsParameter> read(String path, JsonNode csn, Function<String, Optional<CdsTypeBuilder<?>>> typeFinder) {
            if (csn.has("params")) {
                return CdsParameterReader.getParameters(csn.get("params"), typeFinder);
            }
            return Collections.emptyList();
        }

        private static List<CdsParameter> getParameters(JsonNode jsonNode, Function<String, Optional<CdsTypeBuilder<?>>> typeFinder) {
            ArrayList<CdsParameter> paramList = new ArrayList<CdsParameter>();
            Iterator fields = jsonNode.fields();
            fields.forEachRemaining(field -> {
                String paramName = (String)field.getKey();
                String paramType = ((JsonNode)field.getValue()).get("type").asText();
                Optional type = (Optional)typeFinder.apply(paramType);
                CdsTypeBuilder cdsType = type.orElseGet(() -> CdsSimpleTypeReader.read(paramType, paramType, (JsonNode)field.getValue()));
                List<CdsAnnotation<?>> annotations = CdsAnnotationReader.read((JsonNode)field.getValue());
                Function<CdsType, Object> defValProvider = t -> TokenParser.defaultValue(((JsonNode)field.getValue()).get("default"), t);
                paramList.add(new CdsParameterBuilder(annotations, paramName, cdsType, defValProvider, readDocs ? CdsModelUtils.getDoc((JsonNode)field.getValue()) : null).build());
            });
            return paramList;
        }
    }
}

