/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.google.common.base.Objects;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsEventBuilder
extends CdsStructuredTypeBuilder<CdsEvent> {
    private final CqnSelect query;
    private final String doc;
    private static final Logger logger = LoggerFactory.getLogger(CdsEventBuilder.class);
    private String delegationType;

    public CdsEventBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CqnSelect query, String doc) {
        super(annotations, qualifiedName, name, CdsKind.EVENT, doc);
        this.doc = doc;
        this.query = query;
    }

    public static CdsEventBuilder create(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, String query, String doc) {
        Select select = null;
        if (query != null) {
            try {
                select = Select.cqn((String)query);
            }
            catch (RuntimeException e) {
                logger.warn(String.format("The event %s has an unrecognized query definition: %s - Detailed error message: %s", qualifiedName, query, e));
            }
        }
        return new CdsEventBuilder(annotations, qualifiedName, name, (CqnSelect)select, doc);
    }

    void addDelegationType(String delegationType) {
        this.delegationType = delegationType;
    }

    @Override
    public CdsEvent build(CdsModel model) {
        if (this.delegationType == null) {
            CdsEventImpl impl = new CdsEventImpl(this.annotations, this.qualifiedName, this.getName(), this.query, this.doc);
            this.putElements(impl);
            return impl;
        }
        return new EventProxy(this.annotations, this.qualifiedName, this.getName(), this.delegationType, model, this.doc);
    }

    @Override
    public CdsEvent build() {
        throw new UnsupportedOperationException();
    }

    private static class CdsEventImpl
    extends CdsStructuredTypeBuilder.CdsStructuredTypeImpl
    implements CdsEvent {
        private final CqnSelect query;

        private CdsEventImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, CqnSelect query, String doc) {
            super(annotations, qualifiedName, name, doc);
            this.query = query;
        }
    }

    public static class EventProxy
    extends CdsStructuredTypeBuilder.CdsStructuredTypeImpl
    implements CdsEvent {
        private String delegationType;
        private CdsModel model;

        protected EventProxy(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, String delegationType, CdsModel model, String doc) {
            super(annotations, qualifiedName, name, doc);
            this.delegationType = delegationType;
            this.model = model;
        }

        @Override
        public CdsElement getElement(String name) {
            return this.changeDeclarator(this.model.getStructuredType(this.delegationType).getElement(name));
        }

        private CdsElement changeDeclarator(CdsElement element) {
            return new ElementProxy(element);
        }

        @Override
        public Optional<CdsElement> findElement(String name) {
            return Optional.of(this.model.getStructuredType(this.delegationType).getElement(name)).map(this::changeDeclarator);
        }

        @Override
        public Stream<CdsElement> elements() {
            return this.model.getStructuredType(this.delegationType).elements().map(this::changeDeclarator);
        }

        private class ElementProxy
        implements CdsElement {
            private final CdsElement element;

            public ElementProxy(CdsElement element) {
                this.element = element;
            }

            public String getName() {
                return this.element.getName();
            }

            public Stream<CdsAnnotation<?>> annotations() {
                return this.element.annotations();
            }

            public <T extends CdsType> T getType() {
                return (T)this.element.getType();
            }

            public <T> Optional<CdsAnnotation<T>> findAnnotation(String name) {
                return this.element.findAnnotation(name);
            }

            public boolean isKey() {
                return this.element.isKey();
            }

            public boolean isVirtual() {
                return this.element.isVirtual();
            }

            public boolean isUnique() {
                return this.element.isUnique();
            }

            public boolean isNotNull() {
                return this.element.isNotNull();
            }

            public boolean isLocalized() {
                return this.element.isLocalized();
            }

            public Optional<Object> defaultValue() {
                return this.element.defaultValue();
            }

            public CdsEvent getDeclaringType() {
                return EventProxy.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof CdsElement)) {
                    return false;
                }
                CdsElement elementToCompare = (CdsElement)object;
                return elementToCompare.getName().equals(this.element.getName()) && this.getDeclaringType().getQualifiedName().equals(elementToCompare.getDeclaringType().getQualifiedName());
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.element.getName(), this.getDeclaringType().getQualifiedName()});
            }
        }
    }
}

