/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsDefinitionBuilder;
import com.sap.cds.reflect.impl.CdsDefinitionImpl;
import com.sap.cds.reflect.impl.CdsParameterBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class CdsFunctionBuilder
extends CdsDefinitionBuilder<CdsFunction> {
    private final List<CdsParameterBuilder> parameters = new ArrayList<CdsParameterBuilder>();
    private final String doc;
    private CdsTypeBuilder<?> returnType;
    private CdsFunctionImpl impl = null;

    public CdsFunctionBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, String doc) {
        super(annotations, qualifiedName, name);
        this.doc = doc;
    }

    @Override
    public CdsFunction build() {
        if (this.impl == null) {
            ArrayList immutableParameters = new ArrayList();
            this.parameters.forEach(p -> immutableParameters.add(p.build()));
            this.impl = new CdsFunctionImpl(this.annotations, this.qualifiedName, this.getName(), immutableParameters, this.doc);
            if (this.returnType != null) {
                this.impl.returnType = (CdsType)this.returnType.build();
            }
        }
        return this.impl;
    }

    void addParameter(CdsParameterBuilder para) {
        this.parameters.add(para);
    }

    void addParameters(List<CdsParameterBuilder> params) {
        params.forEach(this::addParameter);
    }

    void setReturnType(CdsTypeBuilder<?> returnType) {
        this.returnType = returnType;
    }

    private static class CdsFunctionImpl
    extends CdsDefinitionImpl
    implements CdsFunction {
        private final List<CdsParameter> parameters = new ArrayList<CdsParameter>();
        private CdsType returnType;

        private CdsFunctionImpl(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, List<CdsParameter> parameters, String doc) {
            super(annotations, qualifiedName, name, doc);
            this.parameters.addAll(parameters);
        }

        public Stream<CdsParameter> parameters() {
            return this.parameters.stream();
        }

        public CdsType getReturnType() {
            return this.returnType;
        }
    }
}

