/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsActionBuilder;
import com.sap.cds.reflect.impl.CdsDefinitionBuilder;
import com.sap.cds.reflect.impl.CdsEntityBuilder;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.reflect.impl.CdsFunctionBuilder;
import com.sap.cds.reflect.impl.CdsServiceBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CdsModelBuilder {
    private final Map<String, CdsEntityBuilder> entities = new HashMap<String, CdsEntityBuilder>();
    private final Map<String, CdsServiceBuilder> services = new HashMap<String, CdsServiceBuilder>();
    private final Map<String, CdsActionBuilder> actions = new HashMap<String, CdsActionBuilder>();
    private final Map<String, CdsFunctionBuilder> functions = new HashMap<String, CdsFunctionBuilder>();
    private final Map<String, CdsEventBuilder> events = new HashMap<String, CdsEventBuilder>();
    private final Map<String, CdsTypeBuilder<?>> types = new HashMap();
    private final Map<String, Object> meta = new HashMap<String, Object>();
    private final Map<String, Collection<CdsAnnotation<?>>> contextAnnotations = new HashMap();

    private CdsModelBuilder() {
    }

    public static CdsModelBuilder create() {
        return new CdsModelBuilder();
    }

    public Stream<CdsEntityBuilder> concreteEntities() {
        return this.entities().filter(e -> !e.isAbstract());
    }

    void addAnnotations(String key, Collection<CdsAnnotation<?>> annotations) {
        this.contextAnnotations.put(key, annotations);
    }

    public Optional<CdsTypeBuilder<? extends CdsType>> findType(String qualifiedName) {
        CdsTypeBuilder<?> type = this.types.get(qualifiedName);
        if (type != null) {
            return Optional.of(type);
        }
        return Optional.ofNullable(this.entities.get(qualifiedName));
    }

    public Stream<CdsEntityBuilder> entities() {
        return this.entities.values().stream();
    }

    public Optional<CdsEntityBuilder> findEntity(String qualifiedName) {
        return Optional.ofNullable(this.entities.get(qualifiedName));
    }

    public CdsEntityBuilder getEntity(String qualifiedName) {
        return this.findEntity(qualifiedName).orElseThrow(CdsModelBuilder.notFound(CdsKind.ENTITY, qualifiedName));
    }

    public Optional<CdsTypeBuilder<?>> findAspect(String qualifiedName) {
        return Optional.ofNullable(this.types.get(qualifiedName));
    }

    public CdsTypeBuilder<?> getAspect(String qualifiedName) {
        return this.findAspect(qualifiedName).orElseThrow(CdsModelBuilder.notFound(CdsKind.ASPECT, qualifiedName));
    }

    public Optional<CdsActionBuilder> findAction(String qualifiedName) {
        return Optional.ofNullable(this.actions.get(qualifiedName));
    }

    public Optional<CdsFunctionBuilder> findFunction(String qualifiedName) {
        return Optional.ofNullable(this.functions.get(qualifiedName));
    }

    public <T> T getMeta(String key) {
        return (T)this.meta.get(key);
    }

    void addType(String key, CdsTypeBuilder<?> type) {
        this.types.put(key, type);
    }

    void addEntity(CdsEntityBuilder entity) {
        this.addEntity(entity.qualifiedName, entity);
    }

    void addEntity(String key, CdsEntityBuilder entity) {
        this.entities.put(key, entity);
    }

    void addEvent(CdsEventBuilder event) {
        this.addEvent(event.getQualifiedName(), event);
    }

    void addEvent(String key, CdsEventBuilder event) {
        this.events.put(key, event);
    }

    public void addService(CdsServiceBuilder service) {
        this.addService(service.getQualifiedName(), service);
    }

    void addService(String key, CdsServiceBuilder service) {
        this.services.put(key, service);
    }

    void addFunction(CdsFunctionBuilder function) {
        this.addFunction(function.getQualifiedName(), function);
    }

    void addFunction(String key, CdsFunctionBuilder function) {
        this.functions.put(key, function);
    }

    void addAction(CdsActionBuilder action) {
        this.addAction(action.getQualifiedName(), action);
    }

    void addAction(String key, CdsActionBuilder action) {
        this.actions.put(key, action);
    }

    void addMeta(String key, Object value) {
        this.meta.put(key, value);
    }

    void addMeta(Map<String, Object> meta) {
        this.meta.putAll(meta);
    }

    private static Supplier<CdsDefinitionNotFoundException> notFound(CdsKind kind, String qualifiedName) {
        return () -> new CdsDefinitionNotFoundException(kind, qualifiedName);
    }

    public CdsModel build() {
        Map immutableEntities = CdsModelBuilder.buildDefinitions(this.entities);
        Map<String, CdsType> immuteableTypes = CdsModelBuilder.buildTypes(this.types);
        Map immutableActions = CdsModelBuilder.buildDefinitions(this.actions);
        Map immutableFunctions = CdsModelBuilder.buildDefinitions(this.functions);
        return new CdsModelImpl(immutableEntities, this.services, immutableActions, immutableFunctions, this.events, immuteableTypes, this.meta, this.contextAnnotations);
    }

    private static <T extends CdsDefinition> Map<String, T> buildDefinitions(Map<String, ? extends CdsDefinitionBuilder<T>> builders) {
        HashMap definitions = new HashMap();
        builders.forEach((n, b) -> {
            if (!b.toBeIgnored(b.getQualifiedName())) {
                definitions.put(n, b.build());
            }
        });
        return definitions;
    }

    private static Map<String, CdsType> buildTypes(Map<String, CdsTypeBuilder<?>> builders) {
        HashMap<String, CdsType> types = new HashMap<String, CdsType>();
        builders.forEach((n, b) -> {
            if (!b.toBeIgnored(b.getQualifiedName())) {
                types.put((String)n, (CdsType)b.build());
            }
        });
        return types;
    }

    private static class CdsModelImpl
    implements CdsModel {
        private final Map<String, CdsDefinition> definitions = new HashMap<String, CdsDefinition>();
        private final Map<String, Object> meta;
        private final Map<String, Collection<CdsAnnotation<?>>> contextAnnotations;

        private CdsModelImpl(Map<String, CdsEntity> entities, Map<String, CdsServiceBuilder> servicesBuilders, Map<String, CdsAction> actions, Map<String, CdsFunction> functions, Map<String, CdsEventBuilder> eventBuilders, Map<String, CdsType> types, Map<String, Object> meta, Map<String, Collection<CdsAnnotation<?>>> contextAnnotations) {
            this.definitions.putAll(entities);
            this.definitions.putAll(this.buildServices(servicesBuilders));
            this.definitions.putAll(actions);
            this.definitions.putAll(functions);
            this.definitions.putAll(this.buildEvents(eventBuilders));
            this.definitions.putAll(types);
            this.meta = meta;
            this.contextAnnotations = contextAnnotations;
        }

        private Map<String, CdsService> buildServices(Map<String, CdsServiceBuilder> services) {
            HashMap<String, CdsService> immutableServices = new HashMap<String, CdsService>();
            services.forEach((name, sb) -> immutableServices.put((String)name, sb.build(this)));
            return immutableServices;
        }

        private Map<String, CdsEvent> buildEvents(Map<String, CdsEventBuilder> builders) {
            HashMap<String, CdsEvent> definitions = new HashMap<String, CdsEvent>();
            builders.forEach((name, eb) -> definitions.put((String)name, eb.build(this)));
            return definitions;
        }

        public Stream<CdsAnnotation<?>> annotations(String namespace) {
            return ((Collection)this.contextAnnotations.getOrDefault(namespace, Collections.emptyList())).stream();
        }

        public Stream<CdsService> services() {
            return this.streamAs(CdsModelImpl::isService, CdsService.class);
        }

        public CdsService getService(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isService, CdsService.class, CdsKind.SERVICE);
        }

        public Optional<CdsService> findService(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isService, CdsService.class);
        }

        public Stream<CdsType> types() {
            return this.streamAs(CdsModelImpl::isType, CdsType.class);
        }

        public <T extends CdsType> T getType(String qualifiedName) {
            return (T)this.getAs(qualifiedName, CdsModelImpl::isType, CdsType.class, CdsKind.TYPE);
        }

        public <T extends CdsType> Optional<T> findType(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isType, CdsType.class);
        }

        public Stream<CdsEntity> entities() {
            return this.streamAs(CdsModelImpl::isEntity, CdsEntity.class);
        }

        public CdsEntity getEntity(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isEntity, CdsEntity.class, CdsKind.ENTITY);
        }

        public Optional<CdsEntity> findEntity(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isEntity, CdsEntity.class);
        }

        public Optional<CdsAction> findAction(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isAction, CdsAction.class);
        }

        public Stream<CdsAction> actions() {
            return this.streamAs(CdsModelImpl::isAction, CdsAction.class);
        }

        public CdsAction getAction(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isAction, CdsAction.class, CdsKind.ACTION);
        }

        public Optional<CdsFunction> findFunction(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isFunction, CdsFunction.class);
        }

        public Stream<CdsFunction> functions() {
            return this.streamAs(CdsModelImpl::isFunction, CdsFunction.class);
        }

        public CdsFunction getFunction(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isFunction, CdsFunction.class, CdsKind.FUNCTION);
        }

        public Stream<CdsEvent> events() {
            return this.streamAs(CdsModelImpl::isEvent, CdsEvent.class);
        }

        public CdsEvent getEvent(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isEvent, CdsEvent.class, CdsKind.EVENT);
        }

        public Optional<CdsEvent> findEvent(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isEvent, CdsEvent.class);
        }

        public Stream<CdsStructuredType> structuredTypes() {
            return this.streamAs(CdsModelImpl::isStructuredType, CdsStructuredType.class);
        }

        public CdsStructuredType getStructuredType(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isStructuredType, CdsStructuredType.class, CdsKind.TYPE);
        }

        public Optional<CdsStructuredType> findStructuredType(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isStructuredType, CdsStructuredType.class);
        }

        public Stream<CdsStructuredType> aspects() {
            return this.streamAs(CdsModelImpl::isAspect, CdsStructuredType.class);
        }

        public CdsStructuredType getAspect(String qualifiedName) {
            return this.getAs(qualifiedName, CdsModelImpl::isAspect, CdsStructuredType.class, CdsKind.TYPE);
        }

        public Optional<CdsStructuredType> findAspect(String qualifiedName) {
            return this.findAs(qualifiedName, CdsModelImpl::isAspect, CdsStructuredType.class);
        }

        public <T> T getMeta(String key) {
            return (T)this.meta.get(key);
        }

        public String getVersion() {
            return (String)this.getMeta("version");
        }

        private static boolean isService(CdsDefinition def) {
            return def.getKind() == CdsKind.SERVICE;
        }

        private static boolean isEvent(CdsDefinition def) {
            return def.getKind() == CdsKind.EVENT;
        }

        private static boolean isEntity(CdsDefinition def) {
            return def.getKind() == CdsKind.ENTITY;
        }

        private static boolean isAction(CdsDefinition def) {
            return def.getKind() == CdsKind.ACTION;
        }

        private static boolean isFunction(CdsDefinition def) {
            return def.getKind() == CdsKind.FUNCTION;
        }

        private static boolean isType(CdsDefinition def) {
            return def.getKind() == CdsKind.TYPE || def.getKind() == CdsKind.ASPECT;
        }

        private static boolean isAspect(CdsDefinition def) {
            return def.getKind() == CdsKind.ASPECT;
        }

        private static boolean isStructuredType(CdsDefinition def) {
            CdsKind kind = def.getKind();
            return kind == CdsKind.EVENT || kind == CdsKind.ENTITY || kind == CdsKind.ASPECT || kind == CdsKind.TYPE && ((CdsType)def).isStructured();
        }

        private <T extends CdsDefinition> T getAs(String qualifiedName, Predicate<CdsDefinition> filter, Class<T> clazz, CdsKind kind) {
            return (T)((CdsDefinition)this.findAs(qualifiedName, filter, clazz).orElseThrow(CdsModelBuilder.notFound(kind, qualifiedName)));
        }

        private <T extends CdsDefinition> Optional<T> findAs(String qualifiedName, Predicate<CdsDefinition> filter, Class<T> clazz) {
            return this.findDefinition(qualifiedName).filter(filter).map(def -> def.as(clazz));
        }

        private <T extends CdsDefinition> Stream<T> streamAs(Predicate<CdsDefinition> filter, Class<T> clazz) {
            return this.definitions.values().stream().filter(filter).map(def -> def.as(clazz));
        }

        private Optional<CdsDefinition> findDefinition(String qualifiedName) {
            return this.definitions.containsKey(qualifiedName) ? Optional.of(this.definitions.get(qualifiedName)) : Optional.empty();
        }
    }
}

