/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import com.sap.cds.CdsException;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsActionBuilder;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsArrayedTypeBuilder;
import com.sap.cds.reflect.impl.CdsArrayedTypeReader;
import com.sap.cds.reflect.impl.CdsAssociationReader;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsEntityBuilder;
import com.sap.cds.reflect.impl.CdsEntityReader;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.reflect.impl.CdsEventReader;
import com.sap.cds.reflect.impl.CdsFunctionBuilder;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsParameterBuilder;
import com.sap.cds.reflect.impl.CdsServiceBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeReader;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import com.sap.cds.reflect.impl.CdsStructuredTypeReader;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.reflect.impl.CdsUnboundActionAndFunctionReader;
import com.sap.cds.reflect.impl.DraftAdapter;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.util.NameResolver;
import com.sap.cds.util.StructuredTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CdsModelReader
implements CdsModel.Reader {
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsModelReader.class);
    private static final ObjectMapper jackson = new ObjectMapper();
    private static final HashFunction hasher = Hashing.goodFastHash((int)160);
    private static final Cache<HashCode, CdsModel> nonDraftModels = CacheBuilder.newBuilder().weakValues().maximumSize(5L).build();
    private static final Cache<HashCode, CdsModel> draftModels = CacheBuilder.newBuilder().weakValues().maximumSize(5L).build();
    private final CdsModelBuilder cdsModel = CdsModelBuilder.create();
    private static boolean readDocs = false;
    private NameResolver nameResolver;
    private StructuredTypeResolver structResolver;

    public CdsModel readCsn(InputStream is) {
        return CdsModelReader.read(is);
    }

    public CdsModel readCsn(String csn) {
        return CdsModelReader.read(csn, false);
    }

    public static CdsModel read(InputStream is) {
        return CdsModelReader.read(is, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CdsModel read(InputStream is, boolean adaptDraftEntities) {
        if (is == null) {
            throw new CdsException("Cannot read CDS model: InputStream must not be null");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            CdsModel cdsModel = CdsModelReader.read(CharStreams.toString((Readable)reader), adaptDraftEntities);
            return cdsModel;
        }
        catch (Exception e) {
            throw new CdsException("Cannot read CDS model: ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CdsModel read(InputStream is, boolean adaptDraftEntities, boolean readDoc) {
        if (is == null) {
            throw new CdsException("Cannot read CDS model: InputStream must not be null");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            CdsModel cdsModel = CdsModelReader.read(CharStreams.toString((Readable)reader), adaptDraftEntities, readDoc);
            return cdsModel;
        }
        catch (Exception e) {
            throw new CdsException("Cannot read CDS model: ", (Throwable)e);
        }
    }

    public static CdsModel read(String csn, boolean adaptDraftEntities) {
        return CdsModelReader.read(csn, adaptDraftEntities, false);
    }

    public static CdsModel read(JsonNode jObject) {
        return CdsModelReader.read(jObject, false);
    }

    public static CdsModel read(JsonNode jObject, boolean adaptDraftEntities) {
        return CdsModelReader.read(jObject.toString(), adaptDraftEntities, false);
    }

    public static CdsModel read(JsonNode jObject, boolean adaptDraftEntities, boolean readDocs) {
        return CdsModelReader.read(jObject.toString(), adaptDraftEntities, readDocs);
    }

    public static CdsModel read(String csn, boolean adaptDraftEntities, boolean readDocs) {
        return CdsModelReader.read(Collections.singletonList(csn), adaptDraftEntities, readDocs);
    }

    public static CdsModel read(List<String> csnList, boolean adaptDraftEntities, boolean readDocs) {
        return CdsModelReader.readCached(csnList, adaptDraftEntities, readDocs);
    }

    private static CdsModel readCached(List<String> csnList, boolean adaptDraftEntities, boolean readDocs) {
        HashCode hash = hasher.hashString((CharSequence)csnList.stream().collect(Collectors.joining()), StandardCharsets.UTF_8);
        Cache<HashCode, CdsModel> cache = adaptDraftEntities ? draftModels : nonDraftModels;
        try {
            return (CdsModel)cache.get((Object)hash, () -> CdsModelReader.parse(csnList, adaptDraftEntities, readDocs));
        }
        catch (ExecutionException e) {
            throw new CdsException("Cannot load CDS model: ", (Throwable)e);
        }
    }

    private static CdsModel parse(List<String> csnList, boolean adaptDraftEntities, boolean readDocs) {
        try {
            ArrayList<JsonNode> jObjects = new ArrayList<JsonNode>();
            for (String csn : csnList) {
                jObjects.add(jackson.readTree(csn));
            }
            return new CdsModelReader().parseNodes(jObjects, adaptDraftEntities, readDocs);
        }
        catch (Exception e) {
            throw new CdsException("Cannot parse CDS model: ", (Throwable)e);
        }
    }

    private static JsonNode asObject(JsonNode element) {
        if (element != null) {
            return element;
        }
        return new ObjectNode(null);
    }

    private CdsModel parseNodes(List<JsonNode> csnList, boolean adaptDraftEntities, boolean readDocComments) {
        readDocs = readDocComments;
        HashSet<String> qualifiedDefinitionNames = new HashSet<String>();
        HashMap<String, JsonNode> typeObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> contextObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> serviceObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> entityObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> actionObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> functionObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> eventObjects = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> structuredObjects = new HashMap<String, JsonNode>();
        DraftAdapter draftAdapter = new DraftAdapter(adaptDraftEntities, entityObjects, serviceObjects);
        for (JsonNode csn : csnList) {
            JsonNode definitions = CdsModelReader.asObject(csn.get("definitions"));
            Iterator fields = definitions.fields();
            block20: while (fields.hasNext()) {
                String kind;
                String name = (String)((Map.Entry)fields.next()).getKey();
                JsonNode object = definitions.get(name);
                switch (kind = object.get("kind").asText()) {
                    case "aspect": 
                    case "type": {
                        typeObjects.put(name, object);
                        continue block20;
                    }
                    case "entity": {
                        entityObjects.put(name, object);
                        draftAdapter.processEntity(name, object);
                        continue block20;
                    }
                    case "action": {
                        actionObjects.put(name, object);
                        continue block20;
                    }
                    case "function": {
                        functionObjects.put(name, object);
                        continue block20;
                    }
                    case "context": {
                        contextObjects.put(name, object);
                        continue block20;
                    }
                    case "service": {
                        serviceObjects.put(name, object);
                        continue block20;
                    }
                    case "event": {
                        eventObjects.put(name, object);
                        continue block20;
                    }
                }
                issueCollector.unrecognized(name, "The CDS model contains a definition with name '%s' that has an unrecognized type '%s'.", name, kind);
            }
        }
        qualifiedDefinitionNames.addAll(entityObjects.keySet());
        qualifiedDefinitionNames.addAll(eventObjects.keySet());
        qualifiedDefinitionNames.addAll(typeObjects.keySet());
        qualifiedDefinitionNames.addAll(actionObjects.keySet());
        qualifiedDefinitionNames.addAll(functionObjects.keySet());
        this.nameResolver = new NameResolver(qualifiedDefinitionNames, serviceObjects.keySet());
        draftAdapter.adaptDraftEntities();
        this.readMetaInfo(csnList.get(0));
        this.readEntities(entityObjects);
        this.readServices(serviceObjects);
        this.readUnboundActions(actionObjects);
        this.readUnboundFunctions(functionObjects);
        this.readTypes(typeObjects);
        this.readAnnotations(contextObjects);
        structuredObjects.putAll(entityObjects);
        structuredObjects.putAll(eventObjects);
        structuredObjects.putAll(typeObjects);
        this.structResolver = new StructuredTypeResolver(structuredObjects);
        this.readEvents(eventObjects);
        this.addElementsToTypes(typeObjects);
        this.addTypesToArrayedTypes(typeObjects);
        this.addElementsAndParamsToEntities(entityObjects);
        this.addElementsToUnboundActions(actionObjects);
        this.addElementsToUnboundFunctions(functionObjects);
        this.addElementsToBoundActions(entityObjects);
        this.addElementsToBoundFunctions(entityObjects);
        return this.cdsModel.build();
    }

    private void readMetaInfo(JsonNode csn) {
        if (csn.has("version")) {
            JsonNode version = CdsModelReader.asObject(csn.get("version"));
            this.cdsModel.addMeta("version", version.get("csn").asText());
        }
        if (csn.has("meta")) {
            JsonNode meta = CdsModelReader.asObject(csn.get("meta"));
            meta.fields().forEachRemaining(e -> {
                Object value;
                try {
                    value = jackson.readValue(((JsonNode)e.getValue()).toString(), TypeFactory.unknownType());
                }
                catch (IOException e1) {
                    value = ((JsonNode)e.getValue()).toString();
                }
                this.cdsModel.addMeta((String)e.getKey(), value);
            });
        }
    }

    private void readEntities(Map<String, JsonNode> entityObjects) {
        entityObjects.forEach((qualifiedName, o) -> {
            CdsEntityBuilder entity = CdsEntityReader.read(this.nameResolver.getDefinitionName((String)qualifiedName), qualifiedName, o, readDocs);
            this.cdsModel.addEntity(entity);
        });
    }

    private void readServices(Map<String, JsonNode> serviceDefs) {
        for (Map.Entry<String, JsonNode> entry : serviceDefs.entrySet()) {
            CdsServiceBuilder service = new CdsServiceBuilder(CdsAnnotationReader.read(entry.getValue()), entry.getKey());
            this.cdsModel.addService(service);
        }
    }

    private void readTypes(Map<String, JsonNode> typeObjects) {
        for (Map.Entry<String, JsonNode> entry : typeObjects.entrySet()) {
            CdsTypeBuilder<?> type = this.readTypeDefinition(entry.getKey(), entry.getValue(), typeObjects);
            this.cdsModel.addType(entry.getKey(), type);
        }
    }

    private CdsTypeBuilder<?> readTypeDefinition(String path, JsonNode csn, Map<String, JsonNode> typeDefs) {
        if (csn.has("elements")) {
            return CdsStructuredTypeReader.readWithoutElements(path, this.nameResolver.getDefinitionName(path), csn, readDocs);
        }
        if (csn.has("items")) {
            return CdsArrayedTypeReader.readWithoutType(path, this.nameResolver.getDefinitionName(path), csn);
        }
        JsonNode typeName = csn.get("type");
        if (typeName != null) {
            String type = typeName.asText();
            if (type.equals("cds.Association") || type.equals("cds.Composition")) {
                return new CdsAssociationReader(this.cdsModel, null).read(path, csn);
            }
            if (type.startsWith("cds.")) {
                return CdsSimpleTypeReader.read(path, this.nameResolver.getDefinitionName(path), csn);
            }
            if (typeDefs.containsKey(type)) {
                JsonNode jsonNode = typeDefs.get(type);
                return this.readTypeDefinition(type, jsonNode, typeDefs);
            }
        }
        throw new CdsException("Failed to read type " + path);
    }

    private void readAnnotations(Map<String, JsonNode> contextObjects) {
        contextObjects.forEach((key, value) -> this.cdsModel.addAnnotations((String)key, (Collection<CdsAnnotation<?>>)CdsAnnotationReader.read(value)));
    }

    private void addElementsToTypes(Map<String, JsonNode> typeObjects) {
        for (Map.Entry<String, JsonNode> entry : typeObjects.entrySet()) {
            CdsTypeBuilder<? extends CdsType> type;
            Optional<CdsTypeBuilder<? extends CdsType>> typeDefinition = this.cdsModel.findType(entry.getKey());
            if (!typeDefinition.isPresent() || !(type = typeDefinition.get()).isStructured()) continue;
            CdsStructuredTypeBuilder structuredType = (CdsStructuredTypeBuilder)type;
            List<CdsElementBuilder<?>> elements = CdsStructuredTypeReader.readElementList(entry.getKey(), entry.getValue(), this.cdsModel, this.structResolver);
            structuredType.addElements(elements);
        }
    }

    private void addTypesToArrayedTypes(Map<String, JsonNode> typeObjects) {
        for (Map.Entry<String, JsonNode> entry : typeObjects.entrySet()) {
            CdsTypeBuilder<? extends CdsType> type;
            Optional<CdsTypeBuilder<? extends CdsType>> typeDefinition = this.cdsModel.findType(entry.getKey());
            if (!typeDefinition.isPresent() || !(type = typeDefinition.get()).isArrayed()) continue;
            CdsArrayedTypeBuilder arrayedType = (CdsArrayedTypeBuilder)type;
            JsonNode itemsTypeJSON = entry.getValue().get("items");
            CdsTypeBuilder itemsType = CdsModelReader.findType(itemsTypeJSON, this.cdsModel).orElseGet(() -> CdsModelReader.readType("", itemsTypeJSON, this.cdsModel, this.structResolver));
            arrayedType.setItemsType(itemsType);
        }
    }

    private void readEvents(Map<String, JsonNode> eventObjects) {
        for (Map.Entry<String, JsonNode> entry : eventObjects.entrySet()) {
            CdsEventBuilder event = CdsEventReader.read(entry.getKey(), this.nameResolver.getDefinitionName(entry.getKey()), entry.getValue(), this.cdsModel, this.structResolver);
            this.cdsModel.addEvent(event);
        }
    }

    private void addElementsAndParamsToEntities(Map<String, JsonNode> entityObjects) {
        for (Map.Entry<String, JsonNode> entry : entityObjects.entrySet()) {
            this.cdsModel.findEntity(entry.getKey()).ifPresent(entity -> {
                List<CdsElementBuilder<?>> elements = CdsStructuredTypeReader.readElementList((String)entry.getKey(), (JsonNode)entry.getValue(), this.cdsModel, this.structResolver);
                entity.addElements(elements);
                List<CdsParameter> params = CdsEntityReader.CdsParameterReader.read(entity.getQualifiedName(), (JsonNode)entry.getValue(), this.cdsModel::findType);
                entity.addParams(params);
            });
        }
    }

    private void addElementsToBoundActions(Map<String, JsonNode> entityObjects) {
        Stream<CdsEntityBuilder> boundedActionEntities = this.cdsModel.concreteEntities().filter(e -> e.actions().findFirst().isPresent());
        boundedActionEntities.forEach(e -> e.actions().forEach(a -> {
            JsonNode actionNode = ((JsonNode)entityObjects.get(e.getQualifiedName())).get("actions").get(a.getQualifiedName());
            List<CdsParameterBuilder> params = CdsUnboundActionAndFunctionReader.readParameterList(a.getQualifiedName(), actionNode, this.cdsModel, this.structResolver);
            a.addParameters(params);
            a.setReturnType(CdsUnboundActionAndFunctionReader.readReturnType(actionNode, this.cdsModel, this.structResolver));
        }));
    }

    private void addElementsToBoundFunctions(Map<String, JsonNode> entityObjects) {
        Stream<CdsEntityBuilder> boundedFunctionEntities = this.cdsModel.concreteEntities().filter(e -> e.functions().findFirst().isPresent());
        boundedFunctionEntities.forEach(e -> e.functions().forEach(f -> {
            JsonNode functionNode = ((JsonNode)entityObjects.get(e.getQualifiedName())).get("actions").get(f.getQualifiedName());
            List<CdsParameterBuilder> params = CdsUnboundActionAndFunctionReader.readParameterList(f.getQualifiedName(), functionNode, this.cdsModel, this.structResolver);
            f.addParameters(params);
            f.setReturnType(CdsUnboundActionAndFunctionReader.readReturnType(functionNode, this.cdsModel, this.structResolver));
        }));
    }

    private void addElementsToUnboundActions(Map<String, JsonNode> actionObjects) {
        for (Map.Entry<String, JsonNode> entry : actionObjects.entrySet()) {
            Optional<CdsActionBuilder> actionOptional = this.cdsModel.findAction(entry.getKey());
            if (!actionOptional.isPresent()) continue;
            CdsActionBuilder action = actionOptional.get();
            List<CdsParameterBuilder> params = CdsUnboundActionAndFunctionReader.readParameterList(entry.getKey(), entry.getValue(), this.cdsModel, this.structResolver);
            action.addParameters(params);
            action.setReturnType(CdsUnboundActionAndFunctionReader.readReturnType(entry.getValue(), this.cdsModel, this.structResolver));
        }
    }

    private void addElementsToUnboundFunctions(Map<String, JsonNode> functionObjects) {
        for (Map.Entry<String, JsonNode> entry : functionObjects.entrySet()) {
            Optional<CdsFunctionBuilder> functionOptional = this.cdsModel.findFunction(entry.getKey());
            if (!functionOptional.isPresent()) continue;
            CdsFunctionBuilder function = functionOptional.get();
            List<CdsParameterBuilder> params = CdsUnboundActionAndFunctionReader.readParameterList(entry.getKey(), entry.getValue(), this.cdsModel, this.structResolver);
            function.addParameters(params);
            function.setReturnType(CdsUnboundActionAndFunctionReader.readReturnType(entry.getValue(), this.cdsModel, this.structResolver));
        }
    }

    private void readUnboundActions(Map<String, JsonNode> actionDefs) {
        for (Map.Entry<String, JsonNode> entry : actionDefs.entrySet()) {
            CdsActionBuilder action = CdsUnboundActionAndFunctionReader.readAction(entry.getKey(), this.nameResolver.getDefinitionName(entry.getKey()), entry.getValue(), readDocs);
            this.cdsModel.addAction(action);
        }
    }

    private void readUnboundFunctions(Map<String, JsonNode> functionDefs) {
        for (Map.Entry<String, JsonNode> entry : functionDefs.entrySet()) {
            CdsFunctionBuilder function = CdsUnboundActionAndFunctionReader.readFunction(entry.getKey(), this.nameResolver.getDefinitionName(entry.getKey()), entry.getValue(), readDocs);
            this.cdsModel.addFunction(function);
        }
    }

    public static CdsTypeBuilder<?> readType(String pathToElement, JsonNode csn, CdsModelBuilder model, StructuredTypeResolver structResolver) {
        if (csn.has("elements") || csn.has("payload")) {
            return CdsStructuredTypeReader.read("", csn, model, structResolver, readDocs);
        }
        if (csn.has("items")) {
            return CdsArrayedTypeReader.read(pathToElement, csn, model, structResolver);
        }
        JsonNode typeName = csn.get("type");
        if (typeName != null) {
            String type = typeName.asText();
            if (type.equals("cds.Association") || type.equals("cds.Composition")) {
                return new CdsAssociationReader(model, structResolver).read(pathToElement, csn);
            }
            if (type.startsWith("cds.")) {
                return CdsSimpleTypeReader.read(pathToElement, "", csn);
            }
            if (typeName.has("ref")) {
                ArrayNode refNode = (ArrayNode)typeName.withArray("ref");
                if (refNode.size() == 0) {
                    throw new CdsException("Empty ref object encoutered for Element " + pathToElement);
                }
                JsonNode elementCsn = structResolver.getElementNode(refNode);
                return CdsModelReader.findType(elementCsn, model).orElseGet(() -> CdsModelReader.readType(pathToElement, elementCsn, model, structResolver));
            }
        }
        return CdsSimpleTypeReader.read(pathToElement, pathToElement, csn);
    }

    public static Optional<CdsTypeBuilder<?>> findType(JsonNode csn, CdsModelBuilder model) {
        JsonNode typeName = csn.get("type");
        if (typeName != null && !typeName.has("ref")) {
            return model.findType(typeName.asText());
        }
        return Optional.empty();
    }
}

