/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotableBuilder;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CdsParameterBuilder
extends CdsAnnotableBuilder<CdsParameter> {
    private final String name;
    private final String doc;
    private final CdsTypeBuilder<?> type;
    private final Function<CdsType, Object> defaultValueProvider;

    public CdsParameterBuilder(List<CdsAnnotation<?>> annotations, String name, CdsTypeBuilder<?> type, Function<CdsType, Object> defaultValueProvider, String doc) {
        super(annotations);
        this.name = name;
        this.type = type;
        this.doc = doc;
        this.defaultValueProvider = defaultValueProvider;
    }

    public CdsParameter build() {
        CdsType cdsType = (CdsType)this.type.build();
        return new CdsParameterImpl(this.annotations, this.getName(), cdsType, this.defaultValueProvider.apply(cdsType), this.doc);
    }

    public String getName() {
        return this.name;
    }

    private static class CdsParameterImpl
    extends CdsAnnotatableImpl
    implements CdsParameter {
        private final String name;
        private final CdsType type;
        private final Object defaultValue;

        private CdsParameterImpl(Collection<CdsAnnotation<?>> annotations, String name, CdsType type, Object defaultValue, String doc) {
            super(annotations, doc);
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public CdsType getType() {
            return this.type;
        }

        public Optional<Object> getDefaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }
    }
}

