/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.impl.CdsDefinitionImpl;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class CdsSimpleTypeBuilder
extends CdsTypeBuilder<CdsSimpleType> {
    private static final CdsSimpleType UNDEFINED = new CdsSimpleTypeBuilder(Collections.emptyList(), "undefined", "undefined", null, Collections.emptyMap()).build();
    protected final CdsBaseType cdsType;
    protected final Map<String, Object> properties = new TreeMap<String, Object>();
    private CdsSimpleType impl;

    public CdsSimpleTypeBuilder(List<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsBaseType cdsType, Map<String, Object> properties) {
        super(annotations, qualifiedName, name);
        this.cdsType = cdsType;
        this.properties.putAll(properties);
    }

    public static CdsSimpleType simpleType(CdsBaseType type) {
        return new CdsSimpleTypeBuilder(Collections.emptyList(), type.cdsName(), type.cdsName(), type, Collections.emptyMap()).build();
    }

    public static CdsSimpleType undefinedType() {
        return UNDEFINED;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String toString() {
        return this.qualifiedName + " : " + this.cdsType;
    }

    @Override
    public CdsSimpleType build() {
        if (this.impl == null) {
            this.impl = new CdsSimpleTypeImpl(this.annotations, this.qualifiedName, this.getName(), this.cdsType, this.properties);
        }
        return this.impl;
    }

    @Override
    public boolean isArrayed() {
        return false;
    }

    @Override
    public boolean isStructured() {
        return false;
    }

    protected static class CdsSimpleTypeImpl
    extends CdsDefinitionImpl
    implements CdsSimpleType {
        private final CdsBaseType cdsType;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        protected CdsSimpleTypeImpl(Collection<CdsAnnotation<?>> annotations, String qualifiedName, String name, CdsBaseType cdsType, Map<String, Object> properties) {
            super(annotations, qualifiedName, name, null);
            this.cdsType = cdsType;
            this.properties.putAll(properties);
        }

        public CdsBaseType getType() {
            return this.cdsType;
        }

        public Class<?> getJavaType() {
            return this.cdsType != null ? this.cdsType.javaType() : Object.class;
        }

        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.properties.get("default"));
        }

        public <T> T get(String property) {
            return (T)this.properties.get(property);
        }

        @Override
        public String toString() {
            return this.getQualifiedName() + " : " + this.cdsType;
        }

        public boolean isSimpleType(CdsBaseType baseType) {
            return this.cdsType == baseType;
        }

        public CdsKind getKind() {
            return CdsKind.TYPE;
        }
    }
}

