/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.CdsException;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsActionBuilder;
import com.sap.cds.reflect.impl.CdsAnnotationReader;
import com.sap.cds.reflect.impl.CdsFunctionBuilder;
import com.sap.cds.reflect.impl.CdsModelBuilder;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.reflect.impl.CdsParameterBuilder;
import com.sap.cds.reflect.impl.CdsTypeBuilder;
import com.sap.cds.reflect.impl.InvalidCsnException;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.StructuredTypeResolver;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsUnboundActionAndFunctionReader {
    private static final Logger logger = LoggerFactory.getLogger(CdsUnboundActionAndFunctionReader.class);
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(CdsUnboundActionAndFunctionReader.class);
    private static boolean readDocs = false;

    private CdsUnboundActionAndFunctionReader() {
    }

    public static CdsActionBuilder readAction(String qualifiedName, String name, JsonNode csn, boolean readDocComments) {
        readDocs = readDocComments;
        return new CdsActionBuilder(CdsAnnotationReader.read(csn), qualifiedName, name, readDocComments ? CdsModelUtils.getDoc(csn) : null);
    }

    public static CdsFunctionBuilder readFunction(String qualifiedName, String name, JsonNode csn, boolean readDocComments) {
        readDocs = readDocComments;
        return new CdsFunctionBuilder(CdsAnnotationReader.read(csn), qualifiedName, name, readDocComments ? CdsModelUtils.getDoc(csn) : null);
    }

    public static List<CdsParameterBuilder> readParameterList(String name, JsonNode jsonStructuredType, CdsModelBuilder model, StructuredTypeResolver structResolver) {
        LinkedList<CdsParameterBuilder> paramList = new LinkedList<CdsParameterBuilder>();
        if (!jsonStructuredType.has("params")) {
            return paramList;
        }
        JsonNode params = jsonStructuredType.get("params");
        Iterator fields = params.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            JsonNode field = (JsonNode)next.getValue();
            String paramName = (String)next.getKey();
            try {
                CdsTypeBuilder type = CdsModelReader.findType(field, model).orElseGet(() -> CdsModelReader.readType("", field, model, structResolver));
                Function<CdsType, Object> defValProvider = t -> TokenParser.defaultValue(field.get("default"), t);
                paramList.add(new CdsParameterBuilder(CdsAnnotationReader.read(field), paramName, type, defValProvider, readDocs ? CdsModelUtils.getDoc(field) : null));
            }
            catch (InvalidCsnException e) {
                String pathToElement = name + "." + paramName;
                logger.debug(pathToElement + ": ", (Throwable)e);
                issueCollector.error(pathToElement, e.getMessage(), new Object[0]);
            }
        }
        return paramList;
    }

    public static CdsTypeBuilder<?> readReturnType(JsonNode jsonStructuredType, CdsModelBuilder model, StructuredTypeResolver structResolver) {
        if (jsonStructuredType.has("returns")) {
            JsonNode returns = jsonStructuredType.get("returns");
            return CdsModelReader.findType(returns, model).orElseGet(() -> CdsModelReader.readType("", returns, model, structResolver));
        }
        if (jsonStructuredType.get("kind").asText().equalsIgnoreCase("function")) {
            throw new CdsException("Missing return type function. Please add the return type in the CDS model.");
        }
        return null;
    }
}

