/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DraftAdapter {
    private static final String DRAFTS_SUFFIX_ENTITY = "_drafts";
    private static final String DRAFTS_SUFFIX_TABLE = "_DRAFTS";
    public static final String IS_ACTIVE_ENTITY = "IsActiveEntity";
    private static final String HAS_ACTIVE_ENTITY = "HasActiveEntity";
    private static final String HAS_DRAFT_ENTITY = "HasDraftEntity";
    private static final String SIBLING_ENTITY = "SiblingEntity";
    private static final String SIBLING_ENTITY_UNSECURED = "SiblingEntity_unsecured";
    private static final String DRAFT_ADMINISTRATIVE_DATA = "DraftAdministrativeData";
    private static final String ADMINSTRATIVE_DATA_TABLE = "DRAFT.DraftAdministrativeData";
    private static final String DRAFT_UUID = "DraftAdministrativeData_DraftUUID";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final boolean adaptDrafts;
    private final Map<String, JsonNode> entityObjects;
    private final Map<String, JsonNode> serviceObjects;
    private final Map<String, JsonNode> draftEntities = Maps.newLinkedHashMap();

    public DraftAdapter(boolean adaptDrafts, Map<String, JsonNode> entityObjects, Map<String, JsonNode> serviceObjects) {
        this.adaptDrafts = adaptDrafts;
        this.entityObjects = entityObjects;
        this.serviceObjects = serviceObjects;
    }

    public void processEntity(String name, JsonNode object) {
        if (this.adaptDrafts && DraftAdapter.isDraftEnabled(object)) {
            this.draftEntities.put(name, object);
        }
    }

    public void adaptDraftEntities() {
        if (this.adaptDrafts) {
            this.entityObjects.forEach((name, entityNode) -> {
                this.addAssociationsToDraftEntities((JsonNode)entityNode, (String)name);
                if (this.isDraftAdminDataEntity((String)name)) {
                    this.addAccessControlAnnotations((JsonNode)entityNode);
                }
            });
            for (Map.Entry<String, JsonNode> entry : this.draftEntities.entrySet()) {
                JsonNode object = entry.getValue();
                String name2 = entry.getKey();
                ObjectNode copy = (ObjectNode)object.deepCopy();
                this.changeCompositionTargets((JsonNode)copy);
                this.changeAssociations((JsonNode)copy, name2);
                if (copy.has("@cds.persistence.name")) {
                    copy.put("@cds.persistence.name", copy.get("@cds.persistence.name").asText() + DRAFTS_SUFFIX_TABLE);
                }
                copy.remove("query");
                copy.remove("projection");
                this.removeSiblingActiveEntityCondition(copy);
                this.removeActiveEntityKeyQualifier(copy);
                this.adaptDraftAdministrativeData(copy);
                this.entityObjects.put(DraftAdapter.getDraftsEntity(name2), (JsonNode)copy);
                this.removeDraftFieldsAndChangeSibling(object);
                this.removeLocalizedFromElements((JsonNode)copy);
                this.removeCascadeAnnotationsFromAssociations(copy);
            }
        }
    }

    private void removeCascadeAnnotationsFromAssociations(ObjectNode object) {
        if (object.has("elements")) {
            ObjectNode elements = (ObjectNode)object.findValue("elements");
            elements.fields().forEachRemaining(e -> {
                if (!DRAFT_ADMINISTRATIVE_DATA.equals(e.getKey()) && ((JsonNode)e.getValue()).has("type") && "cds.Association".equals(((JsonNode)e.getValue()).get("type").asText())) {
                    ((ObjectNode)e.getValue()).remove("@cascade.all");
                    ((ObjectNode)e.getValue()).remove("@cascade.update");
                    ((ObjectNode)e.getValue()).remove("@cascade.insert");
                    ((ObjectNode)e.getValue()).remove("@cascade.delete");
                }
            });
        }
    }

    private boolean isDraftAdminDataEntity(String name) {
        int draftAdminDataIndex = name.lastIndexOf(".DraftAdministrativeData");
        if (draftAdminDataIndex > 0) {
            String serviceName = name.substring(0, draftAdminDataIndex);
            return this.serviceObjects.get(serviceName) != null;
        }
        return false;
    }

    private void addAccessControlAnnotations(JsonNode entityNode) {
        if (entityNode.isObject()) {
            ObjectNode entityObject = (ObjectNode)entityNode;
            entityObject.put("@cds.autoexposed", true);
            entityObject.put("@readonly", true);
        }
    }

    private void removeLocalizedFromElements(JsonNode object) {
        if (object.has("elements")) {
            ObjectNode elements = (ObjectNode)object.findValue("elements");
            elements.forEach(e -> {
                if (e.has("localized")) {
                    ObjectNode o = (ObjectNode)e;
                    o.remove("localized");
                }
            });
        }
    }

    private static boolean isDraftEnabled(JsonNode entity) {
        return entity.has("@odata.draft.enabled") && entity.get("@odata.draft.enabled").asBoolean(false) || entity.has("@Common.DraftNode.PreparationAction");
    }

    private void addAssociationsToDraftEntities(JsonNode entity, String name) {
        if (entity.has("elements")) {
            ArrayList tmpList = new ArrayList(entity.get("elements").size());
            entity.get("elements").fields().forEachRemaining(tmpList::add);
            tmpList.forEach(e -> this.addDraftAssociation(entity, (String)e.getKey(), (JsonNode)e.getValue(), name));
        }
    }

    private void addDraftAssociation(JsonNode entity, String elementName, JsonNode element, String entityName) {
        String targetName;
        JsonNode target;
        if (this.isAssociation(element) && !SIBLING_ENTITY.equals(elementName) && !this.isDraftEnabledAssociation(entity, entityName, element, elementName) && DraftAdapter.isDraftEnabled(target = this.entityObjects.get(targetName = element.get("target").textValue()))) {
            ObjectNode copy = (ObjectNode)element.deepCopy();
            copy.put("target", DraftAdapter.getDraftsEntity(copy.get("target").textValue()));
            String draftAssociationName = DraftAdapter.getDraftsEntity(elementName);
            if (copy.has("on") && copy.get("on").isArray()) {
                this.changeOnCondition(copy, elementName, draftAssociationName);
            } else {
                copy.set("on", (JsonNode)DraftAdapter.onCondition(draftAssociationName, elementName, copy.get("keys")));
            }
            ((ObjectNode)entity.get("elements")).set(draftAssociationName, (JsonNode)copy);
        }
    }

    static ArrayNode onCondition(String draftAssociationName, String fieldName, JsonNode keys) {
        Iterator elements = keys.elements();
        ArrayNode onCondition = mapper.createArrayNode();
        int index = 0;
        while (elements.hasNext()) {
            if (index > 0) {
                onCondition.insert(index++, "and");
            }
            Iterator refSegments = ((JsonNode)elements.next()).get("ref").elements();
            List<String> segments = StreamSupport.stream(Spliterators.spliteratorUnknownSize(refSegments, 16), false).map(JsonNode::asText).collect(Collectors.toList());
            ObjectNode lhs = DraftAdapter.refNode(draftAssociationName, segments);
            ObjectNode rhs = DraftAdapter.refNode(fieldName + "_" + segments.get(segments.size() - 1));
            onCondition.insert(index++, (JsonNode)lhs);
            onCondition.insert(index++, "=");
            onCondition.insert(index++, (JsonNode)rhs);
        }
        return onCondition;
    }

    static ObjectNode refNode(String firstSeg, List<String> additionalSegs) {
        String[] segments = new String[additionalSegs.size() + 1];
        segments[0] = firstSeg;
        for (int i = 0; i < additionalSegs.size(); ++i) {
            segments[i + 1] = additionalSegs.get(i);
        }
        return DraftAdapter.refNode(segments);
    }

    static ObjectNode refNode(String ... segments) {
        ObjectNode refNode = mapper.createObjectNode();
        ArrayNode refArray = mapper.createArrayNode();
        for (int i = 0; i < segments.length; ++i) {
            refArray.insert(i, segments[i]);
        }
        refNode.set("ref", (JsonNode)refArray);
        return refNode;
    }

    private boolean isDraftEnabledAssociation(JsonNode entity, String entityName, JsonNode association, String associationName) {
        if (association.has("@odata.draft.enabled")) {
            return association.get("@odata.draft.enabled").asBoolean(false);
        }
        return this.isBacklinkAssociationInDraftDocument(association, associationName, entityName) || this.isForwardAssociationInDraftDocument(entity, association);
    }

    private boolean isForwardAssociationInDraftDocument(JsonNode entity, JsonNode element) {
        String targetName = element.get("target").textValue();
        AtomicBoolean compositionWithSameTarget = new AtomicBoolean(false);
        this.forCompositions(entity, (composition, compositionName) -> {
            String compositionTarget = composition.get("target").asText();
            compositionWithSameTarget.set(compositionTarget.equals(targetName) || compositionTarget.equals(DraftAdapter.getDraftsEntity(targetName)));
        });
        return compositionWithSameTarget.get();
    }

    private boolean isAssociation(JsonNode node) {
        return node.has("type") && "cds.Association".equals(node.get("type").textValue());
    }

    private void changeOnCondition(ObjectNode copy, String fieldName, String draftAssociationName) {
        ArrayNode onCopy = (ArrayNode)copy.get("on");
        for (int j = 0; j < onCopy.size(); ++j) {
            if (!onCopy.get(j).has("ref") || !onCopy.get(j).get("ref").isArray()) continue;
            ArrayNode refCopy = (ArrayNode)onCopy.get(j).get("ref");
            for (int i = 0; i < refCopy.size(); ++i) {
                if (!fieldName.equals(refCopy.get(i).asText())) continue;
                refCopy.remove(i);
                refCopy.insert(i, draftAssociationName);
            }
        }
    }

    private void changeCompositionTargets(JsonNode entity) {
        this.forCompositions(entity, (composition, compositionName) -> {
            String compositionTarget = composition.get("target").asText();
            if (this.draftEntities.containsKey(compositionTarget)) {
                composition.put("target", DraftAdapter.getDraftsEntity(compositionTarget));
            }
        });
    }

    private void changeAssociations(JsonNode entity, String name) {
        if (entity.has("elements")) {
            entity.get("elements").fields().forEachRemaining(entry -> {
                String targetEntityName;
                JsonNode targetEntity;
                String type;
                String elementName = (String)entry.getKey();
                JsonNode element = (JsonNode)entry.getValue();
                if (element.has("type") && "cds.Association".equals(type = element.get("type").asText()) && this.isDraftEnabledAssociation(entity, name, element, elementName) && DraftAdapter.isDraftEnabled(targetEntity = this.entityObjects.get(targetEntityName = element.get("target").asText()))) {
                    ((ObjectNode)element).put("target", DraftAdapter.getDraftsEntity(targetEntityName));
                }
            });
        }
    }

    private boolean isBacklinkAssociationInDraftDocument(JsonNode association, String associationName, String entityName) {
        String target;
        AtomicBoolean result = new AtomicBoolean(false);
        if (association.has("target") && this.draftEntities.containsKey(target = association.get("target").asText())) {
            JsonNode parent = this.draftEntities.get(target);
            this.forCompositions(parent, (composition, compositionName) -> {
                String compositionTarget = composition.get("target").asText();
                if (compositionTarget.equals(entityName) && (DraftAdapter.hasBacklinkOnCondition((JsonNode)composition, compositionName, associationName) || DraftAdapter.hasBacklinkOnCondition(association, associationName, compositionName))) {
                    result.set(true);
                }
            });
        }
        return result.get();
    }

    private static boolean hasBacklinkOnCondition(JsonNode partner, String partnerName, String assocName) {
        JsonNode onCondition = partner.get("on");
        if (onCondition != null && onCondition.size() == 3) {
            JsonNode left = onCondition.get(0).get("ref");
            JsonNode operator = onCondition.get(1);
            JsonNode right = onCondition.get(2).get("ref");
            if (left != null && left.size() == 2 && left.get(0).asText().equals(partnerName) && left.get(1).asText().equals(assocName) && operator.asText().equals("=") && right != null && right.size() == 1 && right.get(0).asText().equals("$self")) {
                return true;
            }
        }
        return false;
    }

    private static String getDraftsEntity(String entity) {
        return entity + DRAFTS_SUFFIX_ENTITY;
    }

    private void adaptDraftAdministrativeData(ObjectNode entity) {
        ObjectNode adminData = (ObjectNode)entity.findValue(DRAFT_ADMINISTRATIVE_DATA);
        if (adminData != null && adminData.has("target")) {
            adminData.put("target", ADMINSTRATIVE_DATA_TABLE);
            if (entity.has("@odata.draft.enabled") && entity.get("@odata.draft.enabled").asBoolean()) {
                adminData.put("@cascade.all", true);
            } else {
                adminData.put("@cascade.update", true);
            }
        }
    }

    private void removeActiveEntityKeyQualifier(ObjectNode entity) {
        ObjectNode activeEntity = (ObjectNode)entity.findValue(IS_ACTIVE_ENTITY);
        if (activeEntity != null) {
            activeEntity.remove("key");
        }
    }

    private void forCompositions(JsonNode entity, CompositionProcessor processor) {
        JsonNode elements = entity.get("elements");
        if (elements != null) {
            elements.fields().forEachRemaining(entry -> {
                String elementName = (String)entry.getKey();
                JsonNode element = (JsonNode)entry.getValue();
                JsonNode type = element.get("type");
                if (type != null && "cds.Composition".equals(type.asText())) {
                    processor.process((ObjectNode)element, elementName);
                }
            });
        }
    }

    private void removeSiblingActiveEntityCondition(ObjectNode entity) {
        JsonNode on;
        JsonNode sibling = entity.findValue(SIBLING_ENTITY);
        if (sibling != null && (on = sibling.findValue("on")) != null) {
            this.removeActiveEntityCondition(on);
            Iterator iter = on.elements();
            JsonNode node = null;
            while (iter.hasNext()) {
                node = (JsonNode)iter.next();
            }
            if (node != null && node.isTextual()) {
                iter.remove();
            }
        }
    }

    private void removeActiveEntityCondition(JsonNode on) {
        Iterator iter = on.elements();
        while (iter.hasNext()) {
            JsonNode ref = ((JsonNode)iter.next()).findValue("ref");
            if (ref == null || !DraftAdapter.contains(ref, IS_ACTIVE_ENTITY)) continue;
            iter.remove();
            if (!iter.hasNext()) continue;
            iter.next();
            iter.remove();
        }
    }

    private static boolean contains(JsonNode ref, String str) {
        Iterator iter = ref.elements();
        while (iter.hasNext()) {
            JsonNode current = (JsonNode)iter.next();
            if (!current.isTextual() || !str.equals(current.asText())) continue;
            return true;
        }
        return false;
    }

    private void removeDraftFieldsAndChangeSibling(JsonNode object) {
        ObjectNode elements;
        if (object.has("elements") && (elements = (ObjectNode)object.findValue("elements")).has(SIBLING_ENTITY)) {
            ObjectNode sibling = (ObjectNode)elements.get(SIBLING_ENTITY);
            if (sibling.has("target") && sibling.get("target").isTextual()) {
                String target = sibling.get("target").asText();
                sibling.put("target", DraftAdapter.getDraftsEntity(target));
                this.removeSiblingActiveEntityCondition(elements);
            }
            ObjectNode unsecuredSibling = sibling.deepCopy();
            this.addSecurityConstraint(sibling);
            this.changeReferences(unsecuredSibling);
            elements.set(SIBLING_ENTITY_UNSECURED, (JsonNode)unsecuredSibling);
        }
    }

    private void changeReferences(ObjectNode unsecuredSibling) {
        if (unsecuredSibling.findValue("on") != null && unsecuredSibling.findValue("on").isArray()) {
            ArrayNode on = (ArrayNode)unsecuredSibling.findValue("on");
            on.forEach(node -> {
                if (node.has("ref") && node.get("ref").isArray()) {
                    ArrayNode ref = (ArrayNode)node.get("ref");
                    for (int i = 0; i < ref.size(); ++i) {
                        if (!ref.get(i).isTextual() || !((TextNode)ref.get(i)).asText().equals(SIBLING_ENTITY)) continue;
                        ref.remove(i);
                        ref.insert(i, SIBLING_ENTITY_UNSECURED);
                    }
                }
            });
        }
    }

    private void addSecurityConstraint(ObjectNode sibling) {
        if (sibling.findValue("on") != null && sibling.findValue("on").isArray()) {
            ArrayNode on = (ArrayNode)sibling.findValue("on");
            on.add("and");
            ArrayNode refUuid = mapper.createArrayNode();
            refUuid.add(SIBLING_ENTITY);
            refUuid.add(DRAFT_UUID);
            on.add((JsonNode)this.createRefNode(refUuid));
            on.add("IN (SELECT DraftUUID FROM DRAFT_DraftAdministrativeData where CreatedByUser is null or");
            ArrayNode userIdRef = mapper.createArrayNode();
            userIdRef.add("$user");
            userIdRef.add("id");
            on.add((JsonNode)this.createRefNode(userIdRef));
            on.add("= CreatedByUser)");
        }
    }

    private ObjectNode createRefNode(ArrayNode ref) {
        ObjectNode node = mapper.createObjectNode();
        node.set("ref", (JsonNode)ref);
        return node;
    }

    public static boolean isDraftElement(String element) {
        return IS_ACTIVE_ENTITY.equals(element) || HAS_ACTIVE_ENTITY.equals(element) || HAS_DRAFT_ENTITY.equals(element);
    }

    @FunctionalInterface
    private static interface CompositionProcessor {
        public void process(ObjectNode var1, String var2);
    }
}

