/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect.impl.reader.issuecollector;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cds.reflect.impl.reader.issuecollector.Issue;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class IssueCollectorFactory {
    private static final Map<String, IssueCollector> collectors = Maps.newHashMap();
    private static final Set<Issue> issues = Sets.newLinkedHashSet();
    private static boolean logUnrecognized = false;

    private IssueCollectorFactory() {
    }

    public static IssueCollector getIssueCollector(Class<?> clazz) {
        String className = clazz.getName();
        IssueCollector collector = collectors.get(className);
        if (collector == null) {
            collector = new IssueCollectorImpl(className);
            collectors.put(clazz.getName(), collector);
        }
        return collector;
    }

    public static Collection<Issue> getIssues() {
        return Collections.unmodifiableCollection(issues);
    }

    public static Stream<Issue> filterIssues(IssueType type) {
        return issues.stream().filter(i -> type == i.getType());
    }

    public static boolean hasIssues(IssueType type) {
        return IssueCollectorFactory.filterIssues(type).findAny().isPresent();
    }

    public static void clearIssues() {
        issues.clear();
    }

    public static void enableUnrecognizedLogging() {
        logUnrecognized = true;
    }

    public static void disableUnrecognizedLogging() {
        logUnrecognized = false;
    }

    private static class IssueCollectorImpl
    implements IssueCollector {
        private final String reporter;

        IssueCollectorImpl(String reporter) {
            this.reporter = reporter;
        }

        @Override
        public void critical(String path, String format, Object ... args) {
            this.addIssue(IssueType.CRITICAL, path, format, args);
        }

        @Override
        public void error(String path, String format, Object ... args) {
            this.addIssue(IssueType.ERROR, path, format, args);
        }

        @Override
        public void unrecognized(String path, String format, Object ... args) {
            if (logUnrecognized) {
                this.addIssue(IssueType.UNRECOGNIZED, path, format, args);
            }
        }

        @Override
        public void unsupported(String path, String format, Object ... args) {
            this.addIssue(IssueType.UNSUPPORTED, path, format, args);
        }

        private void addIssue(IssueType type, String path, String format, Object ... args) {
            String msg = String.format(Strings.nullToEmpty((String)format), args);
            issues.add(Issue.create(type, path, msg, this.reporter));
        }

        @Override
        public void warning(String path, String format, Object ... args) {
            this.addIssue(IssueType.WARNING, path, format, args);
        }
    }
}

