/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.parser.VersionParser;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsVersion;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CdsModelUtils {
    private static final String UNDERSCORE = "_";
    private static final CdsVersion DEFAULT_COMPILER_VERSION = new CdsVersion(1, 0, 0, 0);

    private CdsModelUtils() {
    }

    public static boolean isSingleValued(CdsType associationElement) {
        return ((CdsAssociationType)associationElement.as(CdsAssociationType.class)).getCardinality().getTargetMax().equals("1");
    }

    public static boolean isToMany(CdsType associationElement) {
        return ((CdsAssociationType)associationElement.as(CdsAssociationType.class)).getCardinality().getTargetMax().equals("*");
    }

    public static boolean isManyTo(CdsType associationElement) {
        return !((CdsAssociationType)associationElement.as(CdsAssociationType.class)).getCardinality().getSourceMax().equals("1");
    }

    public static boolean managedToOne(CdsType associationElement) {
        if (associationElement.isAssociation()) {
            CdsAssociationType assoc = (CdsAssociationType)associationElement.as(CdsAssociationType.class);
            return CdsModelUtils.isSingleValued((CdsType)assoc) && !assoc.onCondition().isPresent();
        }
        return false;
    }

    public static Set<String> targetKeys(CdsElement assoc) {
        return CdsModelUtils.keyNames((CdsStructuredType)CdsModelUtils.assocType(assoc).getTarget());
    }

    public static Set<String> assocKeys(CdsElement forwardMappedAssoc) {
        Set<String> assocKeys = AssociationAnalyzer.refElements(forwardMappedAssoc).map(CdsElement::getName).collect(Collectors.toSet());
        if (assocKeys.isEmpty()) {
            assocKeys = new OnConditionAnalyzer(forwardMappedAssoc, false).getFkMapping().values().stream().flatMap(CqnValue::ofRef).map(CqnReference::lastSegment).collect(Collectors.toSet());
        }
        return assocKeys;
    }

    public static Set<String> keyNames(CdsStructuredType type) {
        return CdsModelUtils.resolveKeys(type).collect(Collectors.toSet());
    }

    private static Stream<String> resolveKeys(CdsStructuredType entity) {
        return entity.keyElements().filter(k -> !k.isVirtual()).flatMap(CdsModelUtils::resolveKeys);
    }

    private static Stream<String> resolveKeys(CdsElement element) {
        if (element.getType().isAssociation()) {
            return AssociationAnalyzer.refElements(element).flatMap(CdsModelUtils::resolveKeys).map(k -> element.getName() + UNDERSCORE + k);
        }
        return Stream.of(element.getName());
    }

    private static CdsAssociationType assocType(CdsElement element) {
        return (CdsAssociationType)element.getType().as(CdsAssociationType.class);
    }

    public static Optional<CdsElement> findElement(CdsStructuredType struct, CqnElementRef ref) {
        String path = CdsModelUtils.relativePath(struct, ref.segments());
        return struct.findElement(path);
    }

    public static CdsElement element(CdsStructuredType struct, CqnElementRef ref) {
        return CdsModelUtils.element(struct, ref.segments());
    }

    public static CdsElement element(CdsStructuredType struct, List<? extends CqnReference.Segment> segments) {
        String path = CdsModelUtils.relativePath(struct, segments);
        return struct.getElement(path);
    }

    private static String relativePath(CdsStructuredType struct, List<? extends CqnReference.Segment> segments) {
        int skip = segments.get(0).id().equals(struct.getQualifiedName()) ? 1 : 0;
        return segments.stream().skip(skip).map(CqnReference.Segment::id).filter(id -> !id.equals("$self")).collect(Collectors.joining("."));
    }

    public static boolean isContextElementRef(CqnElementRef ref) {
        switch (ref.firstSegment()) {
            case "$now": 
            case "$at": 
            case "$user": {
                return true;
            }
        }
        return false;
    }

    public static List<CdsEntity> entities(CdsModel model, List<? extends CqnReference.Segment> segments) {
        ArrayList<CdsEntity> entities = new ArrayList<CdsEntity>(segments.size());
        Iterator<? extends CqnReference.Segment> iter = segments.iterator();
        if (iter.hasNext()) {
            CdsEntity e = model.getEntity(iter.next().id());
            entities.add(e);
            while (iter.hasNext()) {
                e = (CdsEntity)e.getTargetOf(iter.next().id());
                entities.add(e);
            }
        }
        return entities;
    }

    public static List<CdsEntity> entities(CdsEntity root, List<? extends CqnReference.Segment> segments) {
        LinkedList<CdsEntity> entities = new LinkedList<CdsEntity>();
        entities.add(root);
        boolean firstSegment = true;
        for (CqnReference.Segment segment : segments) {
            if (firstSegment && root.getQualifiedName().equals(segment.id())) continue;
            entities.add((CdsEntity)entities.getLast().getTargetOf(segment.id()));
            firstSegment = false;
        }
        return entities;
    }

    public static CdsEntity entity(CdsEntity root, List<? extends CqnReference.Segment> segments) {
        return (CdsEntity)((LinkedList)CdsModelUtils.entities(root, segments)).getLast();
    }

    public static CdsStructuredType target(CdsStructuredType root, List<? extends CqnReference.Segment> segments) {
        CdsStructuredType target = root;
        for (CqnReference.Segment segment : segments) {
            target = target.getTargetOf(segment.id());
        }
        return target;
    }

    public static CdsEntity entity(CdsModel model, List<? extends CqnReference.Segment> segments) {
        CdsEntity entity = model.getEntity(segments.get(0).id());
        return CdsModelUtils.entity(entity, segments);
    }

    public static CdsEntity entity(CdsModel model, CqnStructuredTypeRef ref) {
        CdsEntity entity = model.getEntity(ref.firstSegment());
        return CdsModelUtils.entity(entity, (List<? extends CqnReference.Segment>)ref.segments());
    }

    public static boolean isReverseAssociation(CdsElement assoc) {
        CdsAssociationType association = (CdsAssociationType)assoc.getType();
        if (association.getCardinality().getTargetMax().equalsIgnoreCase("*")) {
            return true;
        }
        return CdsModelUtils.referencesAllKeysOfSource(assoc);
    }

    public static CdsVersion compilerVersion(CdsModel model) {
        String creator = (String)model.getMeta("creator");
        if (creator == null) {
            return DEFAULT_COMPILER_VERSION;
        }
        try {
            return VersionParser.parse(creator.substring("CDS Compiler v".length()));
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_COMPILER_VERSION;
        }
    }

    private static boolean referencesAllKeysOfSource(CdsElement assoc) {
        CdsAssociationType association = (CdsAssociationType)assoc.getType();
        Optional onCond = association.onCondition();
        if (!onCond.isPresent()) {
            return false;
        }
        final Set<String> sourceKeys = CdsModelUtils.keyNames((CdsStructuredType)assoc.getDeclaringType());
        sourceKeys.remove("IsActiveEntity");
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnElementRef ref) {
                if (ref.lastSegment().equals("$self")) {
                    sourceKeys.clear();
                } else if (ref.segments().size() == 1) {
                    sourceKeys.remove(ref.lastSegment());
                }
            }
        };
        ((CqnPredicate)onCond.get()).accept(visitor);
        return sourceKeys.isEmpty();
    }

    public static String getDoc(JsonNode csn) {
        if (csn.has("doc")) {
            return csn.get("doc").asText();
        }
        return null;
    }

    public static boolean isCascading(CascadeType cascadeType, CdsElement association) {
        CdsType type = association.getType();
        if (type.isAssociation()) {
            Optional cascade = association.findAnnotation("cascade." + (Object)((Object)cascadeType));
            if (!cascade.isPresent()) {
                cascade = association.findAnnotation("cascade.all");
            }
            return cascade.map(CdsAnnotation::getValue).orElseGet(() -> ((CdsAssociationType)type.as(CdsAssociationType.class)).isComposition());
        }
        return false;
    }

    public static String getFullRefPath(CqnSelectListValue val) {
        if (val.isRef()) {
            return val.asRef().segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
        }
        return val.displayName();
    }

    public static Stream<Map<CdsElement, List<String>>> resolveManagedToOneAssociationMapping(CdsElement element) {
        ArrayDeque<CdsElementRefSegHolder> stack = new ArrayDeque<CdsElementRefSegHolder>();
        stack.push(new CdsElementRefSegHolder(element, new ArrayList<String>()));
        Stream<Map<CdsElement, List<String>>> stream = Stream.empty();
        while (!stack.isEmpty()) {
            CdsElementRefSegHolder holder = (CdsElementRefSegHolder)stack.pop();
            CdsElement current = holder.getElement();
            List<String> currentPath = holder.getPath();
            if (CdsModelUtils.managedToOne(current.getType())) {
                Stream s;
                currentPath.add(current.getName());
                List refElements = AssociationAnalyzer.refElements(current).collect(Collectors.toList());
                if (refElements.isEmpty()) {
                    CdsAssociationType assocType = CdsModelUtils.assocType(current);
                    s = assocType.getTarget().keyElements();
                } else {
                    s = refElements.stream();
                }
                s.filter(key -> !key.isVirtual()).forEach(key -> stack.push(new CdsElementRefSegHolder((CdsElement)key, (List<String>)new ArrayList<String>(currentPath))));
                continue;
            }
            if (!current.getType().isSimple()) continue;
            currentPath.add(current.getName());
            HashMap<CdsElement, ArrayList<String>> m = new HashMap<CdsElement, ArrayList<String>>();
            m.put(current, new ArrayList<String>(currentPath));
            stream = Stream.concat(Stream.of(m), stream);
        }
        return stream;
    }

    private static class CdsElementRefSegHolder {
        private final CdsElement element;
        private final List<String> path;

        public CdsElementRefSegHolder(CdsElement element, List<String> path) {
            this.element = element;
            this.path = path;
        }

        public CdsElement getElement() {
            return this.element;
        }

        public List<String> getPath() {
            return this.path;
        }
    }

    public static enum CascadeType {
        ALL,
        INSERT,
        UPDATE,
        DELETE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

