/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.google.common.collect.Streams;
import com.sap.cds.CdsException;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Connective;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.builder.model.Negation;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CdsSearchUtils {
    private static final String DEFAULT_SEARCH_ELEMENT = "Search.defaultSearchElement";
    private static final String CDS_SEARCH = "cds.search";
    @Deprecated
    private static final String SEARCH_CASCADE = "Search.cascade";
    private static final boolean INCLUDE = true;
    private static final boolean EXCLUDE = false;
    private final CdsStructuredType targetType;

    private CdsSearchUtils(CdsStructuredType targetType) {
        this.targetType = targetType;
    }

    public static Collection<CqnElementRef> searchableElementRefs(CdsStructuredType targetType) {
        Set<List<String>> segments = CdsSearchUtils.searchableSegments(targetType);
        return segments.stream().map(CdsSearchUtils::ref).collect(Collectors.toList());
    }

    private static Set<List<String>> searchableSegments(CdsStructuredType targetType) {
        CdsSearchUtils utils = new CdsSearchUtils(targetType);
        return utils.searchableRefs();
    }

    private Set<List<String>> searchableRefs() {
        HashSet<List<String>> refs = new HashSet<List<String>>();
        this.handleNonAssocElements(true, refs::add);
        if (refs.isEmpty()) {
            this.defaultSearchElements().map(CdsSearchUtils::segments).forEach(refs::add);
        }
        this.handleAssociations(refs);
        this.handleNonAssocElements(false, refs::remove);
        return refs;
    }

    private void handleNonAssocElements(boolean include, Consumer<List<String>> action) {
        Stream<List<String>> cdsSearch = this.pathsDeclaredByCdsSearch(include);
        Stream<List> defaultSearch = this.elements().filter(CdsSearchUtils.annotatedWith(DEFAULT_SEARCH_ELEMENT, include)).map(CdsSearchUtils::segments);
        Streams.concat((Stream[])new Stream[]{cdsSearch, defaultSearch}).filter(s -> !this.isAssoc((List<String>)s)).forEach(action);
    }

    private void handleAssociations(Set<List<String>> refs) {
        Stream<List<String>> cdsSearch = this.pathsDeclaredByCdsSearch(true);
        Stream<List> searchCascade = this.elements().filter(CdsSearchUtils.searchCascade(true)).map(CdsSearchUtils::segments);
        Streams.concat((Stream[])new Stream[]{cdsSearch, searchCascade}).filter(this::isAssoc).forEach(this.addSearchableRefsTo(refs));
    }

    private Consumer<List<String>> addSearchableRefsTo(Set<List<String>> refs) {
        return prefix -> {
            CdsEntity target = ((CdsAssociationType)this.type((List<String>)prefix).as(CdsAssociationType.class)).getTarget();
            CdsSearchUtils.searchableSegments((CdsStructuredType)target).forEach(path -> {
                ArrayList ref = new ArrayList(prefix);
                ref.addAll(path);
                refs.add(ref);
            });
        };
    }

    private Stream<List<String>> pathsDeclaredByCdsSearch(boolean include) {
        return this.targetType.annotations().filter(CdsSearchUtils.cdsSearch(include)).map(CdsSearchUtils::segments);
    }

    private static Predicate<? super CdsAnnotation<?>> cdsSearch(boolean include) {
        return a -> a.getName().startsWith(CDS_SEARCH) && a.getValue().equals(include);
    }

    private static String path(CdsAnnotation<?> a) {
        String name = a.getName();
        return name.substring(CDS_SEARCH.length() + 1, name.length());
    }

    private static List<String> segments(CdsAnnotation<?> a) {
        return CdsSearchUtils.segments(CdsSearchUtils.path(a));
    }

    private Stream<CdsElement> elements() {
        return this.targetType.concreteElements();
    }

    private Stream<CdsElement> defaultSearchElements() {
        return this.elements().filter(e -> e.getType().isSimpleType(CdsBaseType.STRING));
    }

    private CdsElement element(List<String> segments) {
        CdsElement element;
        Iterator<String> iter = segments.iterator();
        CdsStructuredType current = this.targetType;
        do {
            String seg;
            boolean isAssoc;
            if (isAssoc = (element = current.getElement(seg = iter.next())).getType().isAssociation()) {
                current = current.getTargetOf(seg);
                continue;
            }
            if (!iter.hasNext()) continue;
            throw new CdsException("Invalid path: " + segments);
        } while (iter.hasNext());
        return element;
    }

    private CdsType type(List<String> segments) {
        return this.element(segments).getType();
    }

    private boolean isAssoc(List<String> s) {
        return CdsSearchUtils.isAssoc(this.element(s));
    }

    private static boolean isAssoc(CdsElement e) {
        return e.getType().isAssociation();
    }

    @Deprecated
    private static Predicate<? super CdsElement> searchCascade(boolean include) {
        return CdsSearchUtils.annotatedWith(SEARCH_CASCADE, include);
    }

    private static Predicate<? super CdsAnnotatable> annotatedWith(String annotationName, boolean include) {
        return t -> t.findAnnotation(annotationName).filter(a -> a.getValue().equals(include)).isPresent();
    }

    private static CqnElementRef ref(List<String> segments) {
        ArrayList<RefSegment> ids = new ArrayList<RefSegment>();
        for (String id : segments) {
            ids.add(RefSegmentImpl.refSegment(id));
        }
        return ElementRefImpl.element(ids);
    }

    private static List<String> segments(CdsElement e) {
        return Collections.singletonList(e.getName());
    }

    private static List<String> segments(String path) {
        return Arrays.asList(path.split("\\."));
    }

    public static Collection<CqnElementRef> getSearchableElements(CqnSelect select, CdsStructuredType targetType) {
        Collection<String> searchableElements = ((SelectBuilder)select).searchableElements();
        if (!searchableElements.isEmpty()) {
            return searchableElements.stream().map(ElementRefImpl::parse).collect(Collectors.toList());
        }
        return CdsSearchUtils.searchableElementRefs(targetType);
    }

    public static CqnPredicate searchToLikeExpression(final Collection<CqnElementRef> elements, CqnPredicate expression) {
        if (elements.isEmpty()) {
            return CqnBoolLiteral.FALSE;
        }
        final Stack stack = new Stack();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchPredicate search) {
                stack.push(this.anyElementContains(search.searchTerm()));
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                stack.push(Connective.create(connective.operator(), stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push(Negation.not((CqnPredicate)stack.pop()));
            }

            private CqnPredicate anyElementContains(String searchTerm) {
                return elements.stream().map(e -> CdsSearchUtils.containsCaseInsensitive(e, searchTerm)).collect(Disjunction.or());
            }
        };
        expression.accept(visitor);
        return (CqnPredicate)stack.pop();
    }

    private static CqnPredicate containsCaseInsensitive(CqnElementRef element, String searchTerm) {
        return CQL.and((CqnPredicate)CQL.comparison((CqnValue)element, (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.IS_NOT, (CqnValue)CqnNull.NULL), (CqnPredicate)CQL.contains((CqnValue)element, LiteralImpl.val(searchTerm), (boolean)true));
    }

    public static void moveSearchToWhere(CqnSelect select, CqnPredicate filter) {
        SelectBuilder selectBuilder = (SelectBuilder)select;
        selectBuilder.where(select.where().map(w -> Conjunction.and(w, filter)).orElse(filter));
        selectBuilder.search((CqnPredicate)null);
    }
}

