/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.impl.builder.model.ComparisonPredicate;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.ExpressionImpl;
import com.sap.cds.impl.builder.model.LiteralImpl;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.ql.impl.UpdateBuilder;
import com.sap.cds.ql.impl.XsertBuilder;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.reflect.impl.CdsArrayedTypeBuilder;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import com.sap.cds.reflect.impl.CdsStructuredTypeBuilder;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CqnStatementUtils {
    public static final String $JSON = "$json";
    private static final CqnValue ANONYM_MARKER = CQL.constant((Object)"?");
    private static final List<CqnSelectListItem> $JSON_LIST = Collections.singletonList(CQL.get((String)"$json").withoutAlias());

    private CqnStatementUtils() {
    }

    public static boolean containsExpand(CqnSelect select) {
        return select.items().stream().anyMatch(i -> i instanceof Expand);
    }

    public static Stream<CqnSelectListValue> selectedRefs(CqnSelect select) {
        return select.items().stream().filter(CqnSelectListItem::isRef).map(CqnSelectListItem::asValue);
    }

    public static void selectHidden(Collection<String> elements, CqnSelect select) {
        SelectBuilder query = (SelectBuilder)select;
        elements.forEach(k -> {
            String alias = "@" + k;
            query.addItem((Selectable)CQL.get((String)k).as(alias));
            query.addExclude(alias);
        });
    }

    public static boolean containsRef(List<CqnSelectListItem> items) {
        return items.parallelStream().anyMatch(i -> {
            if (i.isRef()) {
                return true;
            }
            if (i.isSelectList()) {
                List slItems = i.asSelectList().items();
                return CqnStatementUtils.containsSelectStar(slItems) || CqnStatementUtils.containsRef(slItems);
            }
            return false;
        });
    }

    public static CqnPredicate extractTargetFilter(CdsStructuredType rowType, CqnUpdate update, boolean useParameters) {
        ArrayList predicates = new ArrayList();
        update.where().ifPresent(predicates::add);
        Set<String> keys = CdsModelUtils.keyNames(rowType);
        update.elements().filter(keys::contains).map(key -> CQL.get((String)key).eq(useParameters ? CQL.param((String)key) : update.data().get(key))).forEach(predicates::add);
        update.entries().forEach(data -> keys.forEach(data::remove));
        return ExpressionImpl.join(predicates);
    }

    public static <S extends CqnStatement> S resolveKeyPlaceholder(final CdsStructuredType rowType, S statement) {
        return (S)CQL.copy(statement, (Modifier)new Modifier(){

            public Value<?> ref(ElementRef<?> ref) {
                if (this.isKeyPlaceholder((CqnElementRef)ref)) {
                    boolean singleKey;
                    boolean bl = singleKey = rowType.keyElements().count() == 1L;
                    if (!singleKey) {
                        throw new CqnValidationException("The entity " + rowType + " must have a single key to be filtered with 'byId'");
                    }
                    CdsElement key = (CdsElement)rowType.keyElements().findFirst().get();
                    String keyName = key.getName();
                    ref.rootSegment().id(keyName);
                }
                return ref;
            }

            private boolean isKeyPlaceholder(CqnElementRef ref) {
                return ref.segments().size() == 1 && "$key".equals(ref.firstSegment());
            }
        });
    }

    public static void moveKeyValuesToWhere(CdsStructuredType rowType, CqnUpdate update, boolean useParameters) {
        CqnPredicate filter = CqnStatementUtils.extractTargetFilter(rowType, update, useParameters);
        ((Update)update).where(filter);
    }

    public static CqnSelect countAllQuery(CqnUpdate update) {
        Select<?> select = CqnStatementUtils.countAll((CqnStatement)update);
        update.where().ifPresent(arg_0 -> select.where(arg_0));
        return select;
    }

    public static CqnSelect inlineCountQuery(CqnSelect select) {
        CqnStructuredTypeRef ref = select.ref();
        Select inner = Select.from((CqnStructuredTypeRef)ref);
        if (select.isDistinct()) {
            inner.columns(select.items());
            inner.distinct();
        } else {
            inner.columns(new Selectable[]{CQL.plain((String)"1").as("one")});
        }
        select.where().ifPresent(arg_0 -> ((Select)inner).where(arg_0));
        select.search().ifPresent(arg_0 -> ((Select)inner).search(arg_0));
        inner.groupBy(select.groupBy());
        select.having().ifPresent(arg_0 -> ((Select)inner).having(arg_0));
        return Select.from((CqnSelect)inner).columns(new Selectable[]{Count.ALL});
    }

    public static Select<?> countAll(CqnStatement statement) {
        CqnStructuredTypeRef ref = statement.ref();
        Select select = Select.from((CqnStructuredTypeRef)ref);
        select.columns(new Selectable[]{Count.ALL});
        return select;
    }

    public static Predicate simplifyPredicate(CqnPredicate pred) {
        return ExpressionVisitor.copy(pred, (Modifier)new Simplifier(){});
    }

    public static List<CqnSelectListItem> resolveStar(List<CqnSelectListItem> items, Collection<String> excluding, CdsStructuredType rowType, boolean includeAssocs) {
        if (CqnStatementUtils.containsSelectStar(items)) {
            if (CqnStatementUtils.has$jsonElement(rowType)) {
                return $JSON_LIST;
            }
            List<CqnSelectListItem> resolved = CqnStatementUtils.elementsOf(rowType, includeAssocs).map(CqnStatementUtils::elementRef).filter(n -> !excluding.contains(n.displayName())).collect(Collectors.toList());
            items.stream().filter(sli -> !sli.isStar()).forEach(resolved::add);
            return resolved;
        }
        return items;
    }

    static CqnSelectListValue elementRef(List<String> ids) {
        String alias = ids.stream().collect(Collectors.joining("."));
        List segments = ids.stream().map(RefSegmentImpl::refSegment).collect(Collectors.toList());
        return SelectListValueBuilder.select((CqnElementRef)ElementRefImpl.element(segments).as(alias));
    }

    static Stream<List<String>> elementsOf(CdsStructuredType rowType, boolean includeAssocs) {
        return rowType.elements().filter(e -> !e.isVirtual() && (!e.getType().isAssociation() || includeAssocs && CdsModelUtils.managedToOne(e.getType()))).flatMap(e -> CqnStatementUtils.structureOf(e, includeAssocs));
    }

    static Stream<List<String>> structureOf(CdsElement e, boolean includeAssocs) {
        CdsType type = e.getType();
        String name = e.getName();
        if (type.isStructured()) {
            CdsStructuredType struct = (CdsStructuredType)type.as(CdsStructuredType.class);
            return CqnStatementUtils.elementsOf(struct, includeAssocs).map(ids -> CqnStatementUtils.prefix(name, ids));
        }
        return Stream.of(Arrays.asList(name));
    }

    private static List<String> prefix(String prefix, List<String> suffix) {
        ArrayList<String> list = new ArrayList<String>(1 + suffix.size());
        list.add(prefix);
        list.addAll(suffix);
        return list;
    }

    private static boolean has$jsonElement(CdsStructuredType rowType) {
        return rowType.findElement($JSON).isPresent();
    }

    public static CqnSelect resolveStar(CqnSelect select, CdsStructuredType rowType) {
        return CqnStatementUtils.resolveStar(select, rowType, false);
    }

    public static CqnSelect resolveStar(CqnSelect select, CdsStructuredType rowType, boolean includeAssocs) {
        List<CqnSelectListItem> resolved;
        List items = select.items();
        if (items != (resolved = CqnStatementUtils.resolveStar(items, select.excluding(), rowType, includeAssocs))) {
            return SelectBuilder.copy(select).columns(resolved);
        }
        return select;
    }

    public static boolean isSelectStar(List<CqnSelectListItem> columns) {
        if (columns == null || columns.isEmpty()) {
            return true;
        }
        return columns.size() == 1 && columns.get(0).isStar();
    }

    public static CdsStructuredType targetType(CdsModel model, CqnSelect select) {
        return CqnStatementUtils.rowType(model, select.from());
    }

    public static CdsStructuredType rowType(CdsModel model, CqnSource source) {
        if (source.isSelect()) {
            return CqnStatementUtils.rowType(model, source.asSelect());
        }
        CqnStructuredTypeRef ref = source.asRef();
        return CdsModelUtils.entity(model, ref);
    }

    public static CdsStructuredType rowType(CdsModel model, CqnSelect query) {
        CdsStructuredType targetType;
        CqnSource source = query.from();
        if (source.isRef()) {
            if (CqnStatementUtils.isSelectStar(query.items()) && query.excluding().isEmpty()) {
                return CdsModelUtils.entity(model, source.asRef());
            }
            targetType = CdsModelUtils.entity(model, source.asRef());
        } else if (source.isSelect()) {
            targetType = CqnStatementUtils.rowType(model, source.asSelect());
        } else {
            throw new UnsupportedOperationException("Joins are not supported");
        }
        return CqnStatementUtils.rowType(targetType, query.items(), query.excluding()).build();
    }

    private static CdsStructuredTypeBuilder<?> rowType(CdsStructuredType targetType, List<CqnSelectListItem> items, Collection<String> excluding) {
        CdsStructuredTypeBuilder structBuilder = new CdsStructuredTypeBuilder(Collections.emptyList(), "", "", CdsKind.ENTITY, null);
        items.stream().filter(i -> !i.isValue() || !excluding.contains(i.asValue().displayName())).forEach(i -> CqnStatementUtils.addElements(structBuilder, targetType, i));
        return structBuilder;
    }

    private static void addElements(CdsStructuredTypeBuilder<?> structBuilder, CdsStructuredType type, CqnSelectListItem sli) {
        if (sli.isStar()) {
            type.concreteNonAssociationElements().map(CdsElementBuilder::copy).forEach(eb -> structBuilder.addElement((CdsElementBuilder<?>)eb));
            type.associations().filter(a -> !CdsModelUtils.isReverseAssociation(a)).map(CdsElementBuilder::copy).forEach(eb -> structBuilder.addElement((CdsElementBuilder<?>)eb));
        } else if (sli.isValue()) {
            CqnSelectListValue slv = sli.asValue();
            String displayName = slv.displayName();
            CqnStatementUtils.addElement(structBuilder, type, slv, displayName);
        } else if (sli.isSelectList()) {
            CqnStatementUtils.addSelectListElements(structBuilder, type, sli.asSelectList());
        } else {
            throw new UnsupportedOperationException("Unsupported item type " + sli);
        }
    }

    private static void addElement(CdsStructuredTypeBuilder<?> structBuilder, CdsStructuredType root, CqnSelectListValue slv, String displayName) {
        CdsElementBuilder<Object> builder;
        CqnValue val = slv.value();
        if (val.isRef()) {
            CdsElement element = CdsModelUtils.element(root, val.asRef());
            builder = CdsElementBuilder.copy(element);
        } else {
            CdsSimpleType type = val.type().map(t -> CdsSimpleTypeBuilder.simpleType(CdsBaseType.cdsType((String)t))).orElse(CdsSimpleTypeBuilder.undefinedType());
            builder = CdsElementBuilder.element(displayName).type(type);
        }
        Optional alias = slv.alias();
        alias.ifPresent(a -> builder.annotation(CdsAnnotatableImpl.CdsAnnotationImpl.annotation("@cds.persistence.name", a)));
        CqnStatementUtils.addElement(structBuilder, builder, displayName);
    }

    private static void addElement(CdsStructuredTypeBuilder<?> outer, CdsElementBuilder<?> element, String displayName) {
        int i = displayName.indexOf(46);
        if (i == -1) {
            element.name(displayName);
            outer.addElement(element);
        } else {
            String prefix = displayName.substring(0, i);
            CdsElementBuilder<?> structuredElement = outer.putStructuredElementIfAbsent(prefix, CqnStatementUtils::structuredElement);
            String suffix = displayName.substring(i + 1);
            CdsStructuredTypeBuilder inner = (CdsStructuredTypeBuilder)structuredElement.getTypeBuilder();
            CqnStatementUtils.addElement(inner, element, suffix);
        }
    }

    private static CdsElementBuilder<?> structuredElement(String name) {
        return new CdsElementBuilder(Collections.emptyList(), name, new CdsStructuredTypeBuilder(Collections.emptyList(), "", "", CdsKind.TYPE, null), false, false, false, false, null, null);
    }

    private static void addSelectListElements(CdsStructuredTypeBuilder<?> structBuilder, CdsStructuredType root, CqnSelectList selectList) {
        List refSegments = selectList.ref().segments();
        if (((CqnReference.Segment)refSegments.get(0)).id().equals("*")) {
            return;
        }
        CdsStructuredType target = CdsModelUtils.target(root, refSegments);
        if (selectList.isInline()) {
            selectList.items().stream().forEach(i -> CqnStatementUtils.addElements(structBuilder, target, i));
        } else if (selectList.isExpand()) {
            CdsStructuredTypeBuilder<?> typeBuilder = CqnStatementUtils.rowType(target, selectList.items(), Collections.emptyList());
            Object type = CqnStatementUtils.isToOnePath(root, refSegments) ? typeBuilder.build() : CdsArrayedTypeBuilder.arrayedType(typeBuilder);
            CdsElementBuilder eb = CdsElementBuilder.element(selectList.displayName()).type(type);
            structBuilder.addElement(eb);
        } else {
            throw new UnsupportedOperationException("Unsupported select list type: " + selectList);
        }
    }

    private static boolean containsSelectStar(List<CqnSelectListItem> items) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        return items.stream().anyMatch(CqnSelectListItem::isStar);
    }

    private static List<CqnSelectListItem> resolveVirtualElements(List<CqnSelectListItem> items, CdsStructuredType target) {
        boolean changed = false;
        ArrayList<CqnSelectListItem> slis = new ArrayList<CqnSelectListItem>(items.size());
        for (CqnSelectListItem sli : items) {
            CqnSelectListValue slv;
            CdsElement element;
            if (sli.isRef() && (element = CdsModelUtils.element(target, (slv = sli.asValue()).value().asRef())).isVirtual() && element.getType().isSimple()) {
                changed = true;
                Optional defaultValue = element.defaultValue();
                if (!defaultValue.isPresent()) continue;
                sli = LiteralImpl.val(defaultValue.get()).as(slv.displayName());
            }
            slis.add(sli);
        }
        return changed ? slis : items;
    }

    public static CqnSelect resolveVirtualElements(CqnSelect select, CdsStructuredType root) {
        List<CqnSelectListItem> slis;
        List items = select.items();
        return items == (slis = CqnStatementUtils.resolveVirtualElements(items, root)) ? select : Select.copy((CqnSelect)select).columns(slis);
    }

    public static CqnSelect unfoldInline(CqnSelect select, CdsStructuredType root) {
        AllElementsResolver resolver = new AllElementsResolver(root);
        Stream unfolded = select.items().stream().flatMap(c -> c.unfold(x$0 -> resolver.mapPrefixToAllElements(x$0)));
        return SelectBuilder.copy(select).columns(unfolded);
    }

    public static CqnSelect simplify(final CdsStructuredType rowType, CqnSelect select) {
        if (select.where().isPresent()) {
            return (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new Simplifier(){

                public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
                    if (op == CqnComparisonPredicate.Operator.IS && (rhs == CqnNull.NULL && !this.canBeNull((CqnValue)lhs) || lhs == CqnNull.NULL && !this.canBeNull((CqnValue)rhs))) {
                        return CqnBoolLiteral.FALSE;
                    }
                    return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, rhs);
                }

                private boolean canBeNull(CqnValue val) {
                    if (val.isLiteral()) {
                        return false;
                    }
                    if (!val.isRef()) {
                        return true;
                    }
                    CqnElementRef ref = val.asRef();
                    if (ref.segments().size() > 1) {
                        return true;
                    }
                    CdsElement element = CdsModelUtils.element(rowType, ref);
                    return !element.isNotNull() && !element.isKey();
                }
            });
        }
        return select;
    }

    public static CqnSelect resolveExpands(CqnSelect select, CdsStructuredType target, boolean assocsInStar) {
        select = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new ExpandAllResolver(target));
        return (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new ExpandToOneResolver(target, null, assocsInStar));
    }

    public static boolean isToOnePath(CdsStructuredType rowType, List<? extends CqnReference.Segment> segments) {
        CdsStructuredType rt = rowType;
        for (CqnReference.Segment segment : segments) {
            String assoc = segment.id();
            if (assoc.equals("*")) {
                return false;
            }
            CdsType type = rt.getElement(assoc).getType();
            if (type.isAssociation() && !CdsModelUtils.isSingleValued(type)) {
                return false;
            }
            if (type.isStructured()) {
                rt = (CdsStructuredType)type.as(CdsStructuredType.class);
                continue;
            }
            rt = rt.getTargetOf(assoc);
        }
        return true;
    }

    public static boolean isOneToManyPath(CdsStructuredType rowType, List<? extends CqnReference.Segment> segments) {
        CdsStructuredType rt = rowType;
        boolean toMany = false;
        for (CqnReference.Segment segment : segments) {
            String assoc = segment.id();
            if (assoc.equals("*") || CdsModelUtils.isManyTo(rt.getElement(assoc).getType())) {
                return false;
            }
            if (!toMany && !CdsModelUtils.isSingleValued(rt.getElement(assoc).getType())) {
                toMany = true;
            }
            rt = rt.getTargetOf(assoc);
        }
        return toMany;
    }

    public static boolean isMediaType(CdsStructuredType type, CqnSelectListItem sli) {
        if (!sli.isRef()) {
            return false;
        }
        CdsElement element = CdsModelUtils.element(type, sli.asRef());
        return element.findAnnotation("Core.MediaType").isPresent();
    }

    @VisibleForTesting
    static <T extends CqnStatement> List<Map<String, Object>> getEntries(T s) {
        if (s.isInsert()) {
            return s.asInsert().entries();
        }
        if (s.isUpdate()) {
            return s.asUpdate().entries();
        }
        if (s.isUpsert()) {
            return s.asUpsert().entries();
        }
        return Collections.emptyList();
    }

    static <T extends CqnStatement> void setEntries(T s, List<Map<String, Object>> entries) {
        if (s instanceof XsertBuilder) {
            ((XsertBuilder)s).setEntries(entries);
        } else if (s instanceof UpdateBuilder) {
            ((UpdateBuilder)s).entries(entries);
        }
    }

    public static CqnPredicate linkKeysToOuterQuery(CdsStructuredType target) {
        return target.concreteNonAssociationElements().filter(e -> e.isKey() && !e.getName().equals("IsActiveEntity")).sorted(Comparator.comparing(CdsElement::getName)).map(e -> CqnStatementUtils.outerToInner(e.getName())).collect(Conjunction.and());
    }

    private static CqnPredicate outerToInner(String name) {
        ElementRef outer = ElementRefImpl.element("$outer", name);
        ElementRef inner = ElementRefImpl.element(name);
        return ComparisonPredicate.eq(outer, inner);
    }

    public static CqnSelect removeVirtualElements(CqnSelect select, final CdsStructuredType rowType) {
        Modifier modifier = new Modifier(){

            public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
                return items.stream().filter(i -> !this.isVirtual((CqnSelectListItem)i)).collect(Collectors.toList());
            }

            public List<CqnValue> groupBy(List<CqnValue> items) {
                return items.stream().filter(i -> !this.isVirtual((CqnValue)i)).collect(Collectors.toList());
            }

            public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
                return orderBy.stream().filter(o -> !this.isVirtual(o.value())).collect(Collectors.toList());
            }

            boolean isVirtual(CqnSelectListItem i) {
                return i.isValue() && this.isVirtual(i.asValue().value());
            }

            private boolean isVirtual(CqnValue value) {
                return value.isRef() && CdsModelUtils.element(rowType, value.asRef()).isVirtual();
            }
        };
        return SelectBuilder.copy(select, modifier, false);
    }

    public static Stream<CqnExpand> toManyExpands(CdsStructuredType type, List<? extends CqnSelectListItem> items) {
        return items.stream().filter(CqnSelectListItem::isExpand).map(CqnSelectListItem::asExpand).filter(e -> CqnStatementUtils.isOneToManyPath(type, e.ref().segments()));
    }

    public static CqnStructuredTypeRef targetRef(CqnSelect select) {
        if (select.from().isRef()) {
            return CqnStatementUtils.whereToInfixFilter(select.ref(), select.where()).asRef();
        }
        return null;
    }

    public static StructuredType<?> targetRef(CqnUpdate update) {
        return CqnStatementUtils.whereToInfixFilter(update.ref(), update.where());
    }

    private static StructuredType<?> whereToInfixFilter(CqnStructuredTypeRef ref, Optional<CqnPredicate> where) {
        StructuredType reference = CQL.to(RefSegmentImpl.copy(ref.segments()));
        where.ifPresent(w -> {
            Optional targetFilter = ref.targetSegment().filter();
            reference.filter((CqnPredicate)CQL.and((CqnPredicate)((CqnPredicate)targetFilter.orElse(CqnBoolLiteral.TRUE)), (CqnPredicate)w));
        });
        return reference;
    }

    public static boolean containsPathExpression(Optional<CqnPredicate> pred) {
        final AtomicBoolean path = new AtomicBoolean();
        pred.ifPresent(p -> p.accept(new CqnVisitor(){

            public void visit(CqnElementRef ref) {
                if (ref.segments().size() > 1) {
                    path.set(true);
                }
            }
        }));
        return path.get();
    }

    private static boolean containsParameters(Optional<CqnPredicate> pred) {
        final AtomicBoolean param = new AtomicBoolean();
        pred.ifPresent(p -> p.accept(new CqnVisitor(){

            public void visit(CqnParameter p) {
                param.set(true);
            }
        }));
        return param.get();
    }

    public static boolean hasInfixFilter(CqnReference ref) {
        for (CqnReference.Segment segment : ref.segments()) {
            if (!segment.filter().isPresent()) continue;
            return true;
        }
        return false;
    }

    public static CqnSelect anonymizeStatement(CqnSelect select) {
        return (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new Modifier(){

            public CqnValue literal(CqnLiteral<?> literal) {
                return ANONYM_MARKER;
            }

            public Predicate exists(Select<?> subQuery) {
                return CQL.exists((CqnSelect)CqnStatementUtils.anonymizeStatement(subQuery));
            }

            public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                ref.segments().forEach(segment -> segment.filter().ifPresent(filter -> {
                    if (filter instanceof CqnExistsSubquery) {
                        CqnSelect query = ((CqnExistsSubquery)filter).subquery();
                        segment.filter((CqnPredicate)new ExistsSubquery(CqnStatementUtils.anonymizeStatement(query)));
                    }
                }));
                return ref;
            }
        });
    }

    public static CqnSelect batchSelect(CqnSelect select, final List<Map<String, Object>> valueSets) {
        final boolean paramsInWhere = CqnStatementUtils.containsParameters(select.where());
        CqnSelect batchSelect = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new Modifier(){

            public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
                AtomicBoolean paramsReplaced = new AtomicBoolean();
                ref.segments().forEach(s -> {
                    if (CqnStatementUtils.containsParameters(s.filter())) {
                        if (paramsInWhere || paramsReplaced.getAndSet(true)) {
                            throw new UnsupportedOperationException("Batch select is only supported with parameters in one path segment filter or the where clause");
                        }
                        s.filter(ExpressionImpl.bindValues(s.filter(), valueSets));
                    }
                });
                return ref;
            }
        });
        CqnPredicate p = ExpressionImpl.bindValues(select.where(), valueSets);
        ((Select)batchSelect).where(p);
        return batchSelect;
    }

    private static final class ExpandToOneResolver
    implements Modifier {
        private final CdsStructuredType rowType;
        private final String prefix;
        private final boolean assocsInStar;

        private ExpandToOneResolver(CdsStructuredType rowType, String prefix, boolean assocsInStar) {
            this.rowType = rowType;
            this.prefix = prefix;
            this.assocsInStar = assocsInStar;
        }

        public CqnSelectListItem expand(Expand<?> expand) {
            List<CqnSelectListItem> resolved;
            CdsElement assoc;
            CdsEntity target;
            StructuredTypeRef ref = expand.ref();
            List segments = ref.segments();
            if (CqnStatementUtils.isToOnePath(this.rowType, segments) && this.selectsRefsOnly((CdsStructuredType)(target = ((CdsAssociationType)(assoc = CdsModelUtils.element(this.rowType, segments)).getType().as(CdsAssociationType.class)).getTarget()), resolved = CqnStatementUtils.resolveStar(expand.items(), Collections.emptyList(), (CdsStructuredType)target, this.assocsInStar))) {
                return this.resolveToOneExpand(assoc, expand.ref(), resolved, expand.alias().orElse(null));
            }
            return expand;
        }

        private boolean selectsRefsOnly(CdsStructuredType target, List<CqnSelectListItem> items) {
            return items.stream().allMatch(i -> this.isConcreteRef(target, (CqnSelectListItem)i));
        }

        private boolean isConcreteRef(CdsStructuredType target, CqnSelectListItem i) {
            if (i.isExpand()) {
                CqnExpand exp = i.asExpand();
                if (CqnStatementUtils.isToOnePath(target, exp.ref().segments())) {
                    CdsStructuredType expTarget = CdsModelUtils.target(target, exp.ref().segments());
                    List<CqnSelectListItem> items = CqnStatementUtils.resolveStar(exp.items(), Collections.emptyList(), expTarget, this.assocsInStar);
                    return this.selectsRefsOnly(expTarget, items);
                }
                return false;
            }
            if (!i.isValue()) {
                return false;
            }
            CqnValue value = i.asValue().value();
            if (value.isRef()) {
                CdsElement element = CdsModelUtils.element(target, value.asRef());
                if (element.isVirtual() && element.getType().isSimple()) {
                    return !element.defaultValue().isPresent();
                }
                return true;
            }
            return this.usesRef(value);
        }

        private boolean usesRef(CqnValue value) {
            final AtomicBoolean usesRef = new AtomicBoolean(false);
            value.accept(new CqnVisitor(){

                public void visit(CqnElementRef elementRef) {
                    usesRef.set(true);
                }
            });
            return usesRef.get();
        }

        private CqnSelectListItem resolveToOneExpand(CdsElement assoc, final StructuredTypeRef ref, List<CqnSelectListItem> items, final String expandAlias) {
            CdsEntity target = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).getTarget();
            final String refPath = expandAlias != null ? expandAlias : ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
            items = CqnStatementUtils.resolveStar(items, Collections.emptyList(), (CdsStructuredType)target, true);
            items = CqnStatementUtils.resolveVirtualElements(items, (CdsStructuredType)target);
            items = ExpressionVisitor.copy(items, new Modifier((CdsStructuredType)target){
                final /* synthetic */ CdsStructuredType val$target;
                {
                    this.val$target = cdsStructuredType;
                }

                public CqnSelectListItem selectListItem(Value<?> value, String alias) {
                    if (value.isExpression()) {
                        value = ExpressionVisitor.copy(value, new Modifier(){

                            public Value<?> ref(ElementRef<?> ref) {
                                ArrayList segments = new ArrayList(ref.segments());
                                segments.addAll(0, CQL.get((String)this.prefix(refPath)).segments());
                                return CQL.get(segments);
                            }
                        });
                    }
                    String expandName = expandAlias != null ? expandAlias : ref.lastSegment();
                    String elementName = alias != null ? alias : value.asRef().lastSegment();
                    return value.as(this.prefix(expandName) + "." + elementName);
                }

                private String prefix(String name) {
                    return prefix != null ? prefix + "." + name : name;
                }

                public CqnSelectListItem expand(Expand<?> expand) {
                    return new ExpandToOneResolver(this.val$target, this.prefix(refPath), assocsInStar).expand(expand);
                }
            });
            return CQL.to((List)ref.segments()).inline(items);
        }
    }

    private static final class ExpandAllResolver
    implements Modifier {
        private final CdsStructuredType rowType;

        private ExpandAllResolver(CdsStructuredType rowType) {
            this.rowType = rowType;
        }

        public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
            Iterator<CqnSelectListItem> iter = items.iterator();
            while (iter.hasNext()) {
                CqnSelectListItem sli = iter.next();
                if (!sli.isExpand() || !sli.asExpand().ref().firstSegment().equals("*")) continue;
                iter.remove();
                this.rowType.associations().forEach(a -> items.add((CqnSelectListItem)CQL.to((String)a.getName()).expand()));
                break;
            }
            return items;
        }
    }

    private static class AllElementsResolver {
        private CdsStructuredType rowType;

        AllElementsResolver(CdsStructuredType rowType) {
            this.rowType = rowType;
        }

        private Stream<String> mapPrefixToAllElements(List<? extends CqnReference.Segment> prefix) {
            CdsStructuredType currentEntity = this.rowType;
            for (CqnReference.Segment segment : prefix) {
                currentEntity = currentEntity.getTargetOf(segment.id());
            }
            return currentEntity.concreteNonAssociationElements().map(CdsElement::getName);
        }
    }

    public static interface LogicalOpertionsSimplifier
    extends Modifier {
        default public Predicate connective(CqnConnectivePredicate.Operator op, List<Predicate> predicates) {
            if (op == CqnConnectivePredicate.Operator.AND) {
                return predicates.stream().collect(Conjunction._and());
            }
            return predicates.stream().collect(Disjunction._or());
        }
    }

    public static interface Count {
        public static final CqnSelectListItem ALL = CQL.func((String)"COUNT", (CqnValue[])new CqnValue[]{CQL.plain((String)"*")}).type(Long.class).as("count");

        public long getCount();
    }

    private static class Simplifier
    implements NegationResolver,
    LogicalOpertionsSimplifier {
        private Simplifier() {
        }
    }

    public static interface NegationResolver
    extends Modifier {
        default public Predicate negation(Predicate p) {
            return p.not();
        }
    }
}

