/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NestedStructsResolver {
    private final CqnSelect select;
    private final CdsStructuredType structType;

    public NestedStructsResolver(CqnSelect select, CdsStructuredType structType) {
        this.select = select;
        this.structType = structType;
    }

    public CqnSelect resolve(boolean includeAssocs) {
        Stream resolvedItems = this.select.items().stream().flatMap(i -> NestedStructsResolver.resolveStructElements(this.structType, null, i, includeAssocs));
        return SelectBuilder.copy(this.select).columns(resolvedItems);
    }

    private static Stream<CqnSelectListItem> resolveStructElements(CdsStructuredType parentStructType, CqnSelectListValue parentSLV, CqnSelectListItem sli, boolean includeAssocs) {
        if (sli.isExpand()) {
            CqnExpand expand = sli.asExpand();
            if (!expand.ref().firstSegment().equals("*")) {
                CdsElement element = CdsModelUtils.element(parentStructType, expand.ref().segments());
                if (element.getType().isAssociation()) {
                    CdsEntity innerStructType = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
                    ExpandBuilder expandCopy = (ExpandBuilder)ExpressionVisitor.copy(expand, (Modifier)new CqnModifier(){});
                    expandCopy.items((Iterable)expand.items().stream().flatMap(arg_0 -> NestedStructsResolver.lambda$resolveStructElements$1((CdsStructuredType)innerStructType, includeAssocs, arg_0)).collect(Collectors.toList()));
                    return Stream.of(expandCopy);
                }
                if (element.getType().isStructured()) {
                    CdsStructuredType innerStructType = (CdsStructuredType)element.getType();
                    CqnSelectListValue slv = NestedStructsResolver.joinToSLV(parentSLV, expand.ref());
                    return expand.items().stream().flatMap(i -> NestedStructsResolver.resolveStructElements(innerStructType, slv, i, includeAssocs));
                }
            }
        } else {
            if (sli.isRef()) {
                CdsElement element = CdsModelUtils.element(parentStructType, sli.asRef());
                CqnSelectListValue slv = NestedStructsResolver.joinToSLV(parentSLV, sli.asValue());
                if (element.getType().isStructured()) {
                    return CqnStatementUtils.structureOf(element, includeAssocs).map(e -> NestedStructsResolver.joinToSLV(slv, e.subList(1, e.size())));
                }
                return Stream.of(slv);
            }
            if (sli.isStar() && !(parentStructType instanceof CdsEntity)) {
                return CqnStatementUtils.elementsOf(parentStructType, includeAssocs).map(e -> NestedStructsResolver.joinToSLV(parentSLV, e));
            }
        }
        return Stream.of(sli);
    }

    private static CqnSelectListItem joinToSLV(CqnSelectListValue parentRef, List<String> path) {
        return NestedStructsResolver.joinToSLV(parentRef, CqnStatementUtils.elementRef(path));
    }

    private static CqnSelectListValue joinToSLV(CqnSelectListValue parentRef, CqnSelectListValue ref) {
        if (parentRef == null) {
            return ref;
        }
        return NestedStructsResolver.joinToSLV((CqnReference)parentRef.asRef(), parentRef.alias(), (CqnReference)ref.asRef(), ref.alias());
    }

    private static CqnSelectListValue joinToSLV(CqnSelectListValue parentRef, CqnStructuredTypeRef ref) {
        if (parentRef == null) {
            return NestedStructsResolver.joinToSLV(null, null, (CqnReference)ref, ref.alias());
        }
        return NestedStructsResolver.joinToSLV((CqnReference)parentRef.asRef(), parentRef.alias(), (CqnReference)ref, ref.alias());
    }

    private static CqnSelectListValue joinToSLV(CqnReference parentRef, Optional<String> parentAlias, CqnReference ref, Optional<String> alias) {
        ArrayList segments = new ArrayList();
        ArrayList<String> aliases = new ArrayList<String>();
        if (parentRef != null) {
            segments.addAll(parentRef.segments());
            aliases.add(NestedStructsResolver.alias(parentRef, parentAlias));
        }
        segments.addAll(ref.segments());
        aliases.add(NestedStructsResolver.alias(ref, alias));
        return CQL.get(segments).as(String.join((CharSequence)".", aliases));
    }

    private static String alias(CqnReference ref, Optional<String> alias) {
        return alias.orElse(ref.segments().stream().map(s -> s.id()).collect(Collectors.joining(".")));
    }

    private static /* synthetic */ Stream lambda$resolveStructElements$1(CdsStructuredType innerStructType, boolean includeAssocs, CqnSelectListItem i) {
        return NestedStructsResolver.resolveStructElements(innerStructType, null, i, includeAssocs);
    }
}

