/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.util.SessionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class OnConditionAnalyzer {
    private final String associationName;
    private final boolean reverse;
    private final CqnPredicate on;
    private SessionContext sessionContext;

    public OnConditionAnalyzer(String associationName, CqnPredicate on, boolean reverse, SessionContext sessionContext) {
        this.associationName = associationName;
        this.reverse = reverse;
        this.on = on;
        this.sessionContext = sessionContext;
    }

    public OnConditionAnalyzer(String associationName, CqnPredicate on, boolean reverse) {
        this(associationName, on, reverse, SessionContext.create());
    }

    public OnConditionAnalyzer(CdsElement association, boolean reverse, SessionContext sessionContext) {
        this(association.getName(), OnConditionAnalyzer.onCondition(association), reverse, sessionContext);
    }

    public OnConditionAnalyzer(CdsElement association, boolean reverse) {
        this(association.getName(), OnConditionAnalyzer.onCondition(association), reverse);
    }

    private static CqnPredicate onCondition(CdsElement association) {
        AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
        return associationAnalyzer.getOnCondition(association);
    }

    public Map<String, CqnValue> getFkMapping() {
        TreeMap<String, CqnValue> mapping = new TreeMap<String, CqnValue>();
        this.fkMapping((fk, pk) -> {
            if (fk.isRef()) {
                String key = ((CqnReference)fk).segments().stream().map(s -> s.id()).filter(s -> !this.associationName.equals(s)).collect(Collectors.joining("."));
                mapping.put(key, (CqnValue)pk);
            }
        });
        return mapping;
    }

    private void fkMapping(final BiConsumer<CqnValue, CqnValue> consumer) {
        CqnVisitor v = new CqnVisitor(){

            public void visit(CqnComparisonPredicate cmp) {
                if (!cmp.operator().equals((Object)CqnComparisonPredicate.Operator.EQ)) {
                    throw new UnsupportedOperationException("expecting comparison predicate \"=\"");
                }
                CqnValue lhs = cmp.left();
                CqnValue rhs = cmp.right();
                if (OnConditionAnalyzer.this.isRefToTarget(rhs) ^ OnConditionAnalyzer.this.reverse) {
                    consumer.accept(lhs, rhs);
                } else {
                    consumer.accept(rhs, lhs);
                }
            }

            public void visit(CqnConnectivePredicate connective) {
                if (connective.operator() != CqnConnectivePredicate.Operator.AND) {
                    throw new UnsupportedOperationException("expecting 'and' operator");
                }
            }

            public void visit(CqnNegation neg) {
                throw new UnsupportedOperationException("expecting 'and' operator");
            }
        };
        this.on.accept(v);
    }

    public Map<String, Object> getFkValues(Map<String, Object> sourceObject) {
        HashMap<String, Object> fkValues = new HashMap<String, Object>();
        this.fkMapping((fk, pk) -> OnConditionAnalyzer.addMapping(sourceObject, this.sessionContext, fkValues, (CqnToken)fk, (CqnToken)pk));
        return fkValues;
    }

    public Map<String, Object> getParentPkValues() {
        HashMap<String, Object> pkValues = new HashMap<String, Object>();
        this.fkMapping((fk, pk) -> OnConditionAnalyzer.addMapping(Collections.emptyMap(), null, pkValues, (CqnToken)fk, (CqnToken)pk));
        return pkValues;
    }

    public CqnPredicate getTargetPredicate(CqnPredicate predicate) {
        final HashMap<String, String> pkToFkMap = new HashMap<String, String>();
        pkToFkMap.put("IsActiveEntity", "IsActiveEntity");
        this.fkMapping((fk, pk) -> this.addMapping(pkToFkMap, (CqnElementRef)pk, (CqnElementRef)fk));
        return ExpressionVisitor.copy(predicate, new Modifier(){

            public Value<?> ref(ElementRef<?> ref) {
                return ElementRefImpl.element((String)pkToFkMap.get(ref.lastSegment()));
            }
        });
    }

    private static void addMapping(Map<String, Object> sourceObject, SessionContext sessionContext, Map<String, Object> fkValues, CqnToken fkSide, CqnToken pkSide) {
        if (!(fkSide instanceof CqnElementRef)) {
            return;
        }
        String fk = OnConditionAnalyzer.ref(fkSide).lastSegment();
        Object value = OnConditionAnalyzer.val(sourceObject, sessionContext, pkSide);
        fkValues.put(fk, value);
    }

    private void addMapping(Map<String, String> values, CqnElementRef fkSide, CqnElementRef pkSide) {
        values.put(fkSide.lastSegment(), pkSide.lastSegment());
    }

    private static Object val(Map<String, Object> sourceObject, SessionContext sessionContext, CqnToken token) {
        if (token instanceof CqnElementRef) {
            CqnElementRef elRef = OnConditionAnalyzer.ref(token);
            Optional<SessionUtils.SessionContextVariable> sessionParameter = SessionUtils.getSessionParameter(elRef, sessionContext);
            if (sessionParameter.isPresent()) {
                return sessionParameter.get().getValueSupplier().get();
            }
            String pk = elRef.lastSegment();
            return sourceObject.get(pk);
        }
        if (token instanceof CqnLiteral) {
            return OnConditionAnalyzer.literal(token).value();
        }
        throw new UnsupportedOperationException();
    }

    private boolean isRefToTarget(CqnValue token) {
        if (!(token instanceof CqnElementRef)) {
            return false;
        }
        CqnElementRef ref = OnConditionAnalyzer.ref((CqnToken)token);
        return this.associationName.equals(ref.firstSegment());
    }

    private static CqnLiteral<Object> literal(CqnToken token) {
        return (CqnLiteral)token;
    }

    private static CqnElementRef ref(CqnToken token) {
        return (CqnElementRef)token;
    }
}

