/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.util;

import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.ProjectionResolver;

public class ProjectionProcessor {
    private final DataUtils dataUtils;
    private final CqnAnalyzer cqnAnalyzer;
    private final CdsModel model;

    private ProjectionProcessor(CdsModel model, CqnAnalyzer cqnAnalyzer, DataUtils dataUtils) {
        this.model = model;
        this.cqnAnalyzer = cqnAnalyzer;
        this.dataUtils = dataUtils;
    }

    public static ProjectionProcessor create(CdsModel model, CqnAnalyzer cqnAnalyzer, DataUtils dataUtils) {
        return new ProjectionProcessor(model, cqnAnalyzer, dataUtils);
    }

    public <T extends CqnStatement> T resolve(T statement) {
        CdsEntity target = this.cqnAnalyzer.analyze(statement.ref()).targetEntity();
        this.dataUtils.removeVirtualElements((CdsStructuredType)target, CqnStatementUtils.getEntries(statement));
        return this.resolveProjection(statement);
    }

    private <T extends CqnStatement> T resolveProjection(T cqn) {
        ProjectionResolver.BiPredicate isTable = (prev, stmnt) -> (Boolean)this.cqnAnalyzer.analyze(stmnt.ref()).targetEntity().getAnnotationValue("cds.persistence.table", (Object)false);
        return ProjectionResolver.create(this.model, cqn).condition(isTable).resolveAll().getResolvedStatement();
    }
}

