/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.google.common.annotations.Beta;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.Result;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.util.Map;

@Beta
public interface CdsDataProcessor {
    public static final Object ABSENT = new Object();

    public static CdsDataProcessor create() {
        return Cds4jServiceLoader.load(CdsDataProcessor.class);
    }

    public CdsDataProcessor addConverter(Filter var1, Converter var2);

    public CdsDataProcessor addGenerator(Filter var1, Generator var2);

    default public CdsDataProcessor addValidator(Filter filter, Validator validator) {
        return this.addValidator(filter, validator, Mode.CONTAINS);
    }

    public CdsDataProcessor addValidator(Filter var1, Validator var2, Mode var3);

    public void process(Map<String, Object> var1, CdsStructuredType var2);

    public void process(Iterable<? extends Map<String, Object>> var1, CdsStructuredType var2);

    default public void process(Result result) {
        this.process(result, result.rowType());
    }

    @FunctionalInterface
    @Beta
    public static interface Validator {
        public void validate(Path var1, CdsElement var2, Object var3);
    }

    @FunctionalInterface
    @Beta
    public static interface Generator {
        public Object generate(Path var1, CdsElement var2, boolean var3);
    }

    @FunctionalInterface
    @Beta
    public static interface Converter {
        public static final Object REMOVE = new Object();

        public Object convert(Path var1, CdsElement var2, Object var3);
    }

    @FunctionalInterface
    @Beta
    public static interface Filter {
        public boolean test(Path var1, CdsElement var2, CdsType var3);

        default public boolean test(Path path, CdsElement element) {
            return this.test(path, element, (CdsType)element.getType());
        }
    }

    public static enum Mode {
        DECLARED,
        CONTAINS,
        NOT_NULL,
        NULL;

    }
}

