/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.CdsException;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Stream;

public interface CdsModel {
    public static final Optional<Reader> reader = Cds4jServiceLoader.find(Reader.class);

    public static Reader reader() {
        return reader.orElseThrow(() -> new CdsException("Cannot find implementation for CDS Model Reader"));
    }

    public static CdsModel read(InputStream csn) {
        return CdsModel.reader().readCsn(csn);
    }

    public static CdsModel read(String csn) {
        return CdsModel.reader().readCsn(csn);
    }

    public Stream<CdsAnnotation<?>> annotations(String var1);

    public Stream<CdsService> services();

    public CdsService getService(String var1);

    public Optional<CdsService> findService(String var1);

    public Stream<CdsType> types();

    public <T extends CdsType> T getType(String var1);

    public <T extends CdsType> Optional<T> findType(String var1);

    public Stream<CdsEntity> entities();

    default public Stream<CdsEntity> concreteEntities() {
        return this.entities().filter(e -> !e.isAbstract());
    }

    public CdsEntity getEntity(String var1);

    public Optional<CdsEntity> findEntity(String var1);

    public Stream<CdsAction> actions();

    public CdsAction getAction(String var1);

    public Optional<CdsAction> findAction(String var1);

    public Stream<CdsFunction> functions();

    public CdsFunction getFunction(String var1);

    public Optional<CdsFunction> findFunction(String var1);

    public Stream<CdsEvent> events();

    public CdsEvent getEvent(String var1);

    public Optional<CdsEvent> findEvent(String var1);

    public Stream<CdsStructuredType> structuredTypes();

    public CdsStructuredType getStructuredType(String var1);

    public Optional<CdsStructuredType> findStructuredType(String var1);

    public Stream<CdsStructuredType> aspects();

    public CdsStructuredType getAspect(String var1);

    public Optional<CdsStructuredType> findAspect(String var1);

    public <T> T getMeta(String var1);

    public String getVersion();

    default public void accept(CdsVisitor visitor) {
        this.services().forEach(s -> s.accept(visitor));
        this.types().forEach(t -> t.accept(visitor));
        this.entities().forEach(e -> e.accept(visitor));
        this.events().forEach(e -> e.accept(visitor));
        this.actions().forEach(e -> e.accept(visitor));
        this.functions().forEach(e -> e.accept(visitor));
        visitor.visit(this);
    }

    public static interface Reader {
        public CdsModel readCsn(InputStream var1);

        public CdsModel readCsn(String var1);
    }
}

