/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class Gauges<T> {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final Function<Meter.Id, T> tSupplier;
    private final ToDoubleFunction<T> dGetter;
    private final MeterRegistry registry;
    private final ConcurrentMap<Meter.Id, Object> gauges;

    public Gauges(ConcurrentMap<Meter.Id, Object> gauges, String name, String description, Supplier<T> tSupplier, ToDoubleFunction<T> dGetter, MeterRegistry registry, Label ... keys) {
        this.gauges = gauges;
        this.name = name;
        this.description = description;
        this.tSupplier = id -> tSupplier.get();
        this.dGetter = dGetter;
        this.registry = registry;
        this.keys = keys;
    }

    public T get(String ... values) {
        return this.get((Iterable<Tag>)null, values);
    }

    public T get(Iterable<Tag> customTags, String ... values) {
        Meter.Id meterId;
        Tags tags = Tags.of(Labels.toTags(this.keys, values)).and(customTags);
        ValueSupplier<T> supplier = new ValueSupplier<T>(this.gauges, this.dGetter);
        Gauge gauge = Gauge.builder((String)this.name, supplier).description(this.description).tags((Iterable)tags).strongReference(true).register(this.registry);
        supplier.id = meterId = gauge.getId();
        return (T)this.gauges.computeIfAbsent(meterId, this.tSupplier);
    }

    private static class ValueSupplier<G>
    implements Supplier<Number> {
        final ConcurrentMap<Meter.Id, Object> gauges;
        final ToDoubleFunction<G> toDoubleFunc;
        volatile Meter.Id id;

        ValueSupplier(ConcurrentMap<Meter.Id, Object> gauges, ToDoubleFunction<G> toDoubleFunc) {
            this.gauges = gauges;
            this.toDoubleFunc = toDoubleFunc;
        }

        @Override
        public Number get() {
            Object o;
            Meter.Id key = this.id;
            if (key != null && (o = this.gauges.get(key)) != null) {
                return this.toDoubleFunc.applyAsDouble(o);
            }
            return 0.0;
        }
    }
}

