/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import io.vertx.ext.cluster.infinispan.impl.InfinispanAsyncMapImpl;
import io.vertx.ext.cluster.infinispan.impl.InfinispanCounter;
import io.vertx.ext.cluster.infinispan.impl.InfinispanLock;
import io.vertx.ext.cluster.infinispan.impl.SubsCacheHelper;
import io.vertx.ext.cluster.infinispan.impl.SubsOpSerializer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.context.Flag;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.stack.Protocol;

public class InfinispanClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(InfinispanClusterManager.class);
    private static final String VERTX_INFINISPAN_CONFIG_PROP_NAME = "vertx.infinispan.config";
    private static final String INFINISPAN_XML = "infinispan.xml";
    private static final String DEFAULT_INFINISPAN_XML = "default-infinispan.xml";
    private static final String VERTX_JGROUPS_CONFIG_PROP_NAME = "vertx.jgroups.config";
    private static final String JGROUPS_XML = "jgroups.xml";
    private final String ispnConfigPath;
    private final String jgroupsConfigPath;
    private final boolean userProvidedCacheManager;
    private VertxInternal vertx;
    private NodeSelector nodeSelector;
    private DefaultCacheManager cacheManager;
    private NodeListener nodeListener;
    private EmbeddedClusteredLockManager lockManager;
    private CounterManager counterManager;
    private NodeInfo nodeInfo;
    private AdvancedCache<String, byte[]> nodeInfoCache;
    private SubsCacheHelper subsCacheHelper;
    private volatile boolean active;
    private ClusterViewListener viewListener;

    public InfinispanClusterManager() {
        this.ispnConfigPath = System.getProperty(VERTX_INFINISPAN_CONFIG_PROP_NAME, INFINISPAN_XML);
        this.jgroupsConfigPath = System.getProperty(VERTX_JGROUPS_CONFIG_PROP_NAME, JGROUPS_XML);
        this.userProvidedCacheManager = false;
    }

    public InfinispanClusterManager(DefaultCacheManager cacheManager) {
        Objects.requireNonNull(cacheManager, "cacheManager");
        this.cacheManager = cacheManager;
        this.ispnConfigPath = null;
        this.jgroupsConfigPath = null;
        this.userProvidedCacheManager = true;
    }

    public void init(Vertx vertx, NodeSelector nodeSelector) {
        this.vertx = (VertxInternal)vertx;
        this.nodeSelector = nodeSelector;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheManager;
    }

    public <K, V> void getAsyncMap(String name, Promise<AsyncMap<K, V>> promise) {
        this.vertx.executeBlocking(prom -> {
            EmbeddedCacheManagerAdmin administration = (EmbeddedCacheManagerAdmin)this.cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE});
            Cache cache = administration.getOrCreateCache(name, "__vertx.distributed.cache.configuration");
            prom.complete(new InfinispanAsyncMapImpl(this.vertx, (Cache<byte[], byte[]>)cache));
        }, false, promise);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.cacheManager.getCache(name);
    }

    public void getLockWithTimeout(String name, long timeout, Promise<Lock> promise) {
        this.vertx.executeBlocking(prom -> {
            if (!this.lockManager.isDefined(name)) {
                this.lockManager.defineLock(name);
            }
            prom.complete((Object)this.lockManager.get(name));
        }, false, ar -> {
            if (ar.succeeded()) {
                this.tryLock((ClusteredLock)ar.result(), name, timeout, promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    private void tryLock(ClusteredLock lock, String name, long timeout, Promise<Lock> promise) {
        lock.tryLock(timeout, TimeUnit.MILLISECONDS).whenComplete((locked, throwable) -> {
            if (throwable == null) {
                if (locked.booleanValue()) {
                    promise.complete((Object)new InfinispanLock(lock));
                } else {
                    promise.fail("Timed out waiting to get lock " + name);
                }
            } else {
                promise.fail(throwable);
            }
        });
    }

    public void getCounter(String name, Promise<Counter> promise) {
        this.vertx.executeBlocking(prom -> {
            if (!this.counterManager.isDefined(name)) {
                this.counterManager.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
            }
            prom.complete((Object)new InfinispanCounter((Vertx)this.vertx, this.counterManager.getStrongCounter(name).sync()));
        }, false, promise);
    }

    public String getNodeId() {
        return this.cacheManager.getNodeAddress();
    }

    public List<String> getNodes() {
        return this.cacheManager.getTransport().getMembers().stream().map(Object::toString).collect(Collectors.toList());
    }

    public synchronized void nodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInfo(NodeInfo nodeInfo, Promise<Void> promise) {
        InfinispanClusterManager infinispanClusterManager = this;
        synchronized (infinispanClusterManager) {
            this.nodeInfo = nodeInfo;
        }
        byte[] value = DataConverter.toCachedObject(nodeInfo);
        Future.fromCompletionStage((CompletionStage)this.nodeInfoCache.withFlags(Flag.IGNORE_RETURN_VALUES).putAsync((Object)this.getNodeId(), (Object)value)).mapEmpty().onComplete(promise);
    }

    public synchronized NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void getNodeInfo(String nodeId, Promise<NodeInfo> promise) {
        this.nodeInfoCache.getAsync((Object)nodeId).whenComplete((nodeInfo, throwable) -> {
            if (throwable != null) {
                promise.fail(throwable);
            } else if (nodeInfo == null) {
                promise.fail("Not a member of the cluster");
            } else {
                promise.complete(DataConverter.fromCachedObject(nodeInfo));
            }
        });
    }

    public void join(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            if (this.active) {
                prom.complete();
                return;
            }
            this.active = true;
            if (!this.userProvidedCacheManager) {
                try {
                    FileLookup fileLookup = FileLookupFactory.newInstance();
                    URL ispnConfig = fileLookup.lookupFileLocation(this.ispnConfigPath, this.getCTCCL());
                    if (ispnConfig == null) {
                        log.warn((Object)("Cannot find Infinispan config '" + this.ispnConfigPath + "', using default"));
                        ispnConfig = fileLookup.lookupFileLocation(DEFAULT_INFINISPAN_XML, this.getCTCCL());
                    }
                    ConfigurationBuilderHolder builderHolder = new ParserRegistry().parse(ispnConfig);
                    ClassLoader classLoader = this.getCTCCL();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    builderHolder.getGlobalConfigurationBuilder().classLoader(classLoader);
                    if (fileLookup.lookupFileLocation(this.jgroupsConfigPath, this.getCTCCL()) != null) {
                        log.warn((Object)("Forcing JGroups config to '" + this.jgroupsConfigPath + "'"));
                        builderHolder.getGlobalConfigurationBuilder().transport().defaultTransport().removeProperty("channelConfigurator").addProperty("configurationFile", (Object)this.jgroupsConfigPath);
                    }
                    this.cacheManager = new DefaultCacheManager(builderHolder, true);
                }
                catch (IOException e) {
                    prom.fail((Throwable)e);
                    return;
                }
            }
            this.viewListener = new ClusterViewListener();
            this.cacheManager.addListener((Object)this.viewListener);
            try {
                this.subsCacheHelper = new SubsCacheHelper(this.vertx, this.cacheManager, this.nodeSelector);
                this.nodeInfoCache = this.cacheManager.getCache("__vertx.nodeInfo").getAdvancedCache();
                this.lockManager = (EmbeddedClusteredLockManager)EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)this.cacheManager);
                this.counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager);
                prom.complete();
            }
            catch (Exception e) {
                prom.fail((Throwable)e);
            }
        }, false, promise);
    }

    private ClassLoader getCTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void leave(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            if (!this.active) {
                prom.complete();
                return;
            }
            this.active = false;
            this.subsCacheHelper.close();
            this.cacheManager.removeListener((Object)this.viewListener);
            if (!this.userProvidedCacheManager) {
                this.cacheManager.stop();
            }
            prom.complete();
        }, false, promise);
    }

    public boolean isActive() {
        return this.active;
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsCacheHelper::put, address, registrationInfo, promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        SubsOpSerializer serializer = SubsOpSerializer.get(this.vertx.getOrCreateContext());
        serializer.execute(this.subsCacheHelper::remove, address, registrationInfo, promise);
    }

    public void getRegistrations(String address, Promise<List<RegistrationInfo>> promise) {
        Future.fromCompletionStage(this.subsCacheHelper.get(address)).onComplete(promise);
    }

    public String clusterHost() {
        return this.getHostFromTransportProtocol("bind_addr");
    }

    public String clusterPublicHost() {
        return this.getHostFromTransportProtocol("external_addr");
    }

    private String getHostFromTransportProtocol(String fieldName) {
        JGroupsTransport transport = (JGroupsTransport)this.cacheManager.getTransport();
        Protocol bottomProtocol = transport.getChannel().getProtocolStack().getBottomProtocol();
        try {
            InetAddress external_addr = (InetAddress)bottomProtocol.getValue(fieldName);
            String str = external_addr.toString();
            if (str.charAt(0) == '/') {
                return str.substring(1);
            }
            return str.substring(0, str.indexOf(47));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private boolean isMaster() {
        return this.cacheManager.isCoordinator();
    }

    private void cleanSubs(List<Address> removed) {
        removed.stream().map(Object::toString).forEach(this.subsCacheHelper::removeAllForNode);
    }

    private void cleanNodeInfos(List<Address> removed) {
        removed.stream().map(Object::toString).forEach(arg_0 -> this.nodeInfoCache.remove(arg_0));
    }

    @Listener(sync=false)
    private class ClusterViewListener {
        private ClusterViewListener() {
        }

        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            this.handleViewChangeInternal(e);
        }

        @Merged
        public void handleMerge(MergeEvent e) {
            this.handleViewChangeInternal((ViewChangedEvent)e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleViewChangeInternal(ViewChangedEvent e) {
            InfinispanClusterManager infinispanClusterManager = InfinispanClusterManager.this;
            synchronized (infinispanClusterManager) {
                if (!InfinispanClusterManager.this.active) {
                    return;
                }
                ArrayList added = new ArrayList(e.getNewMembers());
                added.removeAll(e.getOldMembers());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Members added = " + added));
                }
                added.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeAdded(address.toString());
                    }
                });
                ArrayList removed = new ArrayList(e.getOldMembers());
                removed.removeAll(e.getNewMembers());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Members removed = " + removed));
                }
                if (InfinispanClusterManager.this.isMaster()) {
                    InfinispanClusterManager.this.cleanSubs(removed);
                    InfinispanClusterManager.this.cleanNodeInfos(removed);
                }
                removed.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeLeft(address.toString());
                    }
                });
            }
        }
    }
}

