/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

public abstract class AbstractStringConverter
extends Converter {
    protected AbstractStringConverter(int id) {
        super(id, QueryDataTypeFamily.VARCHAR);
    }

    @Override
    public Class<?> getNormalizedValueClass() {
        return String.class;
    }

    @Override
    public final boolean asBoolean(Object val) {
        String val0 = this.cast(val);
        if (val0.equalsIgnoreCase("true")) {
            return true;
        }
        if (val0.equalsIgnoreCase("false")) {
            return false;
        }
        throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.BOOLEAN);
    }

    @Override
    public final byte asTinyint(Object val) {
        try {
            return Byte.parseByte(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TINYINT);
        }
    }

    @Override
    public final short asSmallint(Object val) {
        try {
            return Short.parseShort(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.SMALLINT);
        }
    }

    @Override
    public final int asInt(Object val) {
        try {
            return Integer.parseInt(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.INTEGER);
        }
    }

    @Override
    public final long asBigint(Object val) {
        try {
            return Long.parseLong(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.BIGINT);
        }
    }

    @Override
    public final BigDecimal asDecimal(Object val) {
        try {
            return new BigDecimal(this.cast(val), ExpressionMath.DECIMAL_MATH_CONTEXT);
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DECIMAL);
        }
    }

    @Override
    public final float asReal(Object val) {
        try {
            return Float.parseFloat(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.REAL);
        }
    }

    @Override
    public final double asDouble(Object val) {
        try {
            return Double.parseDouble(this.cast(val));
        }
        catch (NumberFormatException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DOUBLE);
        }
    }

    @Override
    public final String asVarchar(Object val) {
        return this.cast(val);
    }

    @Override
    public final LocalDate asDate(Object val) {
        try {
            return LocalDate.parse(this.cast(val));
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.DATE);
        }
    }

    @Override
    public final LocalTime asTime(Object val) {
        try {
            return LocalTime.parse(this.cast(val));
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIME);
        }
    }

    @Override
    public final LocalDateTime asTimestamp(Object val) {
        try {
            return LocalDateTime.parse(this.cast(val));
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIMESTAMP);
        }
    }

    @Override
    public final OffsetDateTime asTimestampWithTimezone(Object val) {
        try {
            return OffsetDateTime.parse(this.cast(val));
        }
        catch (DateTimeParseException e) {
            throw AbstractStringConverter.cannotParseError(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        }
    }

    @Override
    public final Object asObject(Object val) {
        return this.asVarchar(val);
    }

    @Override
    public final Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asVarchar(val);
    }

    protected abstract String cast(Object var1);

    private static QueryException cannotParseError(QueryDataTypeFamily target) {
        String message = "Cannot parse " + (Object)((Object)QueryDataTypeFamily.VARCHAR) + " value to " + (Object)((Object)target);
        return QueryException.error(2000, message);
    }
}

