/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.builder.model.ComparisonPredicate;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.Connectors;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSyntaxException;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssociationAnalyzer {
    public static boolean referencesPKs(CdsElement association) {
        CdsAssociationType assocType = (CdsAssociationType)association.getType().as(CdsAssociationType.class);
        boolean reverse = CdsModelUtils.isReverseAssociation(association);
        Set targetKeys = assocType.getTarget().keyElements().map(CdsElement::getQualifiedName).collect(Collectors.toSet());
        Set referenced = new OnConditionAnalyzer(association, reverse).getFkMapping().values().stream().map(v -> v.isRef() ? CdsModelUtils.element((CdsStructuredType)association.getDeclaringType(), v.asRef()).getQualifiedName() : "<value>").collect(Collectors.toSet());
        return referenced.equals(targetKeys);
    }

    public CqnPredicate getOnCondition(CdsElement association) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        Optional on = assoc.onCondition();
        if (on.isPresent()) {
            return this.resolveOnCondition((CqnPredicate)on.get(), association);
        }
        return AssociationAnalyzer.managedOn(association);
    }

    private Value<?> fkValue(CqnElementRef assocRef, CdsElement association) {
        int index;
        List<Object> prefix;
        List s = assocRef.segments();
        int size = s.size();
        StringJoiner fkValue = new StringJoiner("_");
        if (size == 2) {
            fkValue.add(assocRef.firstSegment());
            fkValue.add(assocRef.lastSegment());
            prefix = Collections.emptyList();
        } else if (assocRef.firstSegment().equals(association.getName())) {
            for (index = 1; index < size; ++index) {
                fkValue.add(((CqnReference.Segment)s.get(index)).id());
            }
            prefix = s.subList(0, 1);
        } else {
            for (index = 0; index < size; ++index) {
                fkValue.add(((CqnReference.Segment)s.get(index)).id());
            }
            prefix = s.subList(0, 1);
        }
        String fkName = fkValue.toString();
        return ElementRefImpl.element(prefix, ElementRefImpl.element(fkName));
    }

    private boolean isAssociation(CqnElementRef ref, CdsElement assocEl) {
        CdsStructuredType type = (CdsStructuredType)assocEl.getDeclaringType();
        String firstSegment = ref.firstSegment();
        String assocName = assocEl.getName();
        return type.associations().map(CdsElement::getName).anyMatch(n -> !n.equals(assocName) && n.equals(firstSegment));
    }

    private CqnPredicate resolveOnCondition(CqnPredicate on, CdsElement association) {
        on = ExpressionVisitor.copy(on, (Modifier)new SelfResolver(association));
        return on;
    }

    private static CqnPredicate managedOn(CdsElement association) {
        return (CqnPredicate)AssociationAnalyzer.refElements(association).sorted(Comparator.comparing(CdsElement::getName)).map(key -> AssociationAnalyzer.eqForward(association.getName(), key, key.getName())).collect(Connectors.and());
    }

    public static Stream<CdsElement> refElements(CdsElement association) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType().as(CdsAssociationType.class);
        CdsEntity target = assoc.getTarget();
        return assoc.refs().map(AssociationAnalyzer::singleSegment).map(arg_0 -> ((CdsEntity)target).getElement(arg_0));
    }

    private static String singleSegment(CqnElementRef ref) {
        if (ref.segments().size() == 1) {
            return ref.firstSegment();
        }
        throw new UnsupportedOperationException("Key reference with more than one segment: " + ref);
    }

    private static Predicate eqForward(String assoc, CdsElement key, String keyName) {
        if (key.getType().isAssociation()) {
            return AssociationAnalyzer.refElements(key).map(k -> AssociationAnalyzer.eqForward(assoc, k, AssociationAnalyzer.fkName(keyName, k.getName()))).collect(Connectors.and());
        }
        ElementRef lhs = ElementRefImpl.element(AssociationAnalyzer.fkName(assoc, keyName));
        ElementRef rhs = ElementRefImpl.element(assoc, keyName);
        return ComparisonPredicate.eq(lhs, rhs);
    }

    private static String fkName(String association, String element) {
        return association + "_" + element;
    }

    private final class SelfResolver
    implements Modifier {
        private final CdsElement association;

        private SelfResolver(CdsElement association) {
            this.association = association;
        }

        private boolean sameTarget(CdsType left, CdsType right) {
            if (left.isAssociation() && right.isAssociation()) {
                return ((CdsAssociationType)left.as(CdsAssociationType.class)).getTarget().getQualifiedName().equals(((CdsAssociationType)right.as(CdsAssociationType.class)).getTarget().getQualifiedName());
            }
            return false;
        }

        private Predicate compare(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            if (rhs.isRef() && lhs.isRef()) {
                CqnElementRef lhsRef = lhs.asRef();
                CqnElementRef rhsRef = rhs.asRef();
                Optional<CdsElement> left = CdsModelUtils.findElement((CdsStructuredType)this.association.getDeclaringType(), lhsRef);
                Optional<CdsElement> right = CdsModelUtils.findElement((CdsStructuredType)this.association.getDeclaringType(), rhsRef);
                if (left.isPresent() && right.isPresent()) {
                    CdsElement leftElement = left.get();
                    CdsElement rightElement = right.get();
                    if (this.sameTarget(leftElement.getType(), rightElement.getType())) {
                        Iterator<CqnElementRef> lhsIter = this.predicateRefs(leftElement, lhsRef);
                        Iterator<CqnElementRef> rhsIter = this.predicateRefs(rightElement, rhsRef);
                        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                        while (lhsIter.hasNext() && rhsIter.hasNext()) {
                            lhs = AssociationAnalyzer.this.fkValue(lhsIter.next(), this.association);
                            rhs = AssociationAnalyzer.this.fkValue(rhsIter.next(), this.association);
                            predicates.add(CQL.comparison((CqnValue)lhs, (CqnComparisonPredicate.Operator)op, (CqnValue)rhs));
                        }
                        return predicates.stream().collect(Conjunction._and());
                    }
                    if (AssociationAnalyzer.this.isAssociation(lhsRef, this.association) || AssociationAnalyzer.this.isAssociation(rhsRef, this.association)) {
                        lhs = AssociationAnalyzer.this.fkValue(lhsRef, this.association);
                        rhs = AssociationAnalyzer.this.fkValue(rhsRef, this.association);
                    }
                }
            }
            return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, rhs);
        }

        private Iterator<CqnElementRef> predicateRefs(CdsElement assocElement, CqnElementRef ref) {
            Stream<CqnElementRef> refs = CdsModelUtils.resolveManagedToOneAssociationMapping(assocElement).flatMap(map -> map.values().stream()).map(s -> {
                if (ref.firstSegment().equals(this.association.getName())) {
                    s.add(0, ref.firstSegment());
                }
                return ElementRefImpl.element(s.toArray(new String[0]));
            });
            return refs.iterator();
        }

        public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            if (this.isSelfRef((CqnValue)lhs)) {
                this.assertEqRef(op, (CqnValue)rhs);
                return this.self(this.association, (CqnReference)rhs.asRef());
            }
            if (this.isSelfRef((CqnValue)rhs)) {
                this.assertEqRef(op, (CqnValue)lhs);
                return this.self(this.association, (CqnReference)lhs.asRef());
            }
            return this.compare(lhs, op, rhs);
        }

        private void assertEqRef(CqnComparisonPredicate.Operator op, CqnValue val) {
            if (op != CqnComparisonPredicate.Operator.EQ || !val.isRef()) {
                throw new CqnSyntaxException("$self must be compared with '=' ref");
            }
        }

        private boolean isSelfRef(CqnValue value) {
            if (!value.isRef()) {
                return false;
            }
            return this.isSelfRef(value.asRef());
        }

        private boolean isSelfRef(CqnElementRef ref) {
            if (ref.segments().size() == 1) {
                return "$self".equals(ref.firstSegment());
            }
            return false;
        }

        private Predicate self(CdsElement association, CqnReference backlink) {
            String backlinkName;
            String assocName = association.getName();
            if (!backlink.firstSegment().equals(assocName) || backlink.segments().size() != 2) {
                throw new UnsupportedOperationException("Unsupported on condition in association " + association.getDeclaringType() + "." + association);
            }
            CdsEntity entity = (CdsEntity)association.getDeclaringType();
            CdsEntity assocTarget = (CdsEntity)entity.getTargetOf(assocName);
            CdsElement backLinkAssoc = assocTarget.getAssociation(backlinkName = ((CqnReference.Segment)backlink.segments().get(1)).id());
            Optional backlinkOn = ((CdsAssociationType)backLinkAssoc.getType().as(CdsAssociationType.class)).onCondition();
            if (backlinkOn.isPresent()) {
                return this.backlinkOn(assocName, backlinkName, (CqnPredicate)backlinkOn.get());
            }
            return AssociationAnalyzer.refElements(backLinkAssoc).sorted(Comparator.comparing(CdsElement::getName)).map(key -> this.eqReverse(assocName, backlinkName, (CdsElement)key, key.getName())).collect(Connectors.and());
        }

        private Predicate backlinkOn(final String assocName, final String backlinkName, CqnPredicate on) {
            return ExpressionVisitor.copy(on, new Modifier(){

                public Value<?> ref(ElementRef<?> ref) {
                    if (ref.firstSegment().equals(backlinkName)) {
                        return ElementRefImpl.element(ref.lastSegment());
                    }
                    return ElementRefImpl.element(assocName, ref.firstSegment());
                }
            });
        }

        private Predicate eqReverse(String assoc, String backlinkName, CdsElement key, String keyName) {
            if (key.getType().isAssociation()) {
                return AssociationAnalyzer.refElements(key).map(k -> this.eqReverse(assoc, backlinkName, (CdsElement)k, AssociationAnalyzer.fkName(keyName, k.getName()))).collect(Connectors.and());
            }
            ElementRef lhs = ElementRefImpl.element(assoc, AssociationAnalyzer.fkName(backlinkName, keyName));
            ElementRef rhs = ElementRefImpl.element(keyName);
            return ComparisonPredicate.eq(lhs, rhs);
        }
    }
}

